/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.motionseries.sims.rampforcesandmotion.robotmovingcompany;

import edu.colorado.phet.motionseries.MotionSeriesDefaults$;
import edu.colorado.phet.motionseries.model.MotionSeriesModel;
import edu.colorado.phet.motionseries.model.MotionSeriesObject;
import edu.colorado.phet.motionseries.model.MotionSeriesObjectType;
import edu.colorado.phet.motionseries.sims.rampforcesandmotion.robotmovingcompany.Cliff;
import edu.colorado.phet.motionseries.sims.rampforcesandmotion.robotmovingcompany.NotEnoughEnergyToPush;
import edu.colorado.phet.motionseries.sims.rampforcesandmotion.robotmovingcompany.OutOfEnergy;
import edu.colorado.phet.motionseries.sims.rampforcesandmotion.robotmovingcompany.Result;
import edu.colorado.phet.motionseries.sims.rampforcesandmotion.robotmovingcompany.RobotMovingCompanyGameModel$;
import edu.colorado.phet.motionseries.sims.rampforcesandmotion.robotmovingcompany.RobotMovingCompanyGameModel$listener$3$;
import edu.colorado.phet.motionseries.sims.rampforcesandmotion.robotmovingcompany.RobotMovingCompanyGameModel$listener$4$;
import edu.colorado.phet.scalacommon.ScalaClock;
import edu.colorado.phet.scalacommon.math.Vector2D;
import edu.colorado.phet.scalacommon.util.Observable;
import edu.colorado.phet.scalacommon.util.Observable$class;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.VolatileObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RobotMovingCompanyGameModel
implements Observable {
    private final MotionSeriesModel model;
    private final double initAngle;
    private final double appliedForceAmount;
    private final List<MotionSeriesObjectType> objectList;
    private final double DEFAULT_ROBOT_ENERGY;
    private final double energyScale;
    private double edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_robotEnergy;
    private final double airborneFloor;
    private boolean _launched;
    private int _objectIndex;
    private final HashMap<MotionSeriesObjectType, Result> resultMap;
    private final ArrayBuffer<Function2<MotionSeriesObject, MotionSeriesObjectType, BoxedUnit>> objectCreatedListeners;
    private final ArrayBuffer<Function2<MotionSeriesObjectType, Result, BoxedUnit>> itemFinishedListeners;
    private final ArrayBuffer<Function0<BoxedUnit>> gameFinishListeners;
    private final int housePosition;
    private final MotionSeriesObject house;
    private final MotionSeriesObject door;
    private double edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_doorOpenAmount;
    private final ArrayBuffer<Function0<BoxedUnit>> doorListeners;
    private final MotionSeriesObject doorBackground;
    private MotionSeriesObject edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_motionSeriesObject;
    private final Function0<BoxedUnit> doorHandler;
    private final ArrayBuffer<MotionSeriesObject> deliverList;
    private boolean edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_inputAllowed;
    private final ArrayBuffer<Function0<BoxedUnit>> edu$colorado$phet$scalacommon$util$Observable$$listeners;

    public MotionSeriesModel model() {
        return this.model;
    }

    public double appliedForceAmount() {
        return this.appliedForceAmount;
    }

    public List<MotionSeriesObjectType> objectList() {
        return this.objectList;
    }

    public double DEFAULT_ROBOT_ENERGY() {
        return this.DEFAULT_ROBOT_ENERGY;
    }

    public double energyScale() {
        return this.energyScale;
    }

    public final double edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_robotEnergy() {
        return this.edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_robotEnergy;
    }

    public final void edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_robotEnergy_$eq(double d) {
        this.edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_robotEnergy = d;
    }

    public double airborneFloor() {
        return this.airborneFloor;
    }

    private void _launched_$eq(boolean bl) {
        this._launched = bl;
    }

    private int _objectIndex() {
        return this._objectIndex;
    }

    private void _objectIndex_$eq(int n) {
        this._objectIndex = n;
    }

    public HashMap<MotionSeriesObjectType, Result> resultMap() {
        return this.resultMap;
    }

    public ArrayBuffer<Function2<MotionSeriesObject, MotionSeriesObjectType, BoxedUnit>> objectCreatedListeners() {
        return this.objectCreatedListeners;
    }

    public ArrayBuffer<Function2<MotionSeriesObjectType, Result, BoxedUnit>> itemFinishedListeners() {
        return this.itemFinishedListeners;
    }

    public ArrayBuffer<Function0<BoxedUnit>> gameFinishListeners() {
        return this.gameFinishListeners;
    }

    public int housePosition() {
        return this.housePosition;
    }

    public MotionSeriesObject house() {
        return this.house;
    }

    public MotionSeriesObject door() {
        return this.door;
    }

    public final double edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_doorOpenAmount() {
        return this.edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_doorOpenAmount;
    }

    public final void edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_doorOpenAmount_$eq(double d) {
        this.edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_doorOpenAmount = d;
    }

    public double doorOpenAmount() {
        return this.edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_doorOpenAmount();
    }

    public ArrayBuffer<Function0<BoxedUnit>> doorListeners() {
        return this.doorListeners;
    }

    public final MotionSeriesObject edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_motionSeriesObject() {
        return this.edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_motionSeriesObject;
    }

    private void edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_motionSeriesObject_$eq(MotionSeriesObject motionSeriesObject) {
        this.edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_motionSeriesObject = motionSeriesObject;
    }

    public MotionSeriesObject motionSeriesObject() {
        return this.edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_motionSeriesObject();
    }

    public double robotEnergy() {
        return this.edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_robotEnergy();
    }

    public boolean _inFrontOfDoor(MotionSeriesObject b) {
        double range = 1.15;
        double leftSide = this.door().position() - this.door().width() / 2.0 * 1.15;
        double rightSide = this.door().position() + this.door().width() / 2.0 * 1.15;
        return b.position() >= leftSide && b.position() <= rightSide;
    }

    public Function0<BoxedUnit> doorHandler() {
        return this.doorHandler;
    }

    public void resetAll() {
        this.model().rightRampSegment().setAngle(0.0);
        this.model().walls_$eq(false);
        this.model().leftRampSegment().startPoint_$eq(new Vector2D(-10.0, 0.0).rotate(-this.initAngle));
        this._launched_$eq(false);
        this.resultMap().clear();
        this.setObjectIndex(0);
    }

    public void setObjectIndex(int newIndex) {
        VolatileObjectRef listener$module$1 = new VolatileObjectRef(null);
        if (this.edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_motionSeriesObject() != null) {
            this.edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_motionSeriesObject().remove();
        }
        this._objectIndex_$eq(newIndex);
        this.edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_robotEnergy_$eq(this.DEFAULT_ROBOT_ENERGY());
        this.notifyListeners();
        MotionSeriesObjectType sel$1 = this.selectedObject();
        this.model().setPaused(true);
        this.edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_motionSeriesObject_$eq(new MotionSeriesObject(this.model(), -this.model().leftRampSegment().length() + sel$1.width() / 2.0 + this.model().leftWall().width() / 2.0, sel$1.width(), 3.0, true));
        this.motionSeriesObject().mass_$eq(sel$1.mass());
        this.motionSeriesObject().staticFriction_$eq(sel$1.staticFriction());
        this.motionSeriesObject().kineticFriction_$eq(sel$1.kineticFriction());
        this.motionSeriesObject().height_$eq(sel$1.height());
        this.motionSeriesObject().airborneFloor_$eq(this.airborneFloor());
        this.motionSeriesObject().crashListeners().$plus$eq(new Serializable(this, sel$1){
            public static final long serialVersionUID;
            private final RobotMovingCompanyGameModel $outer;
            private final MotionSeriesObjectType sel$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.itemLostOffCliff(this.sel$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.sel$1 = motionSeriesObjectType;
            }
        });
        LongRef lastPushTime$1 = new LongRef(0L);
        this.motionSeriesObject().stepListeners().$plus$eq((Object)this.listener$1(sel$1, lastPushTime$1, listener$module$1));
        this.edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_motionSeriesObject().workListeners().$plus$eq(new Serializable(this){
            public static final long serialVersionUID;
            private final RobotMovingCompanyGameModel $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(double work) {
                this.apply$mcVD$sp(work);
            }

            public void apply$mcVD$sp(double v1) {
                this.$outer.edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_robotEnergy_$eq(this.$outer.edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_robotEnergy() - Math.abs(v1));
                if (this.$outer.edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_robotEnergy() <= 0.0) {
                    this.$outer.edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_robotEnergy_$eq(0.0);
                    this.$outer.edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_motionSeriesObject().parallelAppliedForce_$eq(0.0);
                }
                this.$outer.notifyListeners();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.launched_$eq(false);
        this.objectCreatedListeners().foreach(new Serializable(this, sel$1){
            public static final long serialVersionUID;
            private final RobotMovingCompanyGameModel $outer;
            private final MotionSeriesObjectType sel$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Function2<MotionSeriesObject, MotionSeriesObjectType, BoxedUnit> function2) {
                function2.apply(this.$outer.motionSeriesObject(), this.sel$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.sel$1 = motionSeriesObjectType;
            }
        });
        this.motionSeriesObject().parallelAppliedForce_$eq(0.0);
    }

    public void launched_$eq(boolean b) {
        this._launched_$eq(b);
        this.notifyListeners();
    }

    public void nextObject() {
        this.setObjectIndex(this._objectIndex() + 1);
    }

    public void itemFinished(MotionSeriesObjectType o$1, Result r$1) {
        this.resultMap().$plus$eq((Tuple2)Predef$.MODULE$.any2ArrowAssoc(o$1).$minus$greater(r$1));
        this.itemFinishedListeners().foreach(new Serializable(this, o$1, r$1){
            public static final long serialVersionUID;
            private final MotionSeriesObjectType o$1;
            private final Result r$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Function2<MotionSeriesObjectType, Result, BoxedUnit> function2) {
                function2.apply(this.o$1, this.r$1);
            }
            {
                this.o$1 = motionSeriesObjectType;
                this.r$1 = result2;
            }
        });
        if (this.resultMap().size() == this.objectList().length()) {
            this.gameFinishListeners().foreach(new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Function0<BoxedUnit> function0) {
                    function0.apply$mcV$sp();
                }
            });
        }
        this.notifyListeners();
    }

    public boolean isLastObject(MotionSeriesObjectType o) {
        return this.objectList().apply(this.objectList().length() - 1) == o;
    }

    public void itemLostOffCliff(MotionSeriesObjectType o) {
        this.itemFinished(o, new Cliff(o.points(), (int)this.robotEnergy()));
    }

    public void itemLost(MotionSeriesObjectType o) {
        this.itemFinished(o, new OutOfEnergy(o.points(), (int)this.robotEnergy()));
    }

    public void itemStuck(MotionSeriesObjectType o) {
        this.itemFinished(o, new NotEnoughEnergyToPush(o.points(), (int)this.robotEnergy()));
    }

    public ArrayBuffer<MotionSeriesObject> deliverList() {
        return this.deliverList;
    }

    private boolean edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_inputAllowed() {
        return this.edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_inputAllowed;
    }

    public final void edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_inputAllowed_$eq(boolean bl) {
        this.edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_inputAllowed = bl;
    }

    public void inputAllowed_$eq(boolean b) {
        this.edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_inputAllowed_$eq(b);
    }

    public boolean inputAllowed() {
        return this.edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_inputAllowed();
    }

    public Object itemDelivered(MotionSeriesObjectType o$2, MotionSeriesObject motionSeriesObjectRef$1) {
        Object object;
        if (this.deliverList().contains(motionSeriesObjectRef$1)) {
            object = BoxedUnit.UNIT;
        } else {
            VolatileObjectRef listener$module$2 = new VolatileObjectRef(null);
            this.deliverList().$plus$eq((Object)motionSeriesObjectRef$1);
            object = this.model().stepListeners().$plus$eq((Object)this.listener$2(o$2, motionSeriesObjectRef$1, listener$module$2));
        }
        return object;
    }

    public int count(boolean b) {
        return b ? 1 : 0;
    }

    public int movedItems() {
        Iterable<Object> counts = this.resultMap().values().map(new Serializable(this){
            public static final long serialVersionUID;
            private final RobotMovingCompanyGameModel $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(Result v) {
                return this.$outer.count(v.success());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        return BoxesRunTime.unboxToInt(counts.foldLeft(BoxesRunTime.boxToInteger(0), new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(int n, int n2) {
                return this.apply$mcIII$sp(n, n2);
            }

            public int apply$mcIII$sp(int v1, int v2) {
                return v1 + v2;
            }
        }));
    }

    public MotionSeriesObjectType selectedObject() {
        return (MotionSeriesObjectType)this.objectList().apply(this._objectIndex());
    }

    public int lostItems() {
        Iterable<Object> counts = this.resultMap().values().map(new Serializable(this){
            public static final long serialVersionUID;
            private final RobotMovingCompanyGameModel $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(Result v) {
                return this.$outer.count(!v.success());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        return BoxesRunTime.unboxToInt(counts.foldLeft(BoxesRunTime.boxToInteger(0), new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(int n, int n2) {
                return this.apply$mcIII$sp(n, n2);
            }

            public int apply$mcIII$sp(int v1, int v2) {
                return v1 + v2;
            }
        }));
    }

    public int score() {
        Iterable<Object> scores = this.resultMap().values().map(new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(Result v) {
                return v.score();
            }
        }, Iterable$.MODULE$.canBuildFrom());
        return BoxesRunTime.unboxToInt(scores.foldLeft(BoxesRunTime.boxToInteger(0), new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(int n, int n2) {
                return this.apply$mcIII$sp(n, n2);
            }

            public int apply$mcIII$sp(int v1, int v2) {
                return v1 + v2;
            }
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final RobotMovingCompanyGameModel$listener$3$ listener$1(MotionSeriesObjectType motionSeriesObjectType, LongRef longRef, VolatileObjectRef volatileObjectRef) {
        if (volatileObjectRef.elem != null) return (RobotMovingCompanyGameModel$listener$3$)volatileObjectRef.elem;
        RobotMovingCompanyGameModel robotMovingCompanyGameModel = this;
        synchronized (robotMovingCompanyGameModel) {
            if (volatileObjectRef.elem == null) {
                volatileObjectRef.elem = new RobotMovingCompanyGameModel$listener$3$(this, motionSeriesObjectType, longRef);
            }
            return (RobotMovingCompanyGameModel$listener$3$)volatileObjectRef.elem;
        }
    }

    public final boolean objectStuck$1() {
        return this.isFridgeMassOrMysteryMass$1() && this.motionSeriesObject().rampUnitVector().angle() == 0.0;
    }

    private final boolean isFridgeMassOrMysteryMass$1() {
        return this.motionSeriesObject().mass() == MotionSeriesDefaults$.MODULE$.fridge().mass() || this.motionSeriesObject().mass() == MotionSeriesDefaults$.MODULE$.mystery().mass();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final RobotMovingCompanyGameModel$listener$4$ listener$2(MotionSeriesObjectType motionSeriesObjectType, MotionSeriesObject motionSeriesObject, VolatileObjectRef volatileObjectRef) {
        if (volatileObjectRef.elem != null) return (RobotMovingCompanyGameModel$listener$4$)volatileObjectRef.elem;
        RobotMovingCompanyGameModel robotMovingCompanyGameModel = this;
        synchronized (robotMovingCompanyGameModel) {
            if (volatileObjectRef.elem == null) {
                volatileObjectRef.elem = new RobotMovingCompanyGameModel$listener$4$(this, motionSeriesObjectType, motionSeriesObject);
            }
            return (RobotMovingCompanyGameModel$listener$4$)volatileObjectRef.elem;
        }
    }

    public RobotMovingCompanyGameModel(MotionSeriesModel model, ScalaClock clock, double initAngle, double appliedForceAmount, List<MotionSeriesObjectType> objectList) {
        this.model = model;
        this.initAngle = initAngle;
        this.appliedForceAmount = appliedForceAmount;
        this.objectList = objectList;
        Observable$class.$init$(this);
        this.DEFAULT_ROBOT_ENERGY = appliedForceAmount * (double)6;
        this.energyScale = (double)MotionSeriesDefaults$.MODULE$.rampRobotForce() / appliedForceAmount / 10.0;
        this.edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_robotEnergy = this.DEFAULT_ROBOT_ENERGY();
        this.airborneFloor = -9.0;
        this._launched = false;
        this._objectIndex = 0;
        this.resultMap = new HashMap();
        this.objectCreatedListeners = new ArrayBuffer();
        this.itemFinishedListeners = new ArrayBuffer();
        this.gameFinishListeners = new ArrayBuffer();
        this.housePosition = 6;
        this.house = new MotionSeriesObject(model, this.housePosition(), MotionSeriesDefaults$.MODULE$.house().width(), MotionSeriesDefaults$.MODULE$.house().height());
        this.door = new MotionSeriesObject(model, this.housePosition(), MotionSeriesDefaults$.MODULE$.door().width(), MotionSeriesDefaults$.MODULE$.door().height());
        this.edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_doorOpenAmount = 0.0;
        this.doorListeners = new ArrayBuffer();
        this.doorBackground = new MotionSeriesObject(model, this.housePosition(), MotionSeriesDefaults$.MODULE$.doorBackground().width(), MotionSeriesDefaults$.MODULE$.doorBackground().height());
        this.edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_motionSeriesObject = null;
        clock.addClockListener((Function1<Object, BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final RobotMovingCompanyGameModel $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(double dt) {
                this.apply$mcVD$sp(dt);
            }

            public void apply$mcVD$sp(double v1) {
                if (!this.$outer.model().isPaused() && this.$outer.edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_motionSeriesObject() != null) {
                    this.$outer.edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_motionSeriesObject().stepInTime(v1);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.resetAll();
        this.doorHandler = new $anonfun$2(this);
        model.stepListeners().$plus$eq((Object)this.doorHandler());
        this.deliverList = new ArrayBuffer();
        this.edu$colorado$phet$motionseries$sims$rampforcesandmotion$robotmovingcompany$RobotMovingCompanyGameModel$$_inputAllowed = true;
    }
}

