/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.motionseries.model;

import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.motionseries.MotionSeriesDefaults$;
import edu.colorado.phet.motionseries.Predef$;
import edu.colorado.phet.motionseries.charts.MutableDouble;
import edu.colorado.phet.motionseries.model.Grounded;
import edu.colorado.phet.motionseries.model.MotionSeriesModel;
import edu.colorado.phet.motionseries.model.MotionSeriesObject$;
import edu.colorado.phet.motionseries.model.MotionSeriesObjectState;
import edu.colorado.phet.motionseries.model.MotionSeriesObjectVector;
import edu.colorado.phet.motionseries.model.MotionStrategy;
import edu.colorado.phet.motionseries.model.PositionMapper;
import edu.colorado.phet.motionseries.model.RampSegment;
import edu.colorado.phet.motionseries.model.SurfaceFrictionStrategy;
import edu.colorado.phet.motionseries.model.Vector2DModel;
import edu.colorado.phet.motionseries.sims.forcesandmotionbasics.Settings$;
import edu.colorado.phet.motionseries.util.MutableRange;
import edu.colorado.phet.motionseries.util.ScalaMutableBoolean;
import edu.colorado.phet.scalacommon.math.Vector2D;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MotionSeriesObject {
    private final MutableDouble _position;
    private final MutableDouble _velocity;
    private final MutableDouble _mass;
    private final MutableDouble _staticFriction;
    private final MutableDouble _kineticFriction;
    private double _height;
    private double _width;
    private final PositionMapper positionMapper;
    private final Function1<Object, RampSegment> rampSegmentAccessor;
    private final ScalaMutableBoolean wallsBounce;
    private final BooleanProperty _wallsExist;
    private final MutableRange wallRange;
    private final Function1<Object, Object> thermalEnergyStrategy;
    private final Function0<Object> surfaceFriction;
    private SurfaceFrictionStrategy _surfaceFrictionStrategy;
    private final boolean doClampBounds;
    private boolean _userSpecifiedPosition;
    private final Vector2DModel _position2D;
    private MotionStrategy _motionStrategy;
    private final MutableDouble _thermalEnergy;
    private final MutableDouble _crashEnergy;
    private final MutableDouble _time;
    private double _airborneFloor;
    private final MutableDouble _gravity;
    private final ArrayBuffer<Function1<Object, BoxedUnit>> workListeners;
    private boolean _notificationsEnabled;
    private final ArrayBuffer<Function0<BoxedUnit>> crashListeners;
    private final ArrayBuffer<Function0<BoxedUnit>> removalListeners;
    private final Vector2DModel totalForce;
    private final Vector2DModel wallForce;
    private final Vector2DModel frictionForce;
    private final Vector2DModel normalForce;
    private final Vector2DModel gravityForce;
    private final Vector2DModel appliedForce;
    private final MutableDouble _parallelAppliedForce;
    private final String gravityString;
    private final String normalString;
    private final String totalForceString;
    private final String appliedForceString;
    private final String frictionForceString;
    private final String wallForceString;
    private final MotionSeriesObjectVector gravityForceVector;
    private final MotionSeriesObjectVector normalForceVector;
    private final MotionSeriesObjectVector totalForceVector;
    private final MotionSeriesObjectVector appliedForceVector;
    private final MotionSeriesObjectVector frictionForceVector;
    private final MotionSeriesObjectVector wallForceVector;
    private final ArrayBuffer<Function0<BoxedUnit>> wallCrashListeners;
    private final ArrayBuffer<Function0<BoxedUnit>> bounceListeners;
    private final ArrayBuffer<Function0<BoxedUnit>> stepListeners;

    private MutableDouble _staticFriction() {
        return this._staticFriction;
    }

    private double _height() {
        return this._height;
    }

    private void _height_$eq(double d) {
        this._height = d;
    }

    private double _width() {
        return this._width;
    }

    private void _width_$eq(double d) {
        this._width = d;
    }

    public PositionMapper positionMapper() {
        return this.positionMapper;
    }

    public Function1<Object, RampSegment> rampSegmentAccessor() {
        return this.rampSegmentAccessor;
    }

    public ScalaMutableBoolean wallsBounce() {
        return this.wallsBounce;
    }

    public BooleanProperty _wallsExist() {
        return this._wallsExist;
    }

    public MutableRange wallRange() {
        return this.wallRange;
    }

    public Function0<Object> surfaceFriction() {
        return this.surfaceFriction;
    }

    private SurfaceFrictionStrategy _surfaceFrictionStrategy() {
        return this._surfaceFrictionStrategy;
    }

    private boolean doClampBounds() {
        return this.doClampBounds;
    }

    private boolean _userSpecifiedPosition() {
        return this._userSpecifiedPosition;
    }

    private void _userSpecifiedPosition_$eq(boolean bl) {
        this._userSpecifiedPosition = bl;
    }

    public Vector2DModel _position2D() {
        return this._position2D;
    }

    private MotionStrategy _motionStrategy() {
        return this._motionStrategy;
    }

    private void _motionStrategy_$eq(MotionStrategy motionStrategy) {
        this._motionStrategy = motionStrategy;
    }

    public void updatePosition2D() {
        this._position2D().value_$eq(this.motionStrategy().mapPosition());
    }

    public void updateForces() {
        this.motionStrategy().updateForces();
    }

    public void clampBounds() {
        if (this.doClampBounds()) {
            if (this.position() < this.wallRange().apply().min()) {
                this.position_$eq(this.wallRange().apply().min() + this._width() / (double)2);
            }
            if (this.position() > this.wallRange().apply().max()) {
                this.position_$eq(this.wallRange().apply().max() - this._width() / (double)2);
            }
        }
    }

    private MutableDouble _thermalEnergy() {
        return this._thermalEnergy;
    }

    private MutableDouble _crashEnergy() {
        return this._crashEnergy;
    }

    private MutableDouble _time() {
        return this._time;
    }

    private double _airborneFloor() {
        return this._airborneFloor;
    }

    private void _airborneFloor_$eq(double d) {
        this._airborneFloor = d;
    }

    private MutableDouble _gravity() {
        return this._gravity;
    }

    public ArrayBuffer<Function1<Object, BoxedUnit>> workListeners() {
        return this.workListeners;
    }

    public ArrayBuffer<Function0<BoxedUnit>> crashListeners() {
        return this.crashListeners;
    }

    public ArrayBuffer<Function0<BoxedUnit>> removalListeners() {
        return this.removalListeners;
    }

    public Vector2DModel totalForce() {
        return this.totalForce;
    }

    public Vector2DModel wallForce() {
        return this.wallForce;
    }

    public Vector2DModel frictionForce() {
        return this.frictionForce;
    }

    public Vector2DModel normalForce() {
        return this.normalForce;
    }

    public Vector2DModel gravityForce() {
        return this.gravityForce;
    }

    public Vector2DModel appliedForce() {
        return this.appliedForce;
    }

    public MutableDouble _parallelAppliedForce() {
        return this._parallelAppliedForce;
    }

    public void updateGravityForce() {
        this.gravityForce().value_$eq(new Vector2D(0.0, this.gravity() * this.mass()));
        this.updateForces();
    }

    public String gravityString() {
        return this.gravityString;
    }

    public String normalString() {
        return this.normalString;
    }

    public String totalForceString() {
        return this.totalForceString;
    }

    public String appliedForceString() {
        return this.appliedForceString;
    }

    public String frictionForceString() {
        return this.frictionForceString;
    }

    public String wallForceString() {
        return this.wallForceString;
    }

    public MotionSeriesObjectVector gravityForceVector() {
        return this.gravityForceVector;
    }

    public MotionSeriesObjectVector normalForceVector() {
        return this.normalForceVector;
    }

    public MotionSeriesObjectVector totalForceVector() {
        return this.totalForceVector;
    }

    public MotionSeriesObjectVector appliedForceVector() {
        return this.appliedForceVector;
    }

    public MotionSeriesObjectVector frictionForceVector() {
        return this.frictionForceVector;
    }

    public MotionSeriesObjectVector wallForceVector() {
        return this.wallForceVector;
    }

    private ArrayBuffer<Function0<BoxedUnit>> wallCrashListeners() {
        return this.wallCrashListeners;
    }

    private ArrayBuffer<Function0<BoxedUnit>> bounceListeners() {
        return this.bounceListeners;
    }

    public ArrayBuffer<Function0<BoxedUnit>> stepListeners() {
        return this.stepListeners;
    }

    public boolean frictionless() {
        return this.state().staticFriction() == 0.0 && this.state().kineticFriction() == 0.0;
    }

    public double gravity() {
        return this._gravity().value();
    }

    public boolean wallsExist() {
        return (Boolean)this._wallsExist().get();
    }

    public MotionSeriesObjectState state() {
        return new MotionSeriesObjectState(this.position(), this.velocity(), this.acceleration(), this.mass(), this.staticFriction(), this.kineticFriction(), this.thermalEnergy(), this.crashEnergy(), this.time(), this.parallelAppliedForce(), this.gravityForce().value(), this.normalForce().value(), this.totalForce().value(), this.appliedForce().value(), this.frictionForce().value(), this.wallForce().value());
    }

    public void state_$eq(MotionSeriesObjectState s) {
        this.position_$eq(s.position());
        this.velocity_$eq(s.velocity());
        this.mass_$eq(s.mass());
        this.staticFriction_$eq(s.staticFriction());
        this.kineticFriction_$eq(s.kineticFriction());
        this.thermalEnergy_$eq(s.thermalEnergy());
        this.crashEnergy_$eq(s.crashEnergy());
        this.time_$eq(s.time());
        this.parallelAppliedForce_$eq(s.parallelAppliedForce());
        this.gravityForce().value_$eq(s.gravityForce());
        this.normalForce().value_$eq(s.normalForce());
        this.totalForce().value_$eq(s.totalForce());
        this.appliedForce().value_$eq(s.appliedForce());
        this.frictionForce().value_$eq(s.frictionForce());
        this.wallForce().value_$eq(s.wallForce());
    }

    public void remove() {
        this.removalListeners().foreach(new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Function0<BoxedUnit> function0) {
                function0.apply$mcV$sp();
            }
        });
    }

    public double width() {
        return this._width();
    }

    public double getVelocityVectorDirection() {
        return this.getVelocityVectorDirection(this.velocity());
    }

    public double getVelocityVectorDirection(double v) {
        return this.positionMapper().apply(this.position() + v * 1.0E-6).$minus(this.positionMapper().apply(this.position() - v * 1.0E-6)).angle();
    }

    public Vector2D getVelocityVectorUnitVector(double v) {
        return new Vector2D(this.getVelocityVectorDirection(v));
    }

    public Vector2D rampUnitVector() {
        return this.rampSegmentAccessor().apply(BoxesRunTime.boxToDouble(this.position())).unitVector();
    }

    public double mass() {
        return this._mass.value();
    }

    public MutableDouble massProperty() {
        return this._mass;
    }

    public MutableDouble gravityProperty() {
        return this._gravity();
    }

    public void width_$eq(double w) {
        this._width_$eq(w);
    }

    public double position() {
        return this._position.value();
    }

    public double velocity() {
        return this._velocity.value();
    }

    public void height_$eq(double height) {
        this._height_$eq(height);
    }

    public double height() {
        return this._height();
    }

    public double time() {
        return this._time().value();
    }

    public void time_$eq(double t) {
        this._time().value_$eq(t);
    }

    public double airborneFloor() {
        return this._airborneFloor();
    }

    public void airborneFloor_$eq(double airborneFloor) {
        this._airborneFloor_$eq(airborneFloor);
    }

    public double getTotalEnergy() {
        return this.potentialEnergy() + this.kineticEnergy() + this.thermalEnergy();
    }

    public double potentialEnergy() {
        return this.mass() * BoxesRunTime.unboxToDouble(scala.Predef$.MODULE$.doubleWrapper(this.gravity()).abs()) * this.position2D().y();
    }

    public void crashEnergy_$eq(double value) {
        this._crashEnergy().value_$eq(value);
    }

    public void thermalEnergy_$eq(double value) {
        this._thermalEnergy().value_$eq(value);
    }

    public double thermalEnergy() {
        return this._thermalEnergy().value();
    }

    public double crashEnergy() {
        return this._crashEnergy().value();
    }

    public double kineticEnergy() {
        return 0.5 * this.mass() * this.velocity() * this.velocity();
    }

    public double getThermalEnergy(double x) {
        return this.thermalEnergyStrategy.apply$mcDD$sp(x);
    }

    public double parallelAppliedForce() {
        return this._parallelAppliedForce().value();
    }

    public void parallelAppliedForce_$eq(double value) {
        this._parallelAppliedForce().value_$eq(value);
    }

    public MutableDouble parallelAppliedForceProperty() {
        return this._parallelAppliedForce();
    }

    public SurfaceFrictionStrategy surfaceFrictionStrategy() {
        return this._surfaceFrictionStrategy();
    }

    public double staticFriction() {
        return Settings$.MODULE$.basicsMode() ? this.kineticFriction() : this._staticFriction().value();
    }

    public MutableDouble staticFrictionProperty() {
        return this._staticFriction();
    }

    public MutableDouble positionProperty() {
        return this._position;
    }

    public Vector2DModel position2DProperty() {
        return this._position2D();
    }

    public MutableDouble kineticFrictionProperty() {
        return this._kineticFriction;
    }

    public double kineticFriction() {
        return this._kineticFriction.value();
    }

    public void staticFriction_$eq(double value) {
        this._staticFriction().value_$eq(value);
        if (this.kineticFriction() > this.staticFriction()) {
            this.kineticFriction_$eq(this.staticFriction());
        }
    }

    public void kineticFriction_$eq(double value) {
        this._kineticFriction.value_$eq(value);
        if (this.staticFriction() < this.kineticFriction()) {
            this.staticFriction_$eq(this.kineticFriction());
        }
    }

    public double forceToParallelAcceleration(Vector2D f) {
        return f.dot(this.rampUnitVector()) / this.mass();
    }

    public double netForceToParallelVelocity(Vector2D f, double dt) {
        return this.velocity() + this.forceToParallelAcceleration(f) * dt;
    }

    public void velocity_$eq(double velocity) {
        this._velocity.value_$eq(velocity);
    }

    public void mass_$eq(double mass) {
        this._mass.value_$eq(mass);
    }

    public void position_$eq(double position) {
        this._position.value_$eq(position);
    }

    public void gravity_$eq(double value) {
        this._gravity().value_$eq(value);
    }

    public MotionStrategy motionStrategy() {
        return this._motionStrategy();
    }

    public void motionStrategy_$eq(MotionStrategy s) {
        this._motionStrategy_$eq(s);
    }

    public void attach() {
        this.motionStrategy_$eq(new Grounded(this));
    }

    public Vector2D position2D() {
        return this._position2D().value();
    }

    public double getAngle() {
        return this.motionStrategy().getAngle();
    }

    public void stepInTime(double dt) {
        if (!this.userSpecifiedPosition()) {
            this.motionStrategy().stepInTime(dt);
        }
        this.stepListeners().foreach(new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Function0<BoxedUnit> listener) {
                listener.apply$mcV$sp();
            }
        });
    }

    public double acceleration() {
        return this.forceToParallelAcceleration(this.totalForce().apply());
    }

    public boolean isCrashed() {
        return this.motionStrategy().isCrashed();
    }

    public void notifyCollidedWithWall() {
        this.wallCrashListeners().foreach(new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Function0<BoxedUnit> wallCrashListener) {
                wallCrashListener.apply$mcV$sp();
            }
        });
    }

    public void notifyBounced() {
        this.bounceListeners().foreach(new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Function0<BoxedUnit> bounceListener) {
                bounceListener.apply$mcV$sp();
            }
        });
    }

    public ArrayBuffer<Function0<BoxedUnit>> addWallCrashListener(Function0<BoxedUnit> listener) {
        return this.wallCrashListeners().$plus$eq((Object)listener);
    }

    public ArrayBuffer<Function0<BoxedUnit>> addBounceListener(Function0<BoxedUnit> listener) {
        return this.bounceListeners().$plus$eq((Object)listener);
    }

    public void userSpecifiedPosition_$eq(boolean b) {
        this._userSpecifiedPosition_$eq(b);
    }

    public boolean userSpecifiedPosition() {
        return this._userSpecifiedPosition();
    }

    public MotionSeriesObject(MutableDouble _position, MutableDouble _velocity, MutableDouble _acceleration, MutableDouble _mass, MutableDouble _staticFriction, MutableDouble _kineticFriction, double _height, double _width, PositionMapper positionMapper, Function1<Object, RampSegment> rampSegmentAccessor, ScalaMutableBoolean wallsBounce, BooleanProperty _wallsExist, MutableRange wallRange, Function1<Object, Object> thermalEnergyStrategy, Function0<Object> surfaceFriction, SurfaceFrictionStrategy _surfaceFrictionStrategy, boolean doClampBounds) {
        this._position = _position;
        this._velocity = _velocity;
        this._mass = _mass;
        this._staticFriction = _staticFriction;
        this._kineticFriction = _kineticFriction;
        this._height = _height;
        this._width = _width;
        this.positionMapper = positionMapper;
        this.rampSegmentAccessor = rampSegmentAccessor;
        this.wallsBounce = wallsBounce;
        this._wallsExist = _wallsExist;
        this.wallRange = wallRange;
        this.thermalEnergyStrategy = thermalEnergyStrategy;
        this.surfaceFriction = surfaceFriction;
        this._surfaceFrictionStrategy = _surfaceFrictionStrategy;
        this.doClampBounds = doClampBounds;
        this._userSpecifiedPosition = false;
        scala.Predef$.MODULE$.assert(positionMapper != null, (Function0<Object>)((Object)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "PositionMapper must be non-null";
            }
        }));
        this._position2D = new Vector2DModel();
        this._motionStrategy = new Grounded(this);
        _position.addListener((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final MotionSeriesObject $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.updatePosition2D();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.updatePosition2D();
        _position.addListener((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final MotionSeriesObject $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.updateForces();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        wallRange.addListener((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final MotionSeriesObject $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.clampBounds();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        if (this._surfaceFrictionStrategy() == null) {
            throw new RuntimeException("Null surface friction strategy");
        }
        this._thermalEnergy = new MutableDouble();
        this._crashEnergy = new MutableDouble();
        this._time = new MutableDouble();
        this._airborneFloor = 0.0;
        this._gravity = new MutableDouble(-9.8);
        this.workListeners = new ArrayBuffer();
        this._notificationsEnabled = true;
        this.crashListeners = new ArrayBuffer();
        this.removalListeners = new ArrayBuffer();
        positionMapper.addListener((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final MotionSeriesObject $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.updatePosition2D();
                this.$outer.updateForces();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.totalForce = new Vector2DModel();
        this.wallForce = new Vector2DModel();
        this.frictionForce = new Vector2DModel();
        this.normalForce = new Vector2DModel();
        this.gravityForce = new Vector2DModel();
        this.appliedForce = new Vector2DModel();
        this._parallelAppliedForce = new MutableDouble();
        this._parallelAppliedForce().addListener((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final MotionSeriesObject $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.updateForces();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this._gravity().addListener((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final MotionSeriesObject $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.updateGravityForce();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        _mass.addListener((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final MotionSeriesObject $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.updateGravityForce();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.updateGravityForce();
        this.gravityString = Settings$.MODULE$.basicsMode() ? "gravity" : Predef$.MODULE$.toMyRichString("force.abbrev.gravity").translate();
        this.normalString = Settings$.MODULE$.basicsMode() ? "normal" : Predef$.MODULE$.toMyRichString("force.abbrev.normal").translate();
        this.totalForceString = Settings$.MODULE$.basicsMode() ? "total" : Predef$.MODULE$.toMyRichString("force.abbrev.total").translate();
        this.appliedForceString = Settings$.MODULE$.basicsMode() ? "applied" : Predef$.MODULE$.toMyRichString("force.abbrev.applied").translate();
        this.frictionForceString = Settings$.MODULE$.basicsMode() ? "friction" : Predef$.MODULE$.toMyRichString("force.abbrev.friction").translate();
        this.wallForceString = Settings$.MODULE$.basicsMode() ? "wall" : Predef$.MODULE$.toMyRichString("force.abbrev.wall").translate();
        this.gravityForceVector = new MotionSeriesObjectVector(MotionSeriesDefaults$.MODULE$.gravityForceColor(), Predef$.MODULE$.toMyRichString("gravityForce").translate(), this.gravityString(), false, this.gravityForce(), new $anonfun$9(this), 1.5707963267948966);
        this.normalForceVector = new MotionSeriesObjectVector(MotionSeriesDefaults$.MODULE$.normalForceColor(), Predef$.MODULE$.toMyRichString("normalForce").translate(), this.normalString(), true, this.normalForce(), new $anonfun$10(this), 1.5707963267948966);
        this.totalForceVector = new MotionSeriesObjectVector(MotionSeriesDefaults$.MODULE$.sumForceColor(), Predef$.MODULE$.toMyRichString("totalForce").translate(), this.totalForceString(), false, this.totalForce(), new $anonfun$11(this), 0.0);
        this.appliedForceVector = new MotionSeriesObjectVector(MotionSeriesDefaults$.MODULE$.appliedForceColor(), Predef$.MODULE$.toMyRichString("appliedForce").translate(), this.appliedForceString(), false, this.appliedForce(), new $anonfun$12(this), 1.5707963267948966);
        this.frictionForceVector = new MotionSeriesObjectVector(MotionSeriesDefaults$.MODULE$.frictionForceColor(), Predef$.MODULE$.toMyRichString("frictionForce").translate(), this.frictionForceString(), true, this.frictionForce(), new $anonfun$13(this), -Math.PI / (double)2);
        this.wallForceVector = new MotionSeriesObjectVector(MotionSeriesDefaults$.MODULE$.wallForceColor(), Predef$.MODULE$.toMyRichString("wallForce").translate(), this.wallForceString(), false, this.wallForce(), new $anonfun$14(this), 1.5707963267948966);
        this.wallCrashListeners = new ArrayBuffer();
        this.bounceListeners = new ArrayBuffer();
        this.stepListeners = new ArrayBuffer();
    }

    public MotionSeriesObject(MotionSeriesModel model$1, double x, double width, double height, boolean doClampBounds) {
        this(new MutableDouble(x), new MutableDouble(), new MutableDouble(), new MutableDouble(10.0), new MutableDouble(), new MutableDouble(), height, width, model$1.positionMapper(), (Function1<Object, RampSegment>)((Object)new Serializable(model$1){
            public static final long serialVersionUID;
            private final MotionSeriesModel model$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final RampSegment apply(double d) {
                return this.model$1.rampSegmentAccessor(d);
            }
            {
                this.model$1 = motionSeriesModel;
            }
        }), model$1.wallsBounce(), model$1.walls(), model$1.wallRange(), (Function1<Object, Object>)((Object)new Serializable(model$1){
            public static final long serialVersionUID;
            private final MotionSeriesModel model$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final double apply(double d) {
                return this.apply$mcDD$sp(d);
            }

            public double apply$mcDD$sp(double v1) {
                return this.model$1.thermalEnergyStrategy(v1);
            }
            {
                this.model$1 = motionSeriesModel;
            }
        }), model$1.surfaceFriction(), model$1.surfaceFrictionStrategy(), doClampBounds);
    }

    public MotionSeriesObject(MotionSeriesModel model, double x, double width, double height) {
        this(model, x, width, height, false);
    }
}

