/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.motionseries.model;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.motionseries.Predef$;
import edu.colorado.phet.motionseries.model.Airborne;
import edu.colorado.phet.motionseries.model.MotionSeriesObject;
import edu.colorado.phet.motionseries.model.MotionSeriesObjectState;
import edu.colorado.phet.motionseries.model.MotionStrategy;
import edu.colorado.phet.motionseries.model.MotionStrategyMemento;
import edu.colorado.phet.scalacommon.math.Vector2D;
import scala.Function1;
import scala.Product;
import scala.Product$class;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class Grounded
extends MotionStrategy {
    private double dt = 0.03333333333333333;

    public final MotionSeriesObject edu$colorado$phet$motionseries$model$Grounded$$super$motionSeriesObject() {
        return super.motionSeriesObject();
    }

    public boolean isCrashed() {
        return false;
    }

    public MotionStrategyMemento getMemento() {
        return new MotionStrategyMemento(this){

            public Grounded getMotionStrategy(MotionSeriesObject motionSeriesObject) {
                return new Grounded(motionSeriesObject);
            }
        };
    }

    public Vector2D position2D() {
        return super.motionSeriesObject().positionMapper().apply(super.motionSeriesObject().position());
    }

    public double getAngle() {
        return super.motionSeriesObject().rampSegmentAccessor().apply(BoxesRunTime.boxToDouble(super.motionSeriesObject().position())).unitVector().angle();
    }

    public Vector2D normalForce() {
        double magnitude = super.motionSeriesObject().gravityForce().value().$times(-1.0).dot(super.motionSeriesObject().rampUnitVector().rotate(1.5707963267948966));
        double angle = super.motionSeriesObject().rampUnitVector().angle() + 1.5707963267948966;
        return new Vector2D(angle).$times(magnitude);
    }

    public boolean collideLeft() {
        return super.motionSeriesObject().position() + super.motionSeriesObject().velocity() * this.dt() < this.leftBound() && super.motionSeriesObject().wallsExist();
    }

    public boolean collideRight() {
        return super.motionSeriesObject().position() + super.motionSeriesObject().velocity() * this.dt() > this.rightBound() && super.motionSeriesObject().wallsExist();
    }

    public boolean collide() {
        return this.collideLeft() || this.collideRight();
    }

    public double leftBound() {
        return super.motionSeriesObject().wallRange().apply().min() + super.motionSeriesObject().width() / (double)2;
    }

    public double rightBound() {
        return super.motionSeriesObject().wallRange().apply().max() - super.motionSeriesObject().width() / (double)2;
    }

    public Vector2D wallForce() {
        Vector2D vector2D;
        boolean pressing;
        double epsilon = 1.0E-4;
        Vector2D netForceWithoutWallForce = super.motionSeriesObject().appliedForce().value().$plus(super.motionSeriesObject().gravityForce().value()).$plus(this.normalForce()).$plus(this.frictionForce(false));
        boolean pressingLeft = super.motionSeriesObject().position() <= this.leftBound() + 1.0E-4 && super.motionSeriesObject().forceToParallelAcceleration(netForceWithoutWallForce) < 0.0 && super.motionSeriesObject().wallsExist();
        boolean pressingRight = super.motionSeriesObject().position() >= this.rightBound() - 1.0E-4 && super.motionSeriesObject().forceToParallelAcceleration(netForceWithoutWallForce) > 0.0 && super.motionSeriesObject().wallsExist();
        boolean bl = pressing = pressingLeft || pressingRight;
        if (pressing) {
            vector2D = netForceWithoutWallForce.$times(-1.0);
        } else if (this.collide()) {
            Vector2D resultWallForce;
            double finalVelocity = this.bounce() ? -super.motionSeriesObject().velocity() : 0.0;
            double deltaV = finalVelocity - super.motionSeriesObject().velocity();
            double sign = this.collideRight() ? -1.0 : 1.0;
            double wallCollisionForce = Math.abs(super.motionSeriesObject().mass() * deltaV / this.dt() - netForceWithoutWallForce.magnitude()) * sign;
            vector2D = resultWallForce = super.motionSeriesObject().rampUnitVector().$times(wallCollisionForce);
        } else {
            vector2D = new Vector2D();
        }
        return vector2D;
    }

    public double multiBodyFriction(double f) {
        return super.motionSeriesObject().surfaceFrictionStrategy().getTotalFriction(f);
    }

    public Vector2D frictionForce(boolean includeWallForce) {
        Vector2D vector2D;
        if (super.motionSeriesObject().surfaceFriction().apply$mcZ$sp()) {
            if (BoxesRunTime.unboxToDouble(scala.Predef$.MODULE$.doubleWrapper(super.motionSeriesObject().velocity()).abs()) < 1.0E-12) {
                double fMax = Math.abs(this.multiBodyFriction(super.motionSeriesObject().staticFriction()) * this.normalForce().magnitude());
                Vector2D netForceWithoutFriction = super.motionSeriesObject().appliedForce().value().$plus(super.motionSeriesObject().gravityForce().value()).$plus(this.normalForce()).$plus(includeWallForce ? this.wallForce() : new Vector2D());
                double magnitude = netForceWithoutFriction.magnitude() >= fMax ? fMax : netForceWithoutFriction.magnitude();
                vector2D = new Vector2D(netForceWithoutFriction.angle() + Math.PI).$times(magnitude);
            } else {
                Vector2D vel = super.motionSeriesObject().positionMapper().apply(super.motionSeriesObject().position()).$minus(super.motionSeriesObject().positionMapper().apply(super.motionSeriesObject().position() - super.motionSeriesObject().velocity() * 1.0E-6));
                vector2D = new Vector2D(vel.angle() + Math.PI).$times(this.normalForce().magnitude()).$times(this.multiBodyFriction(super.motionSeriesObject().kineticFriction()));
            }
        } else {
            vector2D = new Vector2D();
        }
        return vector2D;
    }

    private double dt() {
        return this.dt;
    }

    private void dt_$eq(double d) {
        this.dt = d;
    }

    public void stepInTime(double dt) {
        this.dt_$eq(dt);
        this.updateAppliedForce();
        double origEnergy = super.motionSeriesObject().getTotalEnergy();
        MotionSeriesObjectState origState = super.motionSeriesObject().state();
        SettableState newState = this.getNewState(dt, origState, origEnergy);
        if (newState.position() > super.motionSeriesObject().wallRange().apply().max() + super.motionSeriesObject().width() / (double)2 && !super.motionSeriesObject().wallsExist()) {
            super.motionSeriesObject().motionStrategy_$eq(new Airborne(this.position2D(), new Vector2D(super.motionSeriesObject().getVelocityVectorDirection()).$times(super.motionSeriesObject().velocity()), this.getAngle(), super.motionSeriesObject()));
            super.motionSeriesObject().parallelAppliedForce_$eq(0.0);
        }
        Vector2D distanceVector$1 = super.motionSeriesObject().positionMapper().apply(newState.position()).$minus(super.motionSeriesObject().positionMapper().apply(origState.position()));
        super.motionSeriesObject().workListeners().foreach(new Serializable(this, distanceVector$1){
            public static final long serialVersionUID;
            private final Grounded $outer;
            private final Vector2D distanceVector$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Function1<Object, BoxedUnit> listener) {
                listener.apply$mcVD$sp(this.$outer.edu$colorado$phet$motionseries$model$Grounded$$super$motionSeriesObject().appliedForce().value().dot(this.distanceVector$1));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.distanceVector$1 = vector2D;
            }
        });
        super.motionSeriesObject().time_$eq(super.motionSeriesObject().time() + dt);
        super.motionSeriesObject().position_$eq(newState.position());
        super.motionSeriesObject().velocity_$eq(newState.velocity());
        super.motionSeriesObject().thermalEnergy_$eq(newState.thermalEnergy());
        super.motionSeriesObject().crashEnergy_$eq(newState.crashEnergy());
        this.updateForces();
    }

    public boolean bounce() {
        return super.motionSeriesObject().wallsBounce().booleanValue();
    }

    public boolean isKineticFriction() {
        return super.motionSeriesObject().surfaceFriction().apply$mcZ$sp() && super.motionSeriesObject().kineticFriction() > 0.0;
    }

    public SettableState getNewState(double dt, MotionSeriesObjectState origState$1, double origEnergy$1) {
        SettableState stateAfterPatchingUpThermalEnergy;
        SettableState settableState;
        SettableState stateAfterFixingVelocity;
        SettableState settableState2;
        double newVelocityThatGoesThroughZero;
        double desiredVel = super.motionSeriesObject().netForceToParallelVelocity(super.motionSeriesObject().totalForce().value(), dt);
        double d = newVelocityThatGoesThroughZero = super.motionSeriesObject().velocity() < 0.0 && desiredVel > 0.0 || super.motionSeriesObject().velocity() > 0.0 && desiredVel < 0.0 ? 0.0 : desiredVel;
        double newVelocity = this.collide() && this.bounce() ? -super.motionSeriesObject().velocity() : (this.collide() ? 0.0 : newVelocityThatGoesThroughZero);
        SettableState stateAfterVelocityUpdate = new SettableState(this, super.motionSeriesObject().position() + newVelocity * dt, newVelocity, origState$1.thermalEnergy(), origState$1.crashEnergy());
        double crashEnergy = 0.5 * super.motionSeriesObject().mass() * super.motionSeriesObject().velocity() * super.motionSeriesObject().velocity();
        SettableState stateAfterCollision = this.collideLeft() && !this.bounce() ? new SettableState(this, this.leftBound(), 0.0, stateAfterVelocityUpdate.thermalEnergy() + crashEnergy, origState$1.crashEnergy() + crashEnergy) : (this.collideRight() && !this.bounce() ? new SettableState(this, this.rightBound(), 0.0, stateAfterVelocityUpdate.thermalEnergy() + crashEnergy, origState$1.crashEnergy() + crashEnergy) : stateAfterVelocityUpdate);
        double dx = stateAfterCollision.position() - origState$1.position();
        double appliedEnergy$1 = super.motionSeriesObject().appliedForce().value().dot(super.motionSeriesObject().getVelocityVectorUnitVector(stateAfterCollision.velocity())) * BoxesRunTime.unboxToDouble(scala.Predef$.MODULE$.doubleWrapper(dx).abs());
        double thermalFromEnergy = this.isKineticFriction() && !this.collide() ? origEnergy$1 - stateAfterCollision.ke() - stateAfterCollision.pe() + appliedEnergy$1 : (!this.bounce() && this.collide() ? origEnergy$1 + appliedEnergy$1 - stateAfterCollision.ke() - stateAfterCollision.pe() : origState$1.thermalEnergy());
        SettableState stateAfterThermalEnergy = stateAfterCollision.setThermalEnergy(thermalFromEnergy);
        double dE = stateAfterThermalEnergy.totalEnergy() - origEnergy$1;
        double dT = stateAfterThermalEnergy.thermalEnergy() - origState$1.thermalEnergy();
        if (dT < 0.0) {
            double patchedVelocity = this.getVelocityToConserveEnergy$1(stateAfterThermalEnergy, origState$1, origEnergy$1, appliedEnergy$1);
            SettableState patch = stateAfterThermalEnergy.setThermalEnergy(origState$1.thermalEnergy()).setVelocity(patchedVelocity);
            double dEPatch = stateAfterThermalEnergy.totalEnergy() - origEnergy$1;
            settableState2 = BoxesRunTime.unboxToDouble(scala.Predef$.MODULE$.doubleWrapper(dEPatch).abs()) > 1.0E-8 ? patch : patch;
        } else {
            settableState2 = stateAfterThermalEnergy;
        }
        SettableState stateAfterFixingThermal = settableState2;
        SettableState settableState3 = stateAfterFixingVelocity = Math.abs(stateAfterFixingThermal.totalEnergy() - origEnergy$1 - appliedEnergy$1) > 1.0E-8 && BoxesRunTime.unboxToDouble(scala.Predef$.MODULE$.doubleWrapper(stateAfterFixingThermal.velocity()).abs()) > 0.001 ? stateAfterFixingThermal.setVelocity(this.getVelocityToConserveEnergy$1(stateAfterThermalEnergy, origState$1, origEnergy$1, appliedEnergy$1)) : stateAfterFixingThermal;
        if (Math.abs(stateAfterFixingVelocity.totalEnergy() - origEnergy$1) > 1.0E-8 && this.getAngle() > 1.0E-8) {
            double x = (origEnergy$1 + appliedEnergy$1 - stateAfterFixingVelocity.thermalEnergy() - stateAfterFixingVelocity.ke()) / super.motionSeriesObject().mass() / BoxesRunTime.unboxToDouble(scala.Predef$.MODULE$.doubleWrapper(super.motionSeriesObject().gravity()).abs()) / Math.sin(this.getAngle());
            settableState = stateAfterFixingThermal.setPosition(x);
        } else {
            settableState = stateAfterFixingVelocity;
        }
        SettableState stateAfterFixingPosition = settableState;
        double delta = stateAfterFixingPosition.totalEnergy() - origEnergy$1 - appliedEnergy$1;
        if (BoxesRunTime.unboxToDouble(scala.Predef$.MODULE$.doubleWrapper(delta).abs()) > 1.0E-6 && BoxesRunTime.unboxToDouble(scala.Predef$.MODULE$.doubleWrapper(appliedEnergy$1).abs()) < 1.0E-4) {
            scala.Predef$.MODULE$.println(new StringBuilder().append((Object)Predef$.MODULE$.toMyRichString("failed to conserve energy, delta=").literal()).append(BoxesRunTime.boxToDouble(delta)).append((Object)Predef$.MODULE$.toMyRichString(", applied energy = ").literal()).append(BoxesRunTime.boxToDouble(appliedEnergy$1)).toString());
        }
        if ((stateAfterPatchingUpThermalEnergy = stateAfterFixingPosition.setThermalEnergy(super.motionSeriesObject().getThermalEnergy(stateAfterFixingPosition.thermalEnergy()))).thermalEnergy() < origState$1.thermalEnergy()) {
            scala.Predef$.MODULE$.println(new StringBuilder().append((Object)"lost thermal energy.  original = ").append(BoxesRunTime.boxToDouble(origState$1.thermalEnergy())).append((Object)", final = ").append(BoxesRunTime.boxToDouble(stateAfterPatchingUpThermalEnergy.thermalEnergy())).toString());
        }
        if (this.collide() && this.bounce()) {
            super.motionSeriesObject().notifyBounced();
        } else if (this.collide() && !this.bounce()) {
            super.motionSeriesObject().notifyCollidedWithWall();
        }
        return stateAfterPatchingUpThermalEnergy;
    }

    private final double getVelocityToConserveEnergy$1(SettableState state2, MotionSeriesObjectState motionSeriesObjectState, double d, double d2) {
        int sign = MathUtil.getSign(state2.velocity());
        return (double)sign * Math.sqrt(Math.abs(2.0 / super.motionSeriesObject().mass() * (d + d2 - state2.pe() - motionSeriesObjectState.thermalEnergy())));
    }

    public Grounded(MotionSeriesObject motionSeriesObject) {
        super(motionSeriesObject);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SettableState
    implements Product,
    Serializable {
        private final double position;
        private final double velocity;
        private final double thermalEnergy;
        private final double crashEnergy;
        private double totalEnergy;
        private double ke;
        private double pe;
        public final Grounded $outer;
        public volatile int bitmap$0;

        public double position() {
            return this.position;
        }

        public double velocity() {
            return this.velocity;
        }

        public double thermalEnergy() {
            return this.thermalEnergy;
        }

        public double crashEnergy() {
            return this.crashEnergy;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public double totalEnergy() {
            if ((this.bitmap$0 & 1) != 0) return this.totalEnergy;
            SettableState settableState = this;
            synchronized (settableState) {
                if ((this.bitmap$0 & 1) == 0) {
                    this.totalEnergy = this.ke() + this.pe() + this.thermalEnergy();
                    this.bitmap$0 |= 1;
                }
                return this.totalEnergy;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public double ke() {
            if ((this.bitmap$0 & 2) != 0) return this.ke;
            SettableState settableState = this;
            synchronized (settableState) {
                if ((this.bitmap$0 & 2) == 0) {
                    this.ke = this.edu$colorado$phet$motionseries$model$Grounded$SettableState$$$outer().edu$colorado$phet$motionseries$model$Grounded$$super$motionSeriesObject().mass() * this.velocity() * this.velocity() / 2.0;
                    this.bitmap$0 |= 2;
                }
                return this.ke;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public double pe() {
            if ((this.bitmap$0 & 4) != 0) return this.pe;
            SettableState settableState = this;
            synchronized (settableState) {
                if ((this.bitmap$0 & 4) == 0) {
                    this.pe = this.edu$colorado$phet$motionseries$model$Grounded$SettableState$$$outer().edu$colorado$phet$motionseries$model$Grounded$$super$motionSeriesObject().mass() * BoxesRunTime.unboxToDouble(scala.Predef$.MODULE$.doubleWrapper(this.edu$colorado$phet$motionseries$model$Grounded$SettableState$$$outer().edu$colorado$phet$motionseries$model$Grounded$$super$motionSeriesObject().gravity()).abs()) * this.edu$colorado$phet$motionseries$model$Grounded$SettableState$$$outer().edu$colorado$phet$motionseries$model$Grounded$$super$motionSeriesObject().positionMapper().apply(this.position()).y();
                    this.bitmap$0 |= 4;
                }
                return this.pe;
            }
        }

        public SettableState setPosition(double p) {
            return this.copy(p, this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
        }

        public SettableState setVelocity(double v) {
            double x$2 = v;
            double x$3 = this.copy$default$1();
            double x$4 = this.copy$default$3();
            double x$5 = this.copy$default$4();
            return this.copy(x$3, x$2, x$4, x$5);
        }

        public SettableState setThermalEnergy(double t) {
            double x$6 = t;
            double x$7 = this.copy$default$1();
            double x$8 = this.copy$default$2();
            double x$9 = this.copy$default$4();
            return this.copy(x$7, x$8, x$6, x$9);
        }

        public double copy$default$4() {
            return this.crashEnergy();
        }

        public double copy$default$3() {
            return this.thermalEnergy();
        }

        public double copy$default$2() {
            return this.velocity();
        }

        public double copy$default$1() {
            return this.position();
        }

        public SettableState copy(double position, double velocity, double thermalEnergy, double crashEnergy) {
            return new SettableState(this.edu$colorado$phet$motionseries$model$Grounded$SettableState$$$outer(), position, velocity, thermalEnergy, crashEnergy);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            double d;
            double crashEnergy$1;
            double d2;
            double thermalEnergy$1;
            double d3;
            double velocity$1;
            if (this == object) return true;
            Object object2 = object;
            if (!(object2 instanceof SettableState)) return false;
            if (((SettableState)object2).edu$colorado$phet$motionseries$model$Grounded$SettableState$$$outer() != this.edu$colorado$phet$motionseries$model$Grounded$SettableState$$$outer()) return false;
            SettableState settableState = (SettableState)object2;
            double d4 = settableState.position();
            double position$1 = d4;
            if (!this.gd1$1(position$1, velocity$1 = (d3 = settableState.velocity()), thermalEnergy$1 = (d2 = settableState.thermalEnergy()), crashEnergy$1 = (d = settableState.crashEnergy()))) return false;
            boolean bl = ((SettableState)object).canEqual(this);
            if (!bl) return false;
            return true;
        }

        @Override
        public String productPrefix() {
            return "SettableState";
        }

        @Override
        public int productArity() {
            return 4;
        }

        @Override
        public Object productElement(int n) {
            Double d;
            int n2 = n;
            switch (n2) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(n)).toString());
                }
                case 0: {
                    d = BoxesRunTime.boxToDouble(this.position());
                    break;
                }
                case 2: {
                    d = BoxesRunTime.boxToDouble(this.thermalEnergy());
                    break;
                }
                case 1: {
                    d = BoxesRunTime.boxToDouble(this.velocity());
                    break;
                }
                case 3: {
                    d = BoxesRunTime.boxToDouble(this.crashEnergy());
                }
            }
            return d;
        }

        @Override
        public boolean canEqual(Object object) {
            return object instanceof SettableState;
        }

        public Grounded edu$colorado$phet$motionseries$model$Grounded$SettableState$$$outer() {
            return this.$outer;
        }

        private final boolean gd1$1(double d, double d2, double d3, double d4) {
            return d == this.position() && d2 == this.velocity() && d3 == this.thermalEnergy() && d4 == this.crashEnergy();
        }

        public SettableState(Grounded $outer, double position, double velocity, double thermalEnergy, double crashEnergy) {
            this.position = position;
            this.velocity = velocity;
            this.thermalEnergy = thermalEnergy;
            this.crashEnergy = crashEnergy;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Product$class.$init$(this);
        }
    }
}

