/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.motionseries.graphics;

import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.motionseries.MotionSeriesDefaults$;
import edu.colorado.phet.motionseries.StageContainerArea;
import edu.colorado.phet.motionseries.graphics.MotionSeriesCanvasDecorator;
import edu.colorado.phet.motionseries.graphics.RampAngleIndicator;
import edu.colorado.phet.motionseries.graphics.RampHeightIndicator;
import edu.colorado.phet.motionseries.graphics.RotationHandler;
import edu.colorado.phet.motionseries.model.AdjustableCoordinateModel;
import edu.colorado.phet.motionseries.model.FreeBodyDiagramModel;
import edu.colorado.phet.motionseries.model.MotionSeriesModel;
import edu.colorado.phet.motionseries.model.VectorViewModel;
import edu.umd.cs.piccolo.PNode;
import java.awt.geom.Rectangle2D;
import javax.swing.JFrame;

public class RampCanvas
extends MotionSeriesCanvasDecorator {
    private final MotionSeriesModel model;

    public void addHeightAndAngleIndicators() {
        this.playAreaNode().addChild(new RampHeightIndicator(this.model.rightRampSegment(), this.transform()));
        this.playAreaNode().addChild(new RampAngleIndicator(this.model.rightRampSegment(), this.transform()));
    }

    public void attachListenerToRightWall(PNode wall) {
        wall.addInputEventListener(new CursorHandler());
        wall.addInputEventListener(new RotationHandler(this.transform(), wall, this.model.rightRampSegment(), 0.0, MotionSeriesDefaults$.MODULE$.MAX_ANGLE()));
    }

    public RampCanvas(MotionSeriesModel model, AdjustableCoordinateModel coordinateSystemModel, FreeBodyDiagramModel freeBodyDiagramModel, VectorViewModel vectorViewModel, JFrame frame, boolean showObjectSelectionNode, boolean showAppliedForceSlider, boolean rampAngleDraggable, Rectangle2D modelViewport, StageContainerArea stageContainerArea) {
        this.model = model;
        super(model, coordinateSystemModel, freeBodyDiagramModel, vectorViewModel, frame, showObjectSelectionNode, showAppliedForceSlider, rampAngleDraggable, modelViewport, stageContainerArea);
    }
}

