/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.tests;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.SwingClock;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.PhetFrameWorkaround;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;

public class TestPhetFrameWorkaround {

    private static class TestApplication
    extends PhetApplication {
        public TestApplication(PhetApplicationConfig phetApplicationConfig) {
            super(phetApplicationConfig);
            this.addModule(new TestModule(this.getPhetFrame()));
        }

        protected PhetFrame createPhetFrame() {
            return new PhetFrameWorkaround(this);
        }
    }

    private static class TestModule
    extends Module {
        private JButton contentPane = new JButton("Simulation Panel Button"){

            protected void paintComponent(Graphics graphics) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                super.paintComponent(graphics);
            }
        };

        public TestModule(final Frame frame) {
            super("test", new SwingClock(30, 1.0));
            this.setSimulationPanel(this.contentPane);
            this.getClock().addClockListener(new ClockAdapter(){

                public void clockTicked(ClockEvent clockEvent) {
                    TestModule.this.contentPane.invalidate();
                    TestModule.this.contentPane.revalidate();
                    TestModule.this.contentPane.repaint();
                    TestModule.this.contentPane.setText(System.currentTimeMillis() + " button time!");
                    TestModule.this.contentPane.paintImmediately(0, 0, TestModule.this.contentPane.getWidth(), TestModule.this.contentPane.getHeight());
                }
            });
            this.contentPane.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    final Dialog dialog = new Dialog(frame, false);
                    dialog.setSize(400, 300);
                    dialog.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            dialog.dispose();
                        }
                    });
                    Button button = new Button("dialog button");
                    button.setBackground(Color.green);
                    dialog.add(button);
                    dialog.setVisible(true);
                }
            });
        }
    }
}

