/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.charts;

import edu.colorado.phet.common.motion.MotionResources;
import edu.colorado.phet.common.motion.charts.Range;
import edu.colorado.phet.common.motion.tests.ColorArrows;
import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;

public abstract class MotionSliderNode
extends PNode {
    private PhetPPath trackPPath;
    protected PhetPPath tickMarkAtZero;
    private PNode sliderThumb;
    private double value = 0.0;
    private ArrayList<Listener> listeners = new ArrayList();
    private boolean highlighted = false;
    private Color highlightColor;
    private Function.LinearFunction transform;
    private Range modelRange;
    private Range viewRange;
    public final int TRACK_WIDTH = 5;
    public final int TICK_HEIGHT = 7;

    private static BufferedImage getBarImage(Color color) throws IOException {
        return ColorArrows.filter(MotionResources.loadBufferedImage("bar-template.png"), color);
    }

    public MotionSliderNode(final Range range, double d, final Range range2, final PNode pNode, Color color) {
        this.modelRange = range;
        this.viewRange = range2;
        this.value = d;
        this.transform = new Function.LinearFunction(range.getMin(), range.getMax(), range2.getMax(), range2.getMin());
        range.addObserver(new SimpleObserver(){

            public void update() {
                MotionSliderNode.this.transform.setInput(range.getMin(), range.getMax());
                MotionSliderNode.this.updateLayout();
            }
        });
        range2.addObserver(new SimpleObserver(){

            public void update() {
                MotionSliderNode.this.updateTransform(range2);
            }
        });
        this.updateTransform(range2);
        this.sliderThumb = pNode;
        this.highlightColor = color;
        this.sliderThumb.addInputEventListener(new CursorHandler());
        this.trackPPath = new PhetPPath(Color.white, (Stroke)new BasicStroke(1.0f), (Paint)Color.black);
        this.addChild(this.trackPPath);
        this.tickMarkAtZero = this.createTickMark();
        this.addChild(this.tickMarkAtZero);
        this.addChild(pNode);
        pNode.addInputEventListener(new PBasicInputEventHandler(){
            Point2D initDragPoint = null;
            double origValue;

            public void mousePressed(PInputEvent pInputEvent) {
                this.initDragPoint = pInputEvent.getPositionRelativeTo(pNode.getParent());
                this.origValue = MotionSliderNode.this.value < range.getMin() ? range.getMin() : (MotionSliderNode.this.value > range.getMax() ? range.getMax() : MotionSliderNode.this.value);
                MotionSliderNode.this.notifySliderThumbGrabbed();
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                this.initDragPoint = null;
                MotionSliderNode.this.notifySliderThumbReleased();
            }

            public void mouseDragged(PInputEvent pInputEvent) {
                if (this.initDragPoint == null) {
                    this.mousePressed(pInputEvent);
                }
                double d = MotionSliderNode.this.getDragViewDelta(pInputEvent, this.initDragPoint);
                double d2 = MotionSliderNode.this.viewToModelDelta(d);
                double d3 = MotionSliderNode.this.clamp(this.origValue + d2);
                MotionSliderNode.this.notifySliderDragged(d3);
            }
        });
        this.updateLayout();
        this.updateTrackPPathStrokeAndPaint();
    }

    private void notifySliderThumbReleased() {
        for (Listener listener : this.listeners) {
            listener.sliderThumbReleased();
        }
    }

    protected abstract PhetPPath createTickMark();

    protected abstract void updateTransform(Range var1);

    protected abstract double getDragViewDelta(PInputEvent var1, Point2D var2);

    private double viewToModelDelta(double d) {
        double d2 = this.transform.createInverse().evaluate(0.0);
        double d3 = this.transform.createInverse().evaluate(d);
        return d3 - d2;
    }

    public void setViewRange(double d, double d2) {
        this.viewRange.setMin(d);
        this.viewRange.setMax(d2);
        this.updateLayout();
    }

    protected void updateLayout() {
        this.updateTrackPath();
        this.updateTickMarkAtZero();
        this.updateThumb();
    }

    protected abstract void updateTickMarkAtZero();

    protected abstract void updateTrackPath();

    private void notifySliderDragged(double d) {
        for (Listener listener : this.listeners) {
            listener.sliderDragged(d);
        }
    }

    private void notifySliderThumbGrabbed() {
        for (Listener listener : this.listeners) {
            listener.sliderThumbGrabbed();
        }
    }

    public double clamp(double d) {
        return MathUtil.clamp(this.modelRange.getMin(), d, this.modelRange.getMax());
    }

    public void setValue(double d) {
        if (this.value != d) {
            this.value = d;
            this.updateThumb();
            this.notifyValueChanged();
        }
    }

    protected void updateThumb() {
        this.updateThumbLocation();
        this.updateThumbToIndicateOutOfRange();
    }

    protected void updateThumbLocation() {
        this.setThumbLocation(this.modelToView(this.clamp(this.value)));
    }

    protected void updateThumbToIndicateOutOfRange() {
        this.getSliderThumb().setRotation(0.0);
        double d = this.getDistanceOutOfRange();
        if (d > 0.0) {
            Function.LinearFunction linearFunction = new Function.LinearFunction(0.0, 20.0, 1.0, 0.2);
            double d2 = MathUtil.clamp(0.2, linearFunction.evaluate(d), 1.0);
            this.getSliderThumb().setTransparency((float)d2);
        } else {
            this.getSliderThumb().setTransparency(1.0f);
        }
    }

    private double getDistanceOutOfRange() {
        if (this.clamp(this.getValue()) < this.getValue()) {
            return this.getValue() - this.getMax();
        }
        if (this.clamp(this.getValue()) > this.getValue()) {
            return this.getMin() - this.getValue();
        }
        return 0.0;
    }

    protected abstract void setThumbLocation(double var1);

    private double modelToView(double d) {
        return this.transform.evaluate(d);
    }

    public double getValue() {
        return this.value;
    }

    private void updateTrackPPathStrokeAndPaint() {
        this.trackPPath.setStroke(new BasicStroke(this.highlighted ? 2.0f : 1.0f));
        this.trackPPath.setStrokePaint(this.highlighted ? this.highlightColor : Color.black);
    }

    protected void setTrackPath(Shape shape) {
        this.trackPPath.setPathTo(shape);
    }

    public PNode getSliderThumb() {
        return this.sliderThumb;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    private void notifyValueChanged() {
        for (Listener listener : this.listeners) {
            listener.valueChanged();
        }
    }

    public boolean contains(double d) {
        return d >= this.getMin() && d <= this.getMax();
    }

    public double getMin() {
        return this.modelRange.getMin();
    }

    public double getMax() {
        return this.modelRange.getMax();
    }

    public double getViewMin() {
        return this.viewRange.getMin();
    }

    public double getViewMax() {
        return this.viewRange.getMax();
    }

    protected PNode getTrackNode() {
        return this.trackPPath;
    }

    public void setModelRange(double d, double d2) {
        this.modelRange.setMin(d);
        this.modelRange.setMax(d2);
    }

    public static class Horizontal
    extends MotionSliderNode {
        public Horizontal(Range range, double d, Range range2, Color color) throws IOException {
            this(range, d, range2, new PImage(BufferedImageUtils.flipY(BufferedImageUtils.getRotatedImage(MotionSliderNode.getBarImage(color), -1.5707963267948966))), color);
        }

        public Horizontal(Range range, double d, Range range2, PNode pNode, Color color) {
            super(range, d, range2, pNode, color);
        }

        protected PhetPPath createTickMark() {
            Line2D.Double double_ = this.createTickMarkPath(0.0);
            return new PhetPPath(double_, Color.black, new BasicStroke(2.0f), Color.black);
        }

        private Line2D.Double createTickMarkPath(double d) {
            Line2D.Double double_ = new Line2D.Double(0.0, 0.0, 0.0, d / 2.0 + 2.0);
            return double_;
        }

        protected void updateTransform(Range range) {
            ((MotionSliderNode)this).transform.setOutput(range.getMin(), range.getMax());
        }

        protected void updateTrackPath() {
            this.setTrackPath(new Rectangle2D.Double(this.getViewMin(), 0.0, this.getViewMax(), 5.0));
        }

        protected void setThumbLocation(double d) {
            this.getSliderThumb().setRotation(0.0);
            this.getSliderThumb().setOffset(d - this.getSliderThumb().getFullBounds().getWidth() / 2.0, this.getTrackNode().getFullBounds().getCenterY() - this.getSliderThumb().getFullBounds().getHeight() / 2.0);
        }

        protected double getDragViewDelta(PInputEvent pInputEvent, Point2D point2D) {
            double d = pInputEvent.getPositionRelativeTo(this.getSliderThumb().getParent()).getX();
            double d2 = d - point2D.getX();
            return d2;
        }

        protected void updateTickMarkAtZero() {
            this.tickMarkAtZero.setPathTo(this.createTickMarkPath(this.getSliderThumb().getFullBounds().getHeight()));
            this.tickMarkAtZero.setOffset((this.getViewMin() + this.getViewMax()) / 2.0 - this.tickMarkAtZero.getFullBounds().getWidth() / 2.0, 0.0);
            this.tickMarkAtZero.setVisible(this.contains(0.0));
        }
    }

    public static class Vertical
    extends MotionSliderNode {
        public Vertical(Range range, double d, Range range2, PNode pNode, Color color) {
            super(range, d, range2, pNode, color);
        }

        protected PhetPPath createTickMark() {
            return new PhetPPath(new Line2D.Double(0.0, 0.0, 7.0, 0.0), Color.black, new BasicStroke(2.0f), Color.black);
        }

        protected void updateTransform(Range range) {
            ((MotionSliderNode)this).transform.setOutput(range.getMax(), range.getMin());
        }

        protected double getDragViewDelta(PInputEvent pInputEvent, Point2D point2D) {
            double d = pInputEvent.getPositionRelativeTo(super.getSliderThumb().getParent()).getY();
            double d2 = d - point2D.getY();
            return d2;
        }

        protected void updateTickMarkAtZero() {
            this.tickMarkAtZero.setVisible(false);
        }

        protected void updateTrackPath() {
            this.setTrackPath(new Rectangle2D.Double(0.0, this.getViewMin(), 5.0, this.getViewMax()));
        }

        protected void setThumbLocation(double d) {
            this.getSliderThumb().setRotation(0.0);
            this.getSliderThumb().setOffset(super.getTrackNode().getFullBounds().getCenterX() - this.getSliderThumb().getFullBounds().getWidth() / 2.0, d - this.getSliderThumb().getFullBounds().getHeight() / 2.0);
        }
    }

    public static class Adapter
    implements Listener {
        public void valueChanged() {
        }

        public void sliderThumbGrabbed() {
        }

        public void sliderThumbReleased() {
        }

        public void sliderDragged(Double d) {
        }
    }

    public static interface Listener {
        public void valueChanged();

        public void sliderThumbGrabbed();

        public void sliderThumbReleased();

        public void sliderDragged(Double var1);
    }
}

