/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculesandlight.view;

import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.common.phetcommon.view.PhetTitledPanel;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.photonabsorption.model.Molecule;
import edu.colorado.phet.common.photonabsorption.model.PhotonAbsorptionModel;
import edu.colorado.phet.common.photonabsorption.model.molecules.CO;
import edu.colorado.phet.common.photonabsorption.model.molecules.CO2;
import edu.colorado.phet.common.photonabsorption.model.molecules.H2O;
import edu.colorado.phet.common.photonabsorption.model.molecules.N2;
import edu.colorado.phet.common.photonabsorption.model.molecules.NO2;
import edu.colorado.phet.common.photonabsorption.model.molecules.O2;
import edu.colorado.phet.common.photonabsorption.model.molecules.O3;
import edu.colorado.phet.common.photonabsorption.view.MoleculeNode;
import edu.colorado.phet.common.photonabsorption.view.MoleculeSelectorPanel;
import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.moleculesandlight.MoleculesAndLightResources;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;

public class MoleculesAndLightControlPanel
extends ControlPanel {
    private static final ModelViewTransform2D MVT = new ModelViewTransform2D((Point2D)new Point2D.Double(0.0, 0.0), (Point2D)new Point(0, 0), 1.0, true);
    private final ArrayList<MoleculeSelectorPanel> moleculeSelectors = new ArrayList();

    public MoleculesAndLightControlPanel(PiccoloModule piccoloModule, PhotonAbsorptionModel photonAbsorptionModel) {
        int n = MoleculesAndLightResources.getInt("int.minControlPanelWidth", 215);
        this.setMinimumWidth(n);
        PhetTitledPanel phetTitledPanel = new PhetTitledPanel(MoleculesAndLightResources.getString("ControlPanel.Molecule"));
        phetTitledPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.addControlFullWidth(phetTitledPanel);
        this.moleculeSelectors.add(new MoleculeSelectorPanel(MoleculesAndLightResources.getString("ControlPanel.CarbonMonoxide"), MoleculesAndLightResources.getString("ControlPanel.CO"), this.createMoleculeImage(new CO(), 0.13), photonAbsorptionModel, PhotonAbsorptionModel.PhotonTarget.SINGLE_CO_MOLECULE));
        this.moleculeSelectors.add(new MoleculeSelectorPanel(MoleculesAndLightResources.getString("ControlPanel.Nitrogen"), MoleculesAndLightResources.getString("ControlPanel.N2"), this.createMoleculeImage(new N2(), 0.13), photonAbsorptionModel, PhotonAbsorptionModel.PhotonTarget.SINGLE_N2_MOLECULE));
        this.moleculeSelectors.add(new MoleculeSelectorPanel(MoleculesAndLightResources.getString("ControlPanel.Oxygen"), MoleculesAndLightResources.getString("ControlPanel.O2"), this.createMoleculeImage(new O2(), 0.13), photonAbsorptionModel, PhotonAbsorptionModel.PhotonTarget.SINGLE_O2_MOLECULE));
        this.moleculeSelectors.add(new MoleculeSelectorPanel(MoleculesAndLightResources.getString("ControlPanel.CarbonDioxide"), MoleculesAndLightResources.getString("ControlPanel.CO2"), this.createMoleculeImage(new CO2(), 0.13), photonAbsorptionModel, PhotonAbsorptionModel.PhotonTarget.SINGLE_CO2_MOLECULE));
        this.moleculeSelectors.add(new MoleculeSelectorPanel(MoleculesAndLightResources.getString("ControlPanel.Water"), MoleculesAndLightResources.getString("ControlPanel.H2O"), this.createMoleculeImage(new H2O(), 0.13), photonAbsorptionModel, PhotonAbsorptionModel.PhotonTarget.SINGLE_H2O_MOLECULE));
        this.moleculeSelectors.add(new MoleculeSelectorPanel(MoleculesAndLightResources.getString("ControlPanel.NitrogenDioxide"), MoleculesAndLightResources.getString("ControlPanel.NO2"), this.createMoleculeImage(new NO2(), 0.13), photonAbsorptionModel, PhotonAbsorptionModel.PhotonTarget.SINGLE_NO2_MOLECULE));
        this.moleculeSelectors.add(new MoleculeSelectorPanel(MoleculesAndLightResources.getString("ControlPanel.Ozone"), MoleculesAndLightResources.getString("ControlPanel.O3"), this.createMoleculeImage(new O3(), 0.13), photonAbsorptionModel, PhotonAbsorptionModel.PhotonTarget.SINGLE_O3_MOLECULE));
        int n2 = 15;
        ButtonGroup buttonGroup = new ButtonGroup();
        for (MoleculeSelectorPanel moleculeSelectorPanel : this.moleculeSelectors) {
            phetTitledPanel.add((Component)this.createVerticalSpacingPanel(n2), gridBagConstraints);
            phetTitledPanel.add((Component)moleculeSelectorPanel, gridBagConstraints);
            buttonGroup.add(moleculeSelectorPanel.getRadioButton());
        }
        phetTitledPanel.add((Component)this.createVerticalSpacingPanel(n2), gridBagConstraints);
        this.addControlFullWidth(this.createVerticalSpacingPanel(5));
        this.addResetAllButton(piccoloModule);
    }

    private JPanel createVerticalSpacingPanel(int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createVerticalStrut(n));
        return jPanel;
    }

    private BufferedImage createMoleculeImage(Molecule molecule, double d) {
        BufferedImage bufferedImage = new MoleculeNode(molecule, MVT).getImage();
        return BufferedImageUtils.multiScale(bufferedImage, d);
    }
}

