/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculesandlight.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.photonabsorption.model.Molecule;
import edu.colorado.phet.common.photonabsorption.model.Photon;
import edu.colorado.phet.common.photonabsorption.model.PhotonAbsorptionModel;
import edu.colorado.phet.common.photonabsorption.view.MoleculeNode;
import edu.colorado.phet.common.photonabsorption.view.PhotonEmitterNode;
import edu.colorado.phet.common.photonabsorption.view.PhotonNode;
import edu.colorado.phet.common.photonabsorption.view.VerticalRodNode;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.ButtonNode;
import edu.colorado.phet.moleculesandlight.MoleculesAndLightModule;
import edu.colorado.phet.moleculesandlight.MoleculesAndLightResources;
import edu.colorado.phet.moleculesandlight.view.QuadEmissionFrequencyControlPanel;
import edu.colorado.phet.moleculesandlight.view.SpectrumWindow;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;

public class MoleculesAndLightCanvas
extends PhetPCanvas {
    private static final PDimension INTERMEDIATE_RENDERING_SIZE = new PDimension(786.0, 786.0);
    private final ModelViewTransform2D mvt;
    private final PhotonAbsorptionModel photonAbsorptionModel;
    PNode myWorldNode;
    private final PNode moleculeLayer;
    private final PNode photonLayer;
    private final PNode photonEmitterLayer;
    private final HashMap<Photon, PhotonNode> photonMap = new HashMap();
    private final HashMap<Molecule, MoleculeNode> moleculeMap = new HashMap();
    private final ButtonNode restoreMoleculeButtonNode;
    private final Molecule.Adapter moleculeMotionListener = new Molecule.Adapter(){

        public void centerOfGravityPosChanged(Molecule molecule) {
            MoleculesAndLightCanvas.this.updateRestoreMolecueButtonVisibility();
        }
    };
    private final ButtonNode showSpectrumButton = new ButtonNode(MoleculesAndLightResources.getString("SpectrumWindow.buttonCaption"), 24, new Color(185, 178, 95));
    private final SpectrumWindow spectrumWindow = new SpectrumWindow(){
        {
            this.setVisible(false);
        }
    };

    public MoleculesAndLightCanvas(Frame frame, final MoleculesAndLightModule moleculesAndLightModule, final PhotonAbsorptionModel photonAbsorptionModel) {
        this.photonAbsorptionModel = photonAbsorptionModel;
        moleculesAndLightModule.getWhiteBackgroundProperty().addObserver(new SimpleObserver(){

            public void update() {
                MoleculesAndLightCanvas.this.setBackground(moleculesAndLightModule.getWhiteBackgroundProperty().getValue() != false ? Color.white : Color.black);
            }
        });
        this.setWorldTransformStrategy(new PhetPCanvas.CenteringBoxStrategy(this, INTERMEDIATE_RENDERING_SIZE));
        this.mvt = new ModelViewTransform2D((Point2D)new Point2D.Double(0.0, 0.0), (Point2D)new Point((int)Math.round(MoleculesAndLightCanvas.INTERMEDIATE_RENDERING_SIZE.width * 0.65), (int)Math.round(MoleculesAndLightCanvas.INTERMEDIATE_RENDERING_SIZE.height * 0.35)), 0.18, true);
        photonAbsorptionModel.addListener(new PhotonAbsorptionModel.Adapter(){

            public void photonRemoved(Photon photon) {
                if (MoleculesAndLightCanvas.this.photonLayer.removeChild((PNode)MoleculesAndLightCanvas.this.photonMap.get(photon)) == null) {
                    System.out.println(this.getClass().getName() + " - Error: PhotonNode not found for photon.");
                }
                MoleculesAndLightCanvas.this.photonMap.remove(photon);
            }

            public void photonAdded(Photon photon) {
                PhotonNode photonNode = new PhotonNode(photon, MoleculesAndLightCanvas.this.mvt);
                MoleculesAndLightCanvas.this.photonLayer.addChild(photonNode);
                MoleculesAndLightCanvas.this.photonMap.put(photon, photonNode);
            }

            public void moleculeRemoved(Molecule molecule) {
                MoleculesAndLightCanvas.this.removeMolecule(molecule);
            }

            public void moleculeAdded(Molecule molecule) {
                MoleculesAndLightCanvas.this.addMolecule(molecule);
            }

            public void modelReset() {
                MoleculesAndLightCanvas.this.spectrumWindow.setVisible(false);
                MoleculesAndLightCanvas.this.spectrumWindow.setToDefaultSizeAndPosition();
            }
        });
        this.myWorldNode = new PNode();
        this.addWorldChild(this.myWorldNode);
        this.moleculeLayer = new PNode();
        this.myWorldNode.addChild(this.moleculeLayer);
        this.photonLayer = new PNode();
        this.myWorldNode.addChild(this.photonLayer);
        this.photonEmitterLayer = new PNode();
        this.myWorldNode.addChild(this.photonEmitterLayer);
        QuadEmissionFrequencyControlPanel quadEmissionFrequencyControlPanel = new QuadEmissionFrequencyControlPanel(photonAbsorptionModel);
        quadEmissionFrequencyControlPanel.setOffset(-30.0, 500.0);
        PhotonEmitterNode photonEmitterNode = new PhotonEmitterNode(300.0, this.mvt, photonAbsorptionModel);
        photonEmitterNode.setOffset(this.mvt.modelToViewDouble(photonAbsorptionModel.getPhotonEmissionLocation()));
        VerticalRodNode verticalRodNode = new VerticalRodNode(30.0, Math.abs(photonEmitterNode.getFullBoundsReference().getCenterY() - quadEmissionFrequencyControlPanel.getFullBoundsReference().getCenterY()), new Color(205, 198, 115));
        verticalRodNode.setOffset(photonEmitterNode.getFullBoundsReference().getCenterX() - verticalRodNode.getFullBoundsReference().width / 2.0, photonEmitterNode.getFullBoundsReference().getCenterY());
        this.restoreMoleculeButtonNode = new ButtonNode(MoleculesAndLightResources.getString("ButtonNode.ReturnMolecule"), 24, new Color(255, 144, 0));
        this.restoreMoleculeButtonNode.setOffset(MoleculesAndLightCanvas.INTERMEDIATE_RENDERING_SIZE.width - this.restoreMoleculeButtonNode.getFullBounds().getWidth(), 50.0);
        this.restoreMoleculeButtonNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                photonAbsorptionModel.restorePhotonTarget();
            }
        });
        this.myWorldNode.addChild(this.restoreMoleculeButtonNode);
        this.updateRestoreMolecueButtonVisibility();
        this.photonEmitterLayer.addChild(verticalRodNode);
        this.photonEmitterLayer.addChild(photonEmitterNode);
        this.photonEmitterLayer.addChild(quadEmissionFrequencyControlPanel);
        for (Molecule molecule : photonAbsorptionModel.getMolecules()) {
            this.addMolecule(molecule);
        }
        this.myWorldNode.addChild(this.showSpectrumButton);
        this.showSpectrumButton.setOffset(0.0, 700.0);
        this.showSpectrumButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!MoleculesAndLightCanvas.this.spectrumWindow.isVisible() && (MoleculesAndLightCanvas.this.spectrumWindow.getExtendedState() & 6) == 6) {
                    MoleculesAndLightCanvas.this.spectrumWindow.setExtendedState(MoleculesAndLightCanvas.this.spectrumWindow.getExtendedState() & 0xFFFFFFF9);
                }
                if (MoleculesAndLightCanvas.this.spectrumWindow.getState() == 1) {
                    MoleculesAndLightCanvas.this.spectrumWindow.setState(0);
                }
                MoleculesAndLightCanvas.this.spectrumWindow.setVisible(true);
            }
        });
        this.updateLayout();
    }

    private void addMolecule(Molecule molecule) {
        molecule.addListener(this.moleculeMotionListener);
        MoleculeNode moleculeNode = new MoleculeNode(molecule, this.mvt);
        this.moleculeLayer.addChild(moleculeNode);
        this.moleculeMap.put(molecule, moleculeNode);
        this.updateRestoreMolecueButtonVisibility();
    }

    private void removeMolecule(Molecule molecule) {
        if (this.moleculeLayer.removeChild(this.moleculeMap.get(molecule)) == null) {
            System.out.println(this.getClass().getName() + " - Error: MoleculeNode not found for molecule.");
        }
        this.moleculeMap.remove(molecule);
        this.updateRestoreMolecueButtonVisibility();
        molecule.removeListener(this.moleculeMotionListener);
    }

    private void updateRestoreMolecueButtonVisibility() {
        boolean bl = false;
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, MoleculesAndLightCanvas.INTERMEDIATE_RENDERING_SIZE.width, MoleculesAndLightCanvas.INTERMEDIATE_RENDERING_SIZE.height);
        for (Molecule molecule : this.photonAbsorptionModel.getMolecules()) {
            if (double_.contains(this.mvt.modelToView(molecule.getCenterOfGravityPos()))) continue;
            bl = true;
            break;
        }
        this.restoreMoleculeButtonNode.setVisible(bl);
    }
}

