/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculesandlight;

import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.photonabsorption.model.PhotonAbsorptionModel;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.PiccoloClockControlPanel;
import edu.colorado.phet.moleculesandlight.MoleculesAndLightResources;
import edu.colorado.phet.moleculesandlight.view.MoleculesAndLightCanvas;
import edu.colorado.phet.moleculesandlight.view.MoleculesAndLightControlPanel;
import java.awt.Frame;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoleculesAndLightModule
extends PiccoloModule {
    private final PhotonAbsorptionModel model;
    private final PhetPCanvas canvas;
    private final MoleculesAndLightControlPanel controlPanel;
    private PiccoloClockControlPanel clockControlPanel;
    private final Property<Boolean> whiteBackgroundProperty = new Property<Boolean>(false);

    public MoleculesAndLightModule(Frame frame) {
        super(MoleculesAndLightResources.getString("ModuleTitle.MoleculesAndLightModule"), new ConstantDtClock(40, 40.0));
        this.model = new PhotonAbsorptionModel((ConstantDtClock)this.getClock(), PhotonAbsorptionModel.PhotonTarget.SINGLE_CO_MOLECULE);
        this.canvas = new MoleculesAndLightCanvas(frame, this, this.model);
        this.setSimulationPanel(this.canvas);
        this.controlPanel = new MoleculesAndLightControlPanel(this, this.model);
        this.setControlPanel(this.controlPanel);
        this.reset();
    }

    @Override
    protected JComponent createClockControlPanel(IClock iClock) {
        this.clockControlPanel = new PiccoloClockControlPanel(iClock);
        return this.clockControlPanel;
    }

    @Override
    public void reset() {
        this.model.reset();
    }

    public Property<Boolean> getWhiteBackgroundProperty() {
        return this.whiteBackgroundProperty;
    }
}

