/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.colorado.phet.common.phetcommon.util.PhetUtilities;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.ButtonEventHandler;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.ToolTipNode;
import edu.colorado.phet.common.piccolophet.util.PNodeLayoutUtils;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.color.ColorSpace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.util.ArrayList;

public class ButtonNode
extends PhetPNode {
    private final PNode parentNode;
    private final ArrayList<ActionListener> actionListeners;
    private String text;
    private BufferedImage image;
    private BufferedImage disabledImage;
    private Font font;
    private Color foreground;
    private Color background;
    private Color shadowColor;
    private Color strokeColor;
    private Color disabledForeground;
    private Color disabledBackground;
    private Color disabledShadowColor;
    private Color disabledStrokeColor;
    private TextPosition textPosition;
    private boolean enabled;
    private Insets margin;
    private int imageTextGap;
    private int cornerRadius;
    private int shadowOffset;
    private String toolTipText;
    private PPath backgroundNode;
    private boolean focus;
    private boolean armed;
    private Paint mouseNotOverGradient;
    private Paint mouseOverGradient;
    private Paint armedGradient;

    public ButtonNode() {
        this((String)null, (BufferedImage)null);
    }

    public ButtonNode(String string) {
        this(string, (BufferedImage)null);
    }

    public ButtonNode(String string, BufferedImage bufferedImage) {
        this.text = string;
        this.image = bufferedImage;
        this.disabledImage = null;
        this.font = new PhetFont(1, 14);
        this.foreground = Color.BLACK;
        this.background = Color.GRAY;
        this.shadowColor = new Color(0.0f, 0.0f, 0.0f, 0.2f);
        this.strokeColor = Color.BLACK;
        this.disabledForeground = new Color(180, 180, 180);
        this.disabledBackground = new Color(210, 210, 210);
        this.disabledShadowColor = new Color(0, 0, 0, 0);
        this.disabledStrokeColor = new Color(190, 190, 190);
        this.textPosition = TextPosition.RIGHT;
        this.enabled = true;
        this.margin = new Insets(3, 10, 3, 10);
        this.imageTextGap = 5;
        this.cornerRadius = 8;
        this.shadowOffset = 3;
        this.toolTipText = null;
        this.parentNode = new PNode();
        this.addChild(this.parentNode);
        this.actionListeners = new ArrayList();
        this.update();
    }

    public ButtonNode(String string, Color color) {
        this(string);
        this.setBackground(color);
    }

    public ButtonNode(String string, int n, Color color) {
        this(string);
        this.setFont(new PhetFont(1, n));
        this.setBackground(color);
    }

    private void update() {
        double d;
        double d2;
        this.parentNode.removeAllChildren();
        PNode pNode = ButtonNode.createTextNode(this.text, this.font, this.foreground, this.disabledForeground, this.enabled);
        PNode pNode2 = ButtonNode.createImageNode(this.image, this.disabledImage, this.enabled);
        PComposite pComposite = new PComposite();
        pComposite.addChild(pNode);
        pComposite.addChild(pNode2);
        double d3 = 0.0;
        double d4 = 0.0;
        PBounds pBounds = pNode.getFullBoundsReference();
        PBounds pBounds2 = pNode2.getFullBoundsReference();
        if (this.textPosition == TextPosition.ABOVE) {
            d2 = 0.0;
            d3 = pBounds.getCenterX() - pBounds2.getWidth() / 2.0;
            d = 0.0;
            d4 = pBounds.getMaxY() + (double)this.imageTextGap;
        } else if (this.textPosition == TextPosition.BELOW) {
            d3 = 0.0;
            d2 = pBounds2.getCenterX() - pBounds.getWidth() / 2.0;
            d4 = 0.0;
            d = pBounds2.getMaxY() + (double)this.imageTextGap;
        } else if (this.textPosition == TextPosition.LEFT) {
            d2 = 0.0;
            d3 = pBounds.getMaxX() + (double)this.imageTextGap;
            d = 0.0;
            d4 = pBounds.getCenterY() - pBounds2.getHeight() / 2.0;
        } else if (this.textPosition == TextPosition.RIGHT) {
            d3 = 0.0;
            d2 = pBounds2.getMaxX() + (double)this.imageTextGap;
            d4 = 0.0;
            d = pBounds2.getCenterY() - pBounds.getHeight() / 2.0;
        } else {
            throw new UnsupportedOperationException("unsupported text position: " + (Object)((Object)this.textPosition));
        }
        pNode.setOffset(d2, d);
        pNode2.setOffset(d3, d4);
        double d5 = pComposite.getFullBoundsReference().getWidth() + (double)this.margin.left + (double)this.margin.right;
        double d6 = pComposite.getFullBoundsReference().getHeight() + (double)this.margin.top + (double)this.margin.bottom;
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, d5, d6, this.cornerRadius, this.cornerRadius);
        this.mouseNotOverGradient = this.createMouseNotOverGradient(d5, d6);
        this.mouseOverGradient = this.createMouseOverGradient(d5, d6);
        this.armedGradient = this.createArmedGradient(d5, d6);
        this.backgroundNode = new PPath(double_);
        this.backgroundNode.addInputEventListener(new CursorHandler());
        if (this.enabled) {
            this.backgroundNode.setPaint(this.mouseNotOverGradient);
            this.backgroundNode.setStrokePaint(this.strokeColor);
        } else {
            this.backgroundNode.setPaint(this.createDisabledGradient(d5, d6));
            this.backgroundNode.setStrokePaint(this.disabledStrokeColor);
        }
        PPath pPath = new PPath(double_);
        pPath.setPickable(false);
        pPath.setOffset(this.shadowOffset, this.shadowOffset);
        pPath.setStroke(null);
        pPath.setPaint(this.enabled ? this.shadowColor : this.disabledShadowColor);
        this.backgroundNode.addChild(pComposite);
        double d7 = (double)this.margin.left - PNodeLayoutUtils.getOriginXOffset(pComposite);
        double d8 = (double)this.margin.top - PNodeLayoutUtils.getOriginYOffset(pComposite);
        pComposite.setOffset(d7, d8);
        this.parentNode.addChild(pPath);
        this.parentNode.addChild(this.backgroundNode);
        ButtonEventHandler buttonEventHandler = new ButtonEventHandler();
        this.backgroundNode.addInputEventListener(buttonEventHandler);
        buttonEventHandler.addButtonEventListener(new ButtonEventHandler.ButtonEventListener(){

            public void setFocus(boolean bl) {
                ButtonNode.this.setFocus(bl);
            }

            public void setArmed(boolean bl) {
                ButtonNode.this.setArmed(bl);
            }

            public void fire() {
                ButtonNode.this.notifyActionPerformed();
            }
        });
        if (this.toolTipText != null) {
            this.parentNode.addChild(new ToolTipNode(this.toolTipText, this));
        }
        this.setPickable(this.enabled);
        this.setChildrenPickable(this.enabled);
    }

    protected void setFocus(boolean bl) {
        if (bl != this.focus) {
            this.focus = bl;
            this.updateAppearance();
        }
    }

    protected void setArmed(boolean bl) {
        if (bl != this.armed) {
            this.armed = bl;
            this.updateAppearance();
        }
    }

    private void updateAppearance() {
        if (this.enabled) {
            if (this.armed) {
                this.backgroundNode.setPaint(this.armedGradient);
                this.backgroundNode.setOffset(this.shadowOffset, this.shadowOffset);
            } else {
                this.backgroundNode.setPaint(this.focus ? this.mouseOverGradient : this.mouseNotOverGradient);
                this.backgroundNode.setOffset(0.0, 0.0);
            }
        }
    }

    public void setFont(Font font) {
        if (!font.equals(this.font)) {
            this.font = font;
            this.update();
        }
    }

    public void setBackground(Color color) {
        if (!color.equals(this.background)) {
            this.background = color;
            this.update();
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    private void notifyActionPerformed() {
        ActionEvent actionEvent = new ActionEvent(this, 0, "BUTTON_FIRED");
        for (ActionListener actionListener : new ArrayList<ActionListener>(this.actionListeners)) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    private static PNode createTextNode(String string, Font font, Color color, Color color2, boolean bl) {
        PNode pNode = null;
        if (string != null) {
            HTMLNode hTMLNode = new HTMLNode(string, bl ? color : color2);
            hTMLNode.setFont(font);
            hTMLNode.setPickable(false);
            pNode = hTMLNode;
        } else {
            pNode = new PNode();
        }
        return pNode;
    }

    private static PNode createImageNode(BufferedImage bufferedImage, BufferedImage bufferedImage2, boolean bl) {
        PNode pNode = null;
        pNode = bufferedImage != null ? (bl ? new PImage(bufferedImage) : (bufferedImage2 != null ? new PImage(bufferedImage2) : new PImage(ButtonNode.createGrayscaleImage(bufferedImage)))) : new PNode();
        return pNode;
    }

    private static BufferedImage createGrayscaleImage(BufferedImage bufferedImage) {
        ColorSpace colorSpace = ColorSpace.getInstance(1003);
        ColorConvertOp colorConvertOp = new ColorConvertOp(colorSpace, null);
        return colorConvertOp.filter(bufferedImage, null);
    }

    protected Paint createMouseNotOverGradient(double d, double d2) {
        return this.createGradient(ButtonNode.createBrighterColor(this.background), this.background, d, d2);
    }

    protected Paint createMouseOverGradient(double d, double d2) {
        return this.createGradient(ButtonNode.createBrighterColor(ButtonNode.createBrighterColor(this.background)), ButtonNode.createBrighterColor(this.background), d, d2);
    }

    protected Paint createArmedGradient(double d, double d2) {
        return this.createGradient(this.background, ButtonNode.createBrighterColor(this.background), d, d2);
    }

    private Paint createDisabledGradient(double d, double d2) {
        return this.createGradient(ButtonNode.createBrighterColor(this.disabledBackground), this.disabledBackground, d, d2);
    }

    private Paint createGradient(Color color, Color color2, double d, double d2) {
        if (this.useGradient()) {
            return new GradientPaint((float)d / 2.0f, 0.0f, color, (float)d * 0.5f, (float)d2, color2);
        }
        return color2;
    }

    private boolean useGradient() {
        return !PhetUtilities.isMacintosh();
    }

    private static Color createBrighterColor(Color color) {
        int n = color.getRed() + (int)Math.round((double)(255 - color.getRed()) * 0.5);
        int n2 = color.getGreen() + (int)Math.round((double)(255 - color.getGreen()) * 0.5);
        int n3 = color.getBlue() + (int)Math.round((double)(255 - color.getBlue()) * 0.5);
        int n4 = color.getAlpha();
        return new Color(n, n2, n3, n4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TextPosition
    extends Enum<TextPosition> {
        public static final /* enum */ TextPosition ABOVE = new TextPosition();
        public static final /* enum */ TextPosition BELOW = new TextPosition();
        public static final /* enum */ TextPosition LEFT = new TextPosition();
        public static final /* enum */ TextPosition RIGHT = new TextPosition();
        private static final /* synthetic */ TextPosition[] $VALUES;

        public static TextPosition[] values() {
            return (TextPosition[])$VALUES.clone();
        }

        static {
            $VALUES = new TextPosition[]{ABOVE, BELOW, LEFT, RIGHT};
        }
    }
}

