/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.photonabsorption.model.molecules;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.photonabsorption.model.Molecule;
import edu.colorado.phet.common.photonabsorption.model.PhotonAbsorptionStrategy;
import edu.colorado.phet.common.photonabsorption.model.atoms.AtomicBond;
import edu.colorado.phet.common.photonabsorption.model.atoms.NitrogenAtom;
import edu.colorado.phet.common.photonabsorption.model.atoms.OxygenAtom;
import edu.colorado.phet.common.photonabsorption.model.molecules.NO;
import edu.colorado.phet.common.photonabsorption.model.molecules.O;
import java.awt.geom.Point2D;
import java.util.Random;

public class NO2
extends Molecule {
    private static final double INITIAL_MOLECULE_HEIGHT = 180.0 * Math.cos(1.0471975511965976);
    private static final double INITIAL_NITROGEN_VERTICAL_OFFSET = INITIAL_MOLECULE_HEIGHT * 0.6316801450692292;
    private static final double INITIAL_OXYGEN_VERTICAL_OFFSET = -(INITIAL_MOLECULE_HEIGHT - INITIAL_NITROGEN_VERTICAL_OFFSET);
    private static final double INITIAL_OXYGEN_HORIZONTAL_OFFSET = 180.0 * Math.sin(1.0471975511965976);
    private static final Random RAND = new Random();
    private final NitrogenAtom nitrogenAtom = new NitrogenAtom();
    private final OxygenAtom rightOxygenAtom = new OxygenAtom();
    private final OxygenAtom leftOxygenAtom = new OxygenAtom();
    private final AtomicBond rightNitrogenOxygenBond;
    private final AtomicBond leftNitrogenOxygenBond;
    private final boolean doubleBondOnRight = RAND.nextBoolean();

    public NO2(Point2D point2D) {
        if (this.doubleBondOnRight) {
            this.rightNitrogenOxygenBond = new AtomicBond(this.nitrogenAtom, this.rightOxygenAtom, 2);
            this.leftNitrogenOxygenBond = new AtomicBond(this.nitrogenAtom, this.leftOxygenAtom, 1);
        } else {
            this.rightNitrogenOxygenBond = new AtomicBond(this.nitrogenAtom, this.rightOxygenAtom, 1);
            this.leftNitrogenOxygenBond = new AtomicBond(this.nitrogenAtom, this.leftOxygenAtom, 2);
        }
        this.addAtom(this.nitrogenAtom);
        this.addAtom(this.rightOxygenAtom);
        this.addAtom(this.leftOxygenAtom);
        this.addAtomicBond(this.rightNitrogenOxygenBond);
        this.addAtomicBond(this.leftNitrogenOxygenBond);
        this.setPhotonAbsorptionStrategy(20.0, new PhotonAbsorptionStrategy.RotationStrategy(this));
        this.setPhotonAbsorptionStrategy(8.5E-7, new PhotonAbsorptionStrategy.VibrationStrategy(this));
        this.setPhotonAbsorptionStrategy(5.8E-7, new PhotonAbsorptionStrategy.ExcitationStrategy(this));
        this.setPhotonAbsorptionStrategy(1.0E-7, new PhotonAbsorptionStrategy.BreakApartStrategy(this));
        this.initializeAtomOffsets();
        this.setCenterOfGravityPos(point2D);
    }

    public NO2() {
        this(new Point2D.Double(0.0, 0.0));
    }

    protected void initializeAtomOffsets() {
        this.addInitialAtomCogOffset(this.nitrogenAtom, new Vector2D(0.0, INITIAL_NITROGEN_VERTICAL_OFFSET));
        this.addInitialAtomCogOffset(this.rightOxygenAtom, new Vector2D(INITIAL_OXYGEN_HORIZONTAL_OFFSET, INITIAL_OXYGEN_VERTICAL_OFFSET));
        this.addInitialAtomCogOffset(this.leftOxygenAtom, new Vector2D(-INITIAL_OXYGEN_HORIZONTAL_OFFSET, INITIAL_OXYGEN_VERTICAL_OFFSET));
        this.updateAtomPositions();
    }

    public void setVibration(double d) {
        super.setVibration(d);
        double d2 = Math.sin(d);
        double d3 = 30.0;
        double d4 = 15.0;
        this.addInitialAtomCogOffset(this.nitrogenAtom, new Vector2D(0.0, INITIAL_NITROGEN_VERTICAL_OFFSET - d2 * d3));
        this.addInitialAtomCogOffset(this.rightOxygenAtom, new Vector2D(INITIAL_OXYGEN_HORIZONTAL_OFFSET + d2 * d4, INITIAL_OXYGEN_VERTICAL_OFFSET + d2 * d4));
        this.addInitialAtomCogOffset(this.leftOxygenAtom, new Vector2D(-INITIAL_OXYGEN_HORIZONTAL_OFFSET - d2 * d4, INITIAL_OXYGEN_VERTICAL_OFFSET + d2 * d4));
        this.updateAtomPositions();
    }

    public void breakApart() {
        double d;
        NO nO = new NO();
        O o = new O();
        double d2 = 0.5235987755982989;
        if (this.doubleBondOnRight) {
            nO.rotate(-d2);
            nO.setCenterOfGravityPos((this.getInitialAtomCogOffset(this.nitrogenAtom).getX() + this.getInitialAtomCogOffset(this.rightOxygenAtom).getX()) / 2.0, (this.getInitialAtomCogOffset(this.nitrogenAtom).getY() + this.getInitialAtomCogOffset(this.rightOxygenAtom).getY()) / 2.0);
            d = 0.7853981633974483 + RAND.nextDouble() * Math.PI / 4.0;
            o.setCenterOfGravityPos(-INITIAL_OXYGEN_HORIZONTAL_OFFSET, INITIAL_OXYGEN_VERTICAL_OFFSET);
        } else {
            nO.rotate(Math.PI + d2);
            d = 1.5707963267948966 + RAND.nextDouble() * Math.PI / 4.0;
            nO.setCenterOfGravityPos((this.getInitialAtomCogOffset(this.nitrogenAtom).getX() + this.getInitialAtomCogOffset(this.leftOxygenAtom).getX()) / 2.0, (this.getInitialAtomCogOffset(this.nitrogenAtom).getY() + this.getInitialAtomCogOffset(this.leftOxygenAtom).getY()) / 2.0);
            o.setCenterOfGravityPos(INITIAL_OXYGEN_HORIZONTAL_OFFSET, INITIAL_OXYGEN_VERTICAL_OFFSET);
        }
        nO.setVelocity(0.99 * Math.cos(d), 0.99 * Math.sin(d));
        o.setVelocity(-2.0100000000000002 * Math.cos(d), -2.0100000000000002 * Math.sin(d));
        this.addConstituentMolecule(nO);
        this.addConstituentMolecule(o);
        this.notifyBrokeApart();
    }
}

