/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.photonabsorption.model.atoms;

import edu.colorado.phet.common.phetcommon.util.SimpleObservable;
import java.awt.Color;
import java.awt.geom.Point2D;

public abstract class Atom
extends SimpleObservable {
    private final Point2D position;
    private final Color representationColor;
    private final double radius;
    private final double mass;

    public Atom(Color color, double d, double d2, Point2D point2D) {
        this.representationColor = color;
        this.radius = d;
        this.mass = d2;
        this.position = point2D;
    }

    public Point2D getPositionRef() {
        return this.position;
    }

    public void setPosition(double d, double d2) {
        if (this.position.getX() != d || this.position.getY() != d2) {
            this.position.setLocation(d, d2);
            this.notifyObservers();
        }
    }

    public Color getRepresentationColor() {
        return this.representationColor;
    }

    public double getRadius() {
        return this.radius;
    }

    public double getMass() {
        return this.mass;
    }
}

