/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.photonabsorption.model;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.photonabsorption.model.Molecule;
import edu.colorado.phet.common.photonabsorption.model.Photon;
import edu.colorado.phet.common.photonabsorption.model.molecules.CH4;
import edu.colorado.phet.common.photonabsorption.model.molecules.CO;
import edu.colorado.phet.common.photonabsorption.model.molecules.CO2;
import edu.colorado.phet.common.photonabsorption.model.molecules.H2O;
import edu.colorado.phet.common.photonabsorption.model.molecules.N2;
import edu.colorado.phet.common.photonabsorption.model.molecules.NO2;
import edu.colorado.phet.common.photonabsorption.model.molecules.O2;
import edu.colorado.phet.common.photonabsorption.model.molecules.O3;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhotonAbsorptionModel {
    private static final Point2D PHOTON_EMISSION_LOCATION = new Point2D.Double(-1400.0, 0.0);
    private static final Point2D SINGLE_MOLECULE_LOCATION = new Point2D.Double(0.0, 0.0);
    private static final Point2D CONTAINMENT_AREA_CENTER = new Point2D.Double(0.0, 0.0);
    private static final Rectangle2D CONTAINMENT_AREA_RECT = new Rectangle2D.Double(CONTAINMENT_AREA_CENTER.getX() - 1550.0, CONTAINMENT_AREA_CENTER.getY() - 1500.0, 3100.0, 3000.0);
    private static final PhotonTarget DEFAULT_PHOTON_TARGET = PhotonTarget.SINGLE_CH4_MOLECULE;
    private static final Map<Class<? extends Molecule>, Integer> MAX_ATMOSPHERE_CONCENTRATIONS = new HashMap<Class<? extends Molecule>, Integer>(){
        {
            this.put(N2.class, 15);
            this.put(O2.class, 15);
            this.put(CO2.class, 15);
            this.put(CH4.class, 15);
            this.put(H2O.class, 15);
        }
    };
    private static final Random RAND = new Random();
    private static final ArrayList<Point2D> GRID_POINTS = new ArrayList();
    private final EventListenerList listeners = new EventListenerList();
    private final ArrayList<Photon> photons = new ArrayList();
    private double photonWavelength = 5.8E-7;
    private final ArrayList<Molecule> activeMolecules = new ArrayList();
    private final PhotonTarget initialPhotonTarget;
    private PhotonTarget photonTarget = null;
    private double photonEmissionCountdownTimer = Double.POSITIVE_INFINITY;
    private double photonEmissionPeriodTarget = Double.POSITIVE_INFINITY;
    private double previousEmissionAngle = 0.0;
    private final ArrayList<Molecule> configurableAtmosphereMolecules = new ArrayList();
    private final Molecule.Adapter moleculePhotonEmissionListener = new Molecule.Adapter(){

        public void photonEmitted(Photon photon) {
            PhotonAbsorptionModel.this.photons.add(photon);
            PhotonAbsorptionModel.this.notifyPhotonAdded(photon);
        }

        public void brokeApart(Molecule molecule) {
            PhotonAbsorptionModel.this.removeOldTarget();
            ArrayList<Molecule> arrayList = molecule.getBreakApartConstituents();
            for (Molecule molecule2 : arrayList) {
                PhotonAbsorptionModel.this.activeMolecules.add(molecule2);
            }
            PhotonAbsorptionModel.this.finishAddingMolecules();
        }
    };

    private void finishAddingMolecules() {
        for (Molecule molecule : this.activeMolecules) {
            molecule.addListener(this.moleculePhotonEmissionListener);
            this.notifyMoleculeAdded(molecule);
        }
        this.notifyPhotonTargetChanged();
    }

    private void removeOldTarget() {
        ArrayList<Molecule> arrayList = new ArrayList<Molecule>(this.activeMolecules);
        this.activeMolecules.clear();
        for (Molecule molecule : arrayList) {
            this.notifyMoleculeRemoved(molecule);
        }
    }

    public PhotonAbsorptionModel(ConstantDtClock constantDtClock, PhotonTarget photonTarget) {
        this.initialPhotonTarget = photonTarget;
        constantDtClock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                PhotonAbsorptionModel.this.stepInTime(clockEvent.getSimulationTimeChange());
            }
        });
    }

    public void reset() {
        this.removeAllPhotons();
        for (Molecule molecule : this.activeMolecules) {
            molecule.reset();
        }
        this.setPhotonTarget(this.initialPhotonTarget);
        this.setEmittedPhotonWavelength(8.5E-7);
        this.setPhotonEmissionPeriod(Double.POSITIVE_INFINITY);
        this.resetConfigurableAtmosphere();
        this.notifyModelReset();
    }

    public void stepInTime(double d) {
        if (this.photonEmissionCountdownTimer != Double.POSITIVE_INFINITY) {
            this.photonEmissionCountdownTimer -= d;
            if (this.photonEmissionCountdownTimer <= 0.0) {
                this.emitPhoton();
                this.photonEmissionCountdownTimer = this.photonEmissionPeriodTarget;
            }
        }
        ArrayList<Photon> arrayList = new ArrayList<Photon>();
        for (Photon object : this.photons) {
            object.stepInTime(d);
            if (object.getLocation().getX() - PHOTON_EMISSION_LOCATION.getX() <= 4500.0) {
                for (Molecule molecule : this.activeMolecules) {
                    if (!molecule.queryAbsorbPhoton(object)) continue;
                    arrayList.add(object);
                }
                continue;
            }
            arrayList.add(object);
        }
        for (Photon photon : arrayList) {
            this.photons.remove(photon);
            this.notifyPhotonRemoved(photon);
        }
        for (Molecule molecule : new ArrayList<Molecule>(this.activeMolecules)) {
            molecule.stepInTime(d);
        }
    }

    public void setPhotonTarget(PhotonTarget photonTarget) {
        if (this.photonTarget != photonTarget) {
            if (photonTarget == PhotonTarget.CONFIGURABLE_ATMOSPHERE || this.photonTarget == PhotonTarget.CONFIGURABLE_ATMOSPHERE) {
                this.setPhotonEmissionPeriod(Double.POSITIVE_INFINITY);
                this.removeAllPhotons();
            }
            this.photonTarget = photonTarget;
            this.removeOldTarget();
            switch (photonTarget) {
                case SINGLE_CO_MOLECULE: {
                    CO cO = new CO(SINGLE_MOLECULE_LOCATION);
                    this.activeMolecules.add(cO);
                    break;
                }
                case SINGLE_CO2_MOLECULE: {
                    CO2 cO2 = new CO2(SINGLE_MOLECULE_LOCATION);
                    this.activeMolecules.add(cO2);
                    break;
                }
                case SINGLE_H2O_MOLECULE: {
                    H2O h2O = new H2O(SINGLE_MOLECULE_LOCATION);
                    this.activeMolecules.add(h2O);
                    break;
                }
                case SINGLE_CH4_MOLECULE: {
                    CH4 cH4 = new CH4(SINGLE_MOLECULE_LOCATION);
                    this.activeMolecules.add(cH4);
                    break;
                }
                case SINGLE_N2_MOLECULE: {
                    N2 n2 = new N2(SINGLE_MOLECULE_LOCATION);
                    this.activeMolecules.add(n2);
                    break;
                }
                case SINGLE_O2_MOLECULE: {
                    O2 o2 = new O2(SINGLE_MOLECULE_LOCATION);
                    this.activeMolecules.add(o2);
                    break;
                }
                case SINGLE_O3_MOLECULE: {
                    O3 o3 = new O3(SINGLE_MOLECULE_LOCATION);
                    this.activeMolecules.add(o3);
                    break;
                }
                case SINGLE_NO2_MOLECULE: {
                    NO2 nO2 = new NO2(SINGLE_MOLECULE_LOCATION);
                    this.activeMolecules.add(nO2);
                    break;
                }
                case CONFIGURABLE_ATMOSPHERE: {
                    this.activeMolecules.addAll(this.configurableAtmosphereMolecules);
                    break;
                }
                default: {
                    System.err.println(this.getClass().getName() + " - Error: Unhandled photon target.");
                }
            }
            this.finishAddingMolecules();
        }
    }

    public void restorePhotonTarget() {
        PhotonTarget photonTarget = this.photonTarget;
        this.photonTarget = null;
        this.setPhotonTarget(photonTarget);
    }

    private void removeAllPhotons() {
        ArrayList<Photon> arrayList = new ArrayList<Photon>(this.photons);
        this.photons.clear();
        for (Photon photon : arrayList) {
            this.photons.remove(photon);
            this.notifyPhotonRemoved(photon);
        }
    }

    public PhotonTarget getPhotonTarget() {
        return this.photonTarget;
    }

    public Point2D getPhotonEmissionLocation() {
        return PHOTON_EMISSION_LOCATION;
    }

    public ArrayList<Molecule> getMolecules() {
        return new ArrayList<Molecule>(this.activeMolecules);
    }

    public double getPhotonEmissionPeriod() {
        return this.photonEmissionPeriodTarget;
    }

    public void setPhotonEmissionPeriod(double d) {
        assert (d >= 0.0);
        if (this.photonEmissionPeriodTarget != d) {
            if (this.photonEmissionPeriodTarget == Double.POSITIVE_INFINITY && d != Double.POSITIVE_INFINITY) {
                this.photonEmissionCountdownTimer = 300.0;
            } else if (d < this.photonEmissionCountdownTimer) {
                this.photonEmissionCountdownTimer = d;
            } else if (d == Double.POSITIVE_INFINITY) {
                this.photonEmissionCountdownTimer = d;
            }
            this.photonEmissionPeriodTarget = d;
            this.notifyPhotonEmissionPeriodChanged();
        }
    }

    public void emitPhoton() {
        Photon photon = new Photon(this.photonWavelength);
        photon.setLocation(PHOTON_EMISSION_LOCATION.getX(), PHOTON_EMISSION_LOCATION.getY());
        double d = 0.0;
        if (this.photonTarget == PhotonTarget.CONFIGURABLE_ATMOSPHERE) {
            d = RAND.nextDouble() * 1.5707963267948966 / 2.0;
            if (this.previousEmissionAngle > 0.0) {
                d = -d;
            }
            this.previousEmissionAngle = d;
        }
        photon.setVelocity((float)(2.0 * Math.cos(d)), (float)(2.0 * Math.sin(d)));
        this.photons.add(photon);
        this.notifyPhotonAdded(photon);
    }

    public void setEmittedPhotonWavelength(double d) {
        if (this.photonWavelength != d) {
            this.photonWavelength = d;
            this.notifyEmittedPhotonWavelengthChanged();
        }
    }

    public double getEmittedPhotonWavelength() {
        return this.photonWavelength;
    }

    public void addListener(Listener listener) {
        this.listeners.add(Listener.class, listener);
    }

    private void resetConfigurableAtmosphere() {
        assert (this.photonTarget != PhotonTarget.CONFIGURABLE_ATMOSPHERE);
    }

    private void notifyPhotonAdded(Photon photon) {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.photonAdded(photon);
        }
    }

    private void notifyPhotonRemoved(Photon photon) {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.photonRemoved(photon);
        }
    }

    private void notifyMoleculeAdded(Molecule molecule) {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.moleculeAdded(molecule);
        }
    }

    private void notifyMoleculeRemoved(Molecule molecule) {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.moleculeRemoved(molecule);
        }
    }

    private void notifyEmittedPhotonWavelengthChanged() {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.emittedPhotonWavelengthChanged();
        }
    }

    private void notifyPhotonEmissionPeriodChanged() {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.photonEmissionPeriodChanged();
        }
    }

    private void notifyPhotonTargetChanged() {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.photonTargetChanged();
        }
    }

    private void notifyModelReset() {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.modelReset();
        }
    }

    static {
        int n = 8;
        double d = 3100.0 / (double)(n + 1);
        int n2 = 8;
        double d2 = 3100.0 / (double)(n2 + 1);
        for (int i = 1; i <= n; ++i) {
            for (int j = 1; j <= n2; ++j) {
                GRID_POINTS.add(new Point2D.Double((double)i * d + CONTAINMENT_AREA_RECT.getMinX(), (double)j * d2 + CONTAINMENT_AREA_RECT.getMinY()));
            }
        }
    }

    public static class Adapter
    implements Listener {
        public void photonAdded(Photon photon) {
        }

        public void emittedPhotonWavelengthChanged() {
        }

        public void photonRemoved(Photon photon) {
        }

        public void photonTargetChanged() {
        }

        public void moleculeAdded(Molecule molecule) {
        }

        public void moleculeRemoved(Molecule molecule) {
        }

        public void photonEmissionPeriodChanged() {
        }

        public void modelReset() {
        }
    }

    public static interface Listener
    extends EventListener {
        public void photonAdded(Photon var1);

        public void photonRemoved(Photon var1);

        public void moleculeAdded(Molecule var1);

        public void moleculeRemoved(Molecule var1);

        public void emittedPhotonWavelengthChanged();

        public void photonTargetChanged();

        public void photonEmissionPeriodChanged();

        public void modelReset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PhotonTarget
    extends Enum<PhotonTarget> {
        public static final /* enum */ PhotonTarget SINGLE_CO_MOLECULE = new PhotonTarget();
        public static final /* enum */ PhotonTarget SINGLE_CO2_MOLECULE = new PhotonTarget();
        public static final /* enum */ PhotonTarget SINGLE_H2O_MOLECULE = new PhotonTarget();
        public static final /* enum */ PhotonTarget SINGLE_CH4_MOLECULE = new PhotonTarget();
        public static final /* enum */ PhotonTarget SINGLE_N2O_MOLECULE = new PhotonTarget();
        public static final /* enum */ PhotonTarget SINGLE_N2_MOLECULE = new PhotonTarget();
        public static final /* enum */ PhotonTarget SINGLE_NO2_MOLECULE = new PhotonTarget();
        public static final /* enum */ PhotonTarget SINGLE_O2_MOLECULE = new PhotonTarget();
        public static final /* enum */ PhotonTarget SINGLE_O3_MOLECULE = new PhotonTarget();
        public static final /* enum */ PhotonTarget CONFIGURABLE_ATMOSPHERE = new PhotonTarget();
        private static final /* synthetic */ PhotonTarget[] $VALUES;

        public static PhotonTarget[] values() {
            return (PhotonTarget[])$VALUES.clone();
        }

        static {
            $VALUES = new PhotonTarget[]{SINGLE_CO_MOLECULE, SINGLE_CO2_MOLECULE, SINGLE_H2O_MOLECULE, SINGLE_CH4_MOLECULE, SINGLE_N2O_MOLECULE, SINGLE_N2_MOLECULE, SINGLE_NO2_MOLECULE, SINGLE_O2_MOLECULE, SINGLE_O3_MOLECULE, CONFIGURABLE_ATMOSPHERE};
        }
    }
}

