/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.util;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public abstract class SpectrumImageFactory {
    private static final Color DEFAULT_UV_COLOR = VisibleColor.COLOR_INVISIBLE;
    private static final Color DEFAULT_IR_COLOR = VisibleColor.COLOR_INVISIBLE;

    private SpectrumImageFactory() {
    }

    protected abstract Function getWavelengthFunction(int var1, double var2, double var4);

    public Image createHorizontalSpectrum(int n, int n2) {
        return this.createHorizontalSpectrum(n, n2, 380.0, 780.0);
    }

    public Image createHorizontalSpectrum(int n, int n2, double d, double d2) {
        return this.createHorizontalSpectrum(n, n2, d, d2, DEFAULT_UV_COLOR, DEFAULT_IR_COLOR);
    }

    public Image createHorizontalSpectrum(int n, int n2, double d, double d2, Color color, Color color2) {
        return this.createSpectrum(n, n2, 0, d, d2, color, color2);
    }

    public Image createSpectrum(int n, int n2, int n3, double d, double d2, Color color, Color color2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("width and height must both be > 0");
        }
        if (d >= d2) {
            throw new IllegalArgumentException("minWavelength must be < maxWavelength");
        }
        if (n3 != 0 && n3 != 1) {
            throw new IllegalArgumentException("invalid orientation");
        }
        if (color == null || color2 == null) {
            throw new NullPointerException("uvColor or irColor is null");
        }
        int n4 = n3 == 0 ? n : n2;
        Function function = this.getWavelengthFunction(n4, d, d2);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        for (int i = 0; i < n4; ++i) {
            double d3 = function.evaluate(i);
            Color color3 = null;
            color3 = d3 < 380.0 ? color : (d3 > 780.0 ? color2 : VisibleColor.wavelengthToColor(d3));
            graphics2D.setColor(color3);
            if (n3 == 0) {
                graphics2D.fillRect(i, 0, 1, n2);
                continue;
            }
            graphics2D.fillRect(0, n2 - i, n, 1);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    public static class ExponentialGrowthSpectrumImageFactory
    extends SpectrumImageFactory {
        protected Function getWavelengthFunction(int n, double d, double d2) {
            double d3 = Math.pow(d2 / d, 1.0 / (double)(n - 1));
            return new Function.ExponentialGrowthFunction(d3, d);
        }
    }
}

