/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.opengl.AbstractDrawable;
import org.lwjgl.opengl.Context;
import org.lwjgl.opengl.ContextAttribs;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.DrawableLWJGL;
import org.lwjgl.opengl.PeerInfo;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.RenderTexture;

public final class Pbuffer
extends AbstractDrawable {
    private final int width;
    private final int height;

    public Pbuffer(int width, int height, PixelFormat pixel_format, Drawable shared_drawable) throws LWJGLException {
        this(width, height, pixel_format, null, shared_drawable);
    }

    public Pbuffer(int width, int height, PixelFormat pixel_format, RenderTexture renderTexture, Drawable shared_drawable) throws LWJGLException {
        this(width, height, pixel_format, renderTexture, shared_drawable, null);
    }

    public Pbuffer(int width, int height, PixelFormat pixel_format, RenderTexture renderTexture, Drawable shared_drawable, ContextAttribs attribs) throws LWJGLException {
        if (pixel_format == null) {
            throw new NullPointerException("Pixel format must be non-null");
        }
        this.width = width;
        this.height = height;
        this.peer_info = Pbuffer.createPbuffer(width, height, pixel_format, renderTexture);
        Context shared_context = shared_drawable != null ? ((DrawableLWJGL)shared_drawable).getContext() : ((DrawableLWJGL)Display.getDrawable()).getContext();
        this.context = new Context(this.peer_info, attribs, shared_context);
    }

    private static PeerInfo createPbuffer(int width, int height, PixelFormat pixel_format, RenderTexture renderTexture) throws LWJGLException {
        if (renderTexture == null) {
            IntBuffer defaultAttribs = BufferUtils.createIntBuffer(1);
            return Display.getImplementation().createPbuffer(width, height, pixel_format, null, defaultAttribs);
        }
        return Display.getImplementation().createPbuffer(width, height, pixel_format, renderTexture.pixelFormatCaps, renderTexture.pBufferAttribs);
    }

    static {
        Sys.initialize();
    }
}

