/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.ContextAttribsImplementation;
import org.lwjgl.opengl.LinuxContextAttribs;
import org.lwjgl.opengl.MacOSXContextAttribs;
import org.lwjgl.opengl.WindowsContextAttribs;

public final class ContextAttribs {
    private int majorVersion;
    private int minorVersion;
    private int layerPlane;
    private boolean debug;
    private boolean forwardCompatible;
    private boolean robustAccess;
    private boolean profileCore;
    private boolean profileCompatibility;
    private boolean profileES;
    private boolean loseContextOnReset;

    public boolean isForwardCompatible() {
        return this.forwardCompatible;
    }

    private static ContextAttribsImplementation getImplementation() {
        switch (LWJGLUtil.getPlatform()) {
            case 1: {
                return new LinuxContextAttribs();
            }
            case 3: {
                return new WindowsContextAttribs();
            }
            case 2: {
                return new MacOSXContextAttribs();
            }
        }
        throw new IllegalStateException("Unsupported platform");
    }

    IntBuffer getAttribList() {
        ContextAttribsImplementation implementation = ContextAttribs.getImplementation();
        int attribCount = 0;
        if (this.majorVersion != 1 || this.minorVersion != 0) {
            attribCount += 2;
        }
        if (0 < this.layerPlane) {
            ++attribCount;
        }
        int flags = 0;
        if (this.debug) {
            flags |= implementation.getDebugBit();
        }
        if (this.forwardCompatible) {
            flags |= implementation.getForwardCompatibleBit();
        }
        if (this.robustAccess) {
            flags |= 4;
        }
        if (0 < flags) {
            ++attribCount;
        }
        int profileMask = 0;
        if (this.profileCore) {
            profileMask |= implementation.getProfileCoreBit();
        } else if (this.profileCompatibility) {
            profileMask |= implementation.getProfileCompatibilityBit();
        } else if (this.profileES) {
            profileMask |= 4;
        }
        if (0 < profileMask) {
            ++attribCount;
        }
        if (attribCount == 0) {
            return null;
        }
        IntBuffer attribs = BufferUtils.createIntBuffer(attribCount * 2 + 1);
        if (this.majorVersion != 1 || this.minorVersion != 0) {
            attribs.put(implementation.getMajorVersionAttrib()).put(this.majorVersion);
            attribs.put(implementation.getMinorVersionAttrib()).put(this.minorVersion);
        }
        if (0 < this.layerPlane) {
            attribs.put(implementation.getLayerPlaneAttrib()).put(this.layerPlane);
        }
        if (0 < flags) {
            attribs.put(implementation.getFlagsAttrib()).put(flags);
        }
        if (0 < profileMask) {
            attribs.put(implementation.getProfileMaskAttrib()).put(profileMask);
        }
        if (this.loseContextOnReset) {
            attribs.put(33366).put(33362);
        }
        attribs.put(0);
        attribs.rewind();
        return attribs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("ContextAttribs:");
        sb.append(" Version=").append(this.majorVersion).append('.').append(this.minorVersion);
        sb.append(" - Layer=").append(this.layerPlane);
        sb.append(" - Debug=").append(this.debug);
        sb.append(" - ForwardCompatible=").append(this.forwardCompatible);
        sb.append(" - RobustAccess=").append(this.robustAccess);
        if (this.robustAccess) {
            sb.append(" (").append(this.loseContextOnReset ? "LOSE_CONTEXT_ON_RESET" : "NO_RESET_NOTIFICATION");
        }
        sb.append(" - Profile=");
        if (this.profileCore) {
            sb.append("Core");
        } else if (this.profileCompatibility) {
            sb.append("Compatibility");
        } else {
            sb.append("None");
        }
        return sb.toString();
    }
}

