/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculeshapes.dev;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.model.property.SettableProperty;
import edu.colorado.phet.common.phetcommon.view.controls.PropertyCheckBoxMenuItem;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.lwjglphet.utils.LWJGLUtils;
import edu.colorado.phet.moleculeshapes.MoleculeShapesColor;
import edu.colorado.phet.moleculeshapes.MoleculeShapesProperties;
import edu.colorado.phet.moleculeshapes.dev.PerformanceFrame;
import edu.colorado.phet.moleculeshapes.util.ColorPropertyControl;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class DeveloperOptions {
    public static void addDeveloperOptions(JMenu jMenu, final JFrame jFrame) {
        jMenu.add(new JSeparator());
        jMenu.add(new PropertyCheckBoxMenuItem("Allow drag movement behind the molecule center", MoleculeShapesProperties.allowDraggingBehind));
        jMenu.add(new PropertyCheckBoxMenuItem("\"Move\" mouse cursor on rotation", MoleculeShapesProperties.useRotationCursor));
        jMenu.add(new PropertyCheckBoxMenuItem("Disable \"Show Bond Angles\" checkbox with less than 2 bonds", MoleculeShapesProperties.disableNAShowBondAngles));
        jMenu.add(new JSeparator());
        jMenu.add(new PropertyCheckBoxMenuItem("Show FPS", (SettableProperty<Boolean>)new Property<Boolean>(Boolean.valueOf(false)){}));
        jMenu.add(new JSeparator());
        jMenu.add(new JMenuItem("Color Options"){
            {
                super(string);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        new JDialog(jFrame){
                            {
                                this.setTitle("Color Options");
                                this.setResizable(false);
                                this.setContentPane(new JPanel(){
                                    {
                                        this.setLayout(new BoxLayout(this, 1));
                                        this.add(new ColorPropertyControl((Frame)jFrame, "Background: ", MoleculeShapesColor.BACKGROUND.getProperty()));
                                        this.add(new ColorPropertyControl((Frame)jFrame, "Control panel borders: ", MoleculeShapesColor.CONTROL_PANEL_BORDER.getProperty()));
                                        this.add(new ColorPropertyControl((Frame)jFrame, "Control panel titles: ", MoleculeShapesColor.CONTROL_PANEL_TITLE.getProperty()));
                                        this.add(new ColorPropertyControl((Frame)jFrame, "Central atom: ", MoleculeShapesColor.ATOM_CENTER.getProperty()));
                                        this.add(new ColorPropertyControl((Frame)jFrame, "Radial atom: ", MoleculeShapesColor.ATOM.getProperty()));
                                        this.add(new ColorPropertyControl((Frame)jFrame, "Bonds: ", MoleculeShapesColor.BOND.getProperty()));
                                        this.add(new ColorPropertyControl((Frame)jFrame, "Remove all foreground: ", MoleculeShapesColor.REMOVE_BUTTON_TEXT.getProperty()));
                                        this.add(new ColorPropertyControl((Frame)jFrame, "Remove all background: ", MoleculeShapesColor.REMOVE_BUTTON_BACKGROUND.getProperty()));
                                        this.add(new ColorPropertyControl((Frame)jFrame, "Molecular geometry: ", MoleculeShapesColor.MOLECULAR_GEOMETRY_NAME.getProperty()));
                                        this.add(new ColorPropertyControl((Frame)jFrame, "Electron geometry: ", MoleculeShapesColor.ELECTRON_GEOMETRY_NAME.getProperty()));
                                        this.add(new ColorPropertyControl((Frame)jFrame, "Bond angle readout: ", MoleculeShapesColor.BOND_ANGLE_READOUT.getProperty()));
                                        this.add(new ColorPropertyControl((Frame)jFrame, "Bond angle sweep: ", MoleculeShapesColor.BOND_ANGLE_SWEEP.getProperty()));
                                        this.add(new ColorPropertyControl((Frame)jFrame, "Bond angle arc: ", MoleculeShapesColor.BOND_ANGLE_ARC.getProperty()));
                                        this.add(new ColorPropertyControl((Frame)jFrame, "Real example formula: ", MoleculeShapesColor.REAL_EXAMPLE_FORMULA.getProperty()));
                                        this.add(new ColorPropertyControl((Frame)jFrame, "Real example border: ", MoleculeShapesColor.REAL_EXAMPLE_BORDER.getProperty()));
                                        this.add(new ColorPropertyControl((Frame)jFrame, "Light 1 color: ", MoleculeShapesColor.SUN.getProperty()));
                                        this.add(new ColorPropertyControl((Frame)jFrame, "Light 2 color: ", MoleculeShapesColor.MOON.getProperty()));
                                    }
                                });
                                this.pack();
                                SwingUtils.centerInParent(this);
                            }
                        }.setVisible(true);
                    }
                });
            }
        });
        jMenu.add(new JMenuItem("Performance Options"){
            {
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        new PerformanceFrame();
                    }
                });
            }
        });
        jMenu.add(new JMenuItem("Show Error Dialog"){
            {
                super(string);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        LWJGLUtils.showErrorDialog(jFrame, new RuntimeException("This is a test"));
                    }
                });
            }
        });
        jMenu.add(new JMenuItem("Show Mac Java 1.7 Dialog"){
            {
                super(string);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        LWJGLUtils.showMacJava7Warning(jFrame);
                    }
                });
            }
        });
    }
}

