/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculeshapes.control;

import edu.colorado.phet.common.phetcommon.model.event.UpdateListener;
import edu.colorado.phet.common.phetcommon.model.property.ChangeObserver;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.piccolophet.nodes.Spacer;
import edu.colorado.phet.lwjglphet.utils.LWJGLUtils;
import edu.colorado.phet.moleculeshapes.MoleculeShapesProperties;
import edu.colorado.phet.moleculeshapes.MoleculeShapesResources;
import edu.colorado.phet.moleculeshapes.MoleculeShapesSimSharing;
import edu.colorado.phet.moleculeshapes.control.PropertyCheckBoxNode;
import edu.colorado.phet.moleculeshapes.model.Molecule;
import edu.colorado.phet.moleculeshapes.tabs.MoleculeViewTab;
import edu.umd.cs.piccolo.PNode;

public class OptionsNode
extends PNode {
    public OptionsNode(final MoleculeViewTab moleculeViewTab, double d) {
        this.addChild(new Spacer(0.0, 0.0, d, 10.0));
        final Property<Double> property = new Property<Double>(0.0);
        PNode pNode = new PNode();
        PropertyCheckBoxNode propertyCheckBoxNode = new PropertyCheckBoxNode(MoleculeShapesSimSharing.UserComponents.showLonePairsCheckBox, MoleculeShapesResources.Strings.CONTROL__SHOW_LONE_PAIRS, moleculeViewTab.showLonePairs){
            {
                super(iUserComponent, string, property);
                final Runnable runnable = new Runnable(){

                    public void run() {
                        this.setEnabled(!moleculeViewTab.getMolecule().getRadialLonePairs().isEmpty());
                    }
                };
                final UpdateListener updateListener = LWJGLUtils.swingUpdateListener(runnable);
                moleculeViewTab.getMolecule().onBondChanged.addUpdateListener(updateListener, false);
                moleculeViewTab.getMoleculeProperty().addObserver(new ChangeObserver<Molecule>(){

                    @Override
                    public void update(Molecule molecule, Molecule molecule2) {
                        molecule2.onBondChanged.removeListener(updateListener);
                        molecule.onBondChanged.addUpdateListener(updateListener, false);
                        runnable.run();
                    }
                });
                runnable.run();
            }
        };
        if (moleculeViewTab.allowTogglingLonePairs()) {
            pNode.addChild(propertyCheckBoxNode);
            property.set(propertyCheckBoxNode.getFullBounds().getMaxY());
        }
        PropertyCheckBoxNode propertyCheckBoxNode2 = new PropertyCheckBoxNode(MoleculeShapesSimSharing.UserComponents.showAllLonePairsCheckBox, MoleculeShapesResources.Strings.CONTROL__SHOW_ALL_LONE_PAIRS, moleculeViewTab.showAllLonePairs){
            {
                super(iUserComponent, string, property3);
                final Runnable runnable = new Runnable(){

                    public void run() {
                        this.setEnabled(moleculeViewTab.showLonePairs.get() != false && !moleculeViewTab.getMolecule().getDistantLonePairs().isEmpty());
                    }
                };
                final UpdateListener updateListener = LWJGLUtils.swingUpdateListener(runnable);
                moleculeViewTab.getMolecule().onBondChanged.addUpdateListener(updateListener, false);
                moleculeViewTab.showLonePairs.addObserver(updateListener, false);
                moleculeViewTab.getMoleculeProperty().addObserver(new ChangeObserver<Molecule>(){

                    @Override
                    public void update(Molecule molecule, Molecule molecule2) {
                        molecule2.onBondChanged.removeListener(updateListener);
                        molecule.onBondChanged.addUpdateListener(updateListener, false);
                        runnable.run();
                    }
                });
                runnable.run();
                this.setOffset(0.0, (Double)property.get());
            }
        };
        if (moleculeViewTab.allowTogglingAllLonePairs()) {
            pNode.addChild(propertyCheckBoxNode2);
            property.set(propertyCheckBoxNode2.getFullBounds().getMaxY());
        }
        pNode.addChild(new PropertyCheckBoxNode(MoleculeShapesSimSharing.UserComponents.showBondAnglesCheckBox, MoleculeShapesResources.Strings.CONTROL__SHOW_BOND_ANGLES, moleculeViewTab.showBondAngles){
            {
                super(iUserComponent, string, property3);
                Runnable runnable = new Runnable(){

                    public void run() {
                        this.setEnabled(MoleculeShapesProperties.disableNAShowBondAngles.get() == false || moleculeViewTab.getMolecule().getRadialAtoms().size() >= 2);
                    }
                };
                moleculeViewTab.getMolecule().onBondChanged.addUpdateListener(LWJGLUtils.swingUpdateListener(runnable), false);
                MoleculeShapesProperties.disableNAShowBondAngles.addObserver(LWJGLUtils.swingObserver(runnable));
                this.setOffset(0.0, (Double)property.get());
            }
        });
        pNode.setOffset((d - pNode.getFullBounds().getWidth()) / 2.0, 0.0);
        this.addChild(pNode);
    }
}

