/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculeshapes.control;

import edu.colorado.phet.common.phetcommon.model.property.ChangeObserver;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.piccolophet.nodes.Spacer;
import edu.colorado.phet.moleculeshapes.MoleculeShapesColor;
import edu.colorado.phet.moleculeshapes.MoleculeShapesConstants;
import edu.colorado.phet.moleculeshapes.MoleculeShapesResources;
import edu.colorado.phet.moleculeshapes.MoleculeShapesSimSharing;
import edu.colorado.phet.moleculeshapes.control.PropertyCheckBoxNode;
import edu.colorado.phet.moleculeshapes.model.Bond;
import edu.colorado.phet.moleculeshapes.model.Molecule;
import edu.colorado.phet.moleculeshapes.model.PairGroup;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Paint;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeometryNameNode
extends PNode {
    private static final List<String> GEOMETRY_STRINGS = Arrays.asList(MoleculeShapesResources.Strings.GEOMETRY__EMPTY, MoleculeShapesResources.Strings.GEOMETRY__DIATOMIC, MoleculeShapesResources.Strings.GEOMETRY__LINEAR, MoleculeShapesResources.Strings.GEOMETRY__OCTAHEDRAL, MoleculeShapesResources.Strings.GEOMETRY__TETRAHEDRAL, MoleculeShapesResources.Strings.GEOMETRY__TRIGONAL_BIPYRAMIDAL, MoleculeShapesResources.Strings.GEOMETRY__TRIGONAL_PLANAR);
    private static final List<String> SHAPE_STRINGS = Arrays.asList(MoleculeShapesResources.Strings.SHAPE__BENT, MoleculeShapesResources.Strings.SHAPE__DIATOMIC, MoleculeShapesResources.Strings.SHAPE__EMPTY, MoleculeShapesResources.Strings.SHAPE__LINEAR, MoleculeShapesResources.Strings.SHAPE__OCTAHEDRAL, MoleculeShapesResources.Strings.SHAPE__SEESAW, MoleculeShapesResources.Strings.SHAPE__SQUARE_PLANAR, MoleculeShapesResources.Strings.SHAPE__SQUARE_PYRAMIDAL, MoleculeShapesResources.Strings.SHAPE__T_SHAPED, MoleculeShapesResources.Strings.SHAPE__TETRAHEDRAL, MoleculeShapesResources.Strings.SHAPE__TRIGONAL_BIPYRAMIDAL, MoleculeShapesResources.Strings.SHAPE__TRIGONAL_PLANAR, MoleculeShapesResources.Strings.SHAPE__TRIGONAL_PYRAMIDAL);
    private static final double MAX_GEOMETRY_WIDTH = GeometryNameNode.getMaximumTextWidth(GEOMETRY_STRINGS);
    private static final double MAX_SHAPE_WIDTH = GeometryNameNode.getMaximumTextWidth(SHAPE_STRINGS);
    private static final double MAX_TEXT_HEIGHT = Math.max(GeometryNameNode.getMaximumTextHeight(GEOMETRY_STRINGS), GeometryNameNode.getMaximumTextHeight(SHAPE_STRINGS));
    public final Property<Boolean> showMolecularShapeName = new Property<Boolean>(false);
    public final Property<Boolean> showElectronShapeName = new Property<Boolean>(false);
    private PText molecularText;
    private PText electronText;
    private double readoutHeight;
    private final Property<Molecule> molecule;
    private final boolean showElectronGeometry;

    public GeometryNameNode(Property<Molecule> property, boolean bl) {
        this.molecule = property;
        this.showElectronGeometry = bl;
        PropertyCheckBoxNode propertyCheckBoxNode = new PropertyCheckBoxNode(MoleculeShapesSimSharing.UserComponents.moleculeGeometryCheckBox, MoleculeShapesResources.Strings.CONTROL__MOLECULE_GEOMETRY, this.showMolecularShapeName, MoleculeShapesColor.MOLECULAR_GEOMETRY_NAME){
            {
                this.setOffset((MAX_SHAPE_WIDTH - this.getFullBounds().getWidth()) / 2.0, 0.0);
            }
        };
        PropertyCheckBoxNode propertyCheckBoxNode2 = new PropertyCheckBoxNode(MoleculeShapesSimSharing.UserComponents.electronGeometryCheckBox, MoleculeShapesResources.Strings.CONTROL__ELECTRON_GEOMETRY, this.showElectronShapeName, MoleculeShapesColor.ELECTRON_GEOMETRY_NAME){
            {
                this.setOffset(MAX_SHAPE_WIDTH + 15.0 + (MAX_GEOMETRY_WIDTH - this.getFullBounds().getWidth()) / 2.0, 0.0);
            }
        };
        this.readoutHeight = Math.max(propertyCheckBoxNode.getFullBounds().getHeight(), propertyCheckBoxNode2.getFullBounds().getHeight()) + 0.0;
        Spacer spacer = new Spacer(0.0, 0.0, MAX_GEOMETRY_WIDTH + (bl ? MAX_SHAPE_WIDTH + 15.0 : 0.0), this.readoutHeight + MAX_TEXT_HEIGHT);
        this.addChild(spacer);
        this.addChild(propertyCheckBoxNode);
        if (bl) {
            this.addChild(propertyCheckBoxNode2);
        }
        this.showMolecularShapeName.addObserver(new SimpleObserver(){

            public void update() {
                GeometryNameNode.this.updateMolecularText(true);
            }
        }, false);
        this.updateMolecularText(false);
        this.showElectronShapeName.addObserver(new SimpleObserver(){

            public void update() {
                GeometryNameNode.this.updateElectronText(false);
            }
        }, false);
        this.updateElectronText(true);
        final VoidFunction1<Bond<PairGroup>> voidFunction1 = new VoidFunction1<Bond<PairGroup>>(){

            @Override
            public void apply(Bond<PairGroup> bond) {
                GeometryNameNode.this.updateMolecularText(true);
                GeometryNameNode.this.updateElectronText(true);
            }
        };
        ChangeObserver<Molecule> changeObserver = new ChangeObserver<Molecule>(){

            @Override
            public void update(Molecule molecule, Molecule molecule2) {
                if (molecule2 != null) {
                    molecule2.onBondChanged.removeListener(voidFunction1);
                }
                molecule.onBondChanged.addListener(voidFunction1);
                GeometryNameNode.this.updateMolecularText(true);
                GeometryNameNode.this.updateElectronText(true);
            }
        };
        property.addObserver(changeObserver);
        changeObserver.update(property.get(), null);
    }

    private void updateMolecularText(boolean bl) {
        final String string = this.molecule.get().getCentralVseprConfiguration().name;
        final boolean bl2 = this.showMolecularShapeName.get();
        Runnable runnable = new Runnable(){

            public void run() {
                if (GeometryNameNode.this.molecularText != null) {
                    GeometryNameNode.this.removeChild(GeometryNameNode.this.molecularText);
                }
                GeometryNameNode.this.molecularText = GeometryNameNode.getTextLabel(string == null ? MoleculeShapesResources.Strings.SHAPE__EMPTY : string, MoleculeShapesColor.MOLECULAR_GEOMETRY_NAME.getProperty());
                GeometryNameNode.this.molecularText.setOffset((MAX_SHAPE_WIDTH - GeometryNameNode.this.molecularText.getFullBounds().getWidth()) / 2.0, GeometryNameNode.this.readoutHeight);
                GeometryNameNode.this.molecularText.setVisible(bl2);
                GeometryNameNode.this.addChild(GeometryNameNode.this.molecularText);
            }
        };
        if (bl) {
            SwingUtilities.invokeLater(runnable);
        } else {
            runnable.run();
        }
    }

    private void updateElectronText(boolean bl) {
        if (!this.showElectronGeometry) {
            return;
        }
        final String string = this.molecule.get().getCentralVseprConfiguration().geometry.name;
        final boolean bl2 = this.showElectronShapeName.get();
        Runnable runnable = new Runnable(){

            public void run() {
                if (GeometryNameNode.this.electronText != null) {
                    GeometryNameNode.this.removeChild(GeometryNameNode.this.electronText);
                }
                double d = MAX_SHAPE_WIDTH + 15.0;
                GeometryNameNode.this.electronText = GeometryNameNode.getTextLabel(string == null ? MoleculeShapesResources.Strings.GEOMETRY__EMPTY : string, MoleculeShapesColor.ELECTRON_GEOMETRY_NAME.getProperty());
                GeometryNameNode.this.electronText.setOffset(d + (MAX_SHAPE_WIDTH - GeometryNameNode.this.electronText.getFullBounds().getWidth()) / 2.0, GeometryNameNode.this.readoutHeight);
                GeometryNameNode.this.electronText.setVisible(bl2);
                GeometryNameNode.this.addChild(GeometryNameNode.this.electronText);
            }
        };
        if (bl) {
            SwingUtilities.invokeLater(runnable);
        } else {
            runnable.run();
        }
    }

    private static PText getTextLabel(String string, final Property<Color> property) {
        return new PText(string){
            {
                super(string);
                this.setFont(MoleculeShapesConstants.GEOMETRY_NAME_FONT);
                property.addObserver(new SimpleObserver(){

                    public void update() {
                        this.setTextPaint((Paint)property.get());
                    }
                });
            }
        };
    }

    private static double getMaximumTextWidth(List<String> list) {
        double d = 0.0;
        for (String string : list) {
            d = Math.max(d, GeometryNameNode.getTextLabel(string, new Property<Color>(Color.WHITE)).getFullBounds().getWidth());
        }
        return d;
    }

    private static double getMaximumTextHeight(List<String> list) {
        double d = 0.0;
        for (String string : list) {
            d = Math.max(d, GeometryNameNode.getTextLabel(string, new Property<Color>(Color.WHITE)).getFullBounds().getHeight());
        }
        return d;
    }
}

