/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.util;

import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.common.phetcommon.util.Pair;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionalUtils {
    public static <T> T firstOrNull(Collection<T> collection, Function1<? super T, Boolean> function1) {
        return FunctionalUtils.first(collection, function1).getOrElse(null);
    }

    public static <T> Option<T> first(Collection<T> collection, Function1<? super T, Boolean> function1) {
        for (T t : collection) {
            if (!function1.apply(t).booleanValue()) continue;
            return new Option.Some<T>(t);
        }
        return new Option.None();
    }

    public static <T> int count(Collection<T> collection, Function1<? super T, Boolean> function1) {
        int n = 0;
        for (T t : collection) {
            if (!function1.apply(t).booleanValue()) continue;
            ++n;
        }
        return n;
    }

    public static <T> List<T> filter(Collection<T> collection, Function1<? super T, Boolean> function1) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t : collection) {
            if (!function1.apply(t).booleanValue()) continue;
            arrayList.add(t);
        }
        return arrayList;
    }

    public static <T> Pair<List<T>, List<T>> partition(Collection<T> collection, Function1<? super T, Boolean> function1) {
        ArrayList<T> arrayList = new ArrayList<T>();
        ArrayList<T> arrayList2 = new ArrayList<T>();
        for (T t : collection) {
            if (function1.apply(t).booleanValue()) {
                arrayList.add(t);
                continue;
            }
            arrayList2.add(t);
        }
        return new Pair<List<T>, List<T>>(arrayList, arrayList2);
    }

    public static <T> String mkString(Collection<T> collection, Function1<? super T, String> function1, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (T t : collection) {
            if (!bl) {
                stringBuilder.append(string);
            }
            bl = false;
            stringBuilder.append(function1.apply(t));
        }
        return stringBuilder.toString();
    }

    public static <T> String mkString(Collection<T> collection, String string) {
        return FunctionalUtils.mkString(collection, new Function1<T, String>(){

            @Override
            public String apply(T t) {
                return t.toString();
            }
        }, string);
    }

    public static <T, U> List<U> map(Collection<T> collection, Function1<? super T, ? extends U> function1) {
        ArrayList<U> arrayList = new ArrayList<U>();
        for (T t : collection) {
            arrayList.add(function1.apply(t));
        }
        return arrayList;
    }

    public static <T> List<T> unique(Collection<T> collection) {
        HashSet<T> hashSet = new HashSet<T>();
        for (T t : collection) {
            hashSet.add(t);
        }
        return new ArrayList(hashSet);
    }

    public static List<Integer> rangeInclusive(int n, int n2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n2 - n + 1);
        for (int i = n; i <= n2; ++i) {
            arrayList.add(i);
        }
        return arrayList;
    }

    public static <T> List<T> subtract(Collection<T> collection, final Collection<? extends T> collection2) {
        return FunctionalUtils.filter(collection, new Function1<T, Boolean>(){

            @Override
            public Boolean apply(T t) {
                return !collection2.contains(t);
            }
        });
    }

    public static <T> List<Pair<T, T>> pairs(Collection<T> collection) {
        List<Object> list = collection instanceof List ? (List<Object>)collection : new ArrayList<T>(collection);
        ArrayList<Pair<T, T>> arrayList = new ArrayList<Pair<T, T>>();
        int n = collection.size();
        for (int i = 0; i < n - 1; ++i) {
            Object e = list.get(i);
            for (int j = i + 1; j < n; ++j) {
                arrayList.add(new Pair(e, list.get(j)));
            }
        }
        return arrayList;
    }
}

