/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math;

import edu.colorado.phet.common.phetcommon.math.Ray3F;

public class Bounds3F {
    private final float x;
    private final float y;
    private final float z;
    private final float width;
    private final float height;
    private final float depth;

    public Bounds3F(float f, float f2, float f3, float f4, float f5, float f6) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.width = f4;
        this.height = f5;
        this.depth = f6;
    }

    public static Bounds3F fromMinMax(float f, float f2, float f3, float f4, float f5, float f6) {
        return new Bounds3F(f, f3, f5, f2 - f, f4 - f3, f6 - f5);
    }

    public float getMinX() {
        return this.x;
    }

    public float getMinY() {
        return this.y;
    }

    public float getMinZ() {
        return this.z;
    }

    public float getMaxX() {
        return this.x + this.width;
    }

    public float getMaxY() {
        return this.y + this.height;
    }

    public float getMaxZ() {
        return this.z + this.depth;
    }

    public boolean intersectedBy(Ray3F ray3F) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7 = 1.0E-6f;
        float f8 = Float.POSITIVE_INFINITY;
        if (ray3F.dir.x >= 0.0f) {
            f6 = (this.getMinX() - ray3F.pos.x) / ray3F.dir.x;
            f5 = (this.getMaxX() - ray3F.pos.x) / ray3F.dir.x;
        } else {
            f6 = (this.getMaxX() - ray3F.pos.x) / ray3F.dir.x;
            f5 = (this.getMinX() - ray3F.pos.x) / ray3F.dir.x;
        }
        if (ray3F.dir.y >= 0.0f) {
            f4 = (this.getMinY() - ray3F.pos.y) / ray3F.dir.y;
            f3 = (this.getMaxY() - ray3F.pos.y) / ray3F.dir.y;
        } else {
            f4 = (this.getMaxY() - ray3F.pos.y) / ray3F.dir.y;
            f3 = (this.getMinY() - ray3F.pos.y) / ray3F.dir.y;
        }
        if (f6 > f3 || f4 > f5) {
            return false;
        }
        if (f4 > f6) {
            f6 = f4;
        }
        if (f3 < f5) {
            f5 = f3;
        }
        if (ray3F.dir.z >= 0.0f) {
            f2 = (this.getMinZ() - ray3F.pos.z) / ray3F.dir.z;
            f = (this.getMaxZ() - ray3F.pos.z) / ray3F.dir.z;
        } else {
            f2 = (this.getMaxZ() - ray3F.pos.z) / ray3F.dir.z;
            f = (this.getMinZ() - ray3F.pos.z) / ray3F.dir.z;
        }
        if (f6 > f || f2 > f5) {
            return false;
        }
        if (f2 > f6) {
            f6 = f2;
        }
        if (f < f5) {
            f5 = f;
        }
        return f6 < f8 && f5 > f7;
    }
}

