/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.microwaves.model;

import edu.colorado.phet.microwaves.coreadditions.Disk;
import edu.colorado.phet.microwaves.coreadditions.Vector2D;
import edu.colorado.phet.microwaves.model.Lobe;
import edu.colorado.phet.microwaves.model.PolarBody;
import java.awt.geom.Point2D;

public class WaterMolecule
extends PolarBody {
    private boolean isVisible;
    private Point2D.Double cm = new Point2D.Double();
    private Vector2D emf;
    private Lobe[] lobes = new Lobe[3];
    public static final double s_hydrogenAngleRad = Math.toRadians(104.0);
    public static double s_c = 7.0E-4;
    public static double s_b = 3.0E-4;

    public WaterMolecule() {
        Disk disk = new Disk(this.getLocation(), 20.0);
        disk.setMass(Math.PI * (2.0 * s_hydrogenAngleRad * s_hydrogenAngleRad + 400.0));
        super.addBody(disk);
        Disk disk2 = new Disk(new Point2D.Double(this.getLocation().getX() + 20.0 * Math.cos(s_hydrogenAngleRad / 2.0), this.getLocation().getY() + 20.0 * Math.sin(s_hydrogenAngleRad / 2.0)), 10.0);
        disk2.setMass(1.0);
        super.addBody(disk2);
        Disk disk3 = new Disk(new Point2D.Double(this.getLocation().getX() + 20.0 * Math.cos(s_hydrogenAngleRad / 2.0), this.getLocation().getY() + 20.0 * Math.sin(s_hydrogenAngleRad / 2.0)), 10.0);
        disk3.setMass(1.0);
        super.addBody(disk3);
        this.lobes[0] = new Lobe();
        this.lobes[0].setCenter(this.getLocation().getX(), this.getLocation().getY());
        this.lobes[0].setRadius(20.0);
        this.lobes[1] = new Lobe();
        this.lobes[1].setRadius(10.0);
        this.lobes[1].setCenter(this.getLocation().getX() + 20.0 * Math.cos(s_hydrogenAngleRad / 2.0), this.getLocation().getY() + 20.0 * Math.sin(s_hydrogenAngleRad / 2.0));
        this.lobes[2] = new Lobe();
        this.lobes[2].setRadius(10.0);
        this.lobes[2].setCenter(this.getLocation().getX() + 20.0 * Math.cos(-s_hydrogenAngleRad / 2.0), this.getLocation().getY() + 20.0 * Math.sin(-s_hydrogenAngleRad / 2.0));
        this.setDipoleOrientation(0.0);
    }

    public void respondToEmf(Vector2D vector2D, double d) {
        this.emf = vector2D;
    }

    public void stepInTime(double d) {
        double d2;
        double d3;
        double d4 = this.dipoleOrientation;
        double d5 = this.getOmega();
        double d6 = this.getAlpha();
        double d7 = 0.0;
        double d8 = 0.0;
        if (this.emf != null && this.emf.getLength() != 0.0f) {
            d3 = Math.atan2(this.emf.getY(), this.emf.getX());
            d8 = d3 - d4;
            d7 = this.emf.getLength();
        }
        d3 = s_c * Math.sin(d8) * d7 - s_b * d5;
        double d9 = (d4 + d5 * d + d3 * d * d / 2.0) % (Math.PI * 2);
        double d10 = d5 + d3 * d;
        if (this.emf != null && this.emf.getLength() != 0.0f) {
            d2 = Math.atan2(this.emf.getY(), this.emf.getX());
            d8 = d2 - d9;
            d7 = this.emf.getLength();
        }
        d2 = s_c * Math.sin(d8) * d7 - s_b * d10;
        double d11 = d5 + (d2 + d3) / 2.0 * d;
        this.setDipoleOrientation(d9);
        this.setOmega(d11);
        this.setAlpha(d2);
        super.stepInTime(d);
        this.updateLobes();
        this.setChanged();
        this.notifyObservers();
    }

    public void updateLobes() {
        this.lobes[0].setCenter(this.getLocation().getX(), this.getLocation().getY());
        double d = this.getLocation().getX() + 20.0 * Math.cos(this.dipoleOrientation + s_hydrogenAngleRad / 2.0);
        double d2 = this.getLocation().getY() + 20.0 * Math.sin(this.dipoleOrientation + s_hydrogenAngleRad / 2.0);
        this.lobes[1].setCenter(d, d2);
        d = this.getLocation().getX() + 20.0 * Math.cos(this.dipoleOrientation - s_hydrogenAngleRad / 2.0);
        d2 = this.getLocation().getY() + 20.0 * Math.sin(this.dipoleOrientation - s_hydrogenAngleRad / 2.0);
        this.lobes[2].setCenter(d, d2);
        super.setDipoleOrientation(this.dipoleOrientation);
    }

    public void setLocation(double d, double d2) {
        double d3 = d - this.getLocation().getX();
        double d4 = d2 - this.getLocation().getY();
        for (int i = 0; i < this.lobes.length; ++i) {
            this.lobes[i].setCenter(this.lobes[i].getCenterX() + d3, this.lobes[i].getCenterY() + d4);
        }
        super.setLocation(d, d2);
    }

    public Lobe[] getLobes() {
        return this.lobes;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    public static double getWidth() {
        return 40.0;
    }

    public double getMomentOfInertia() {
        return super.getMomentOfInertia();
    }

    public static double getHeight() {
        return 40.0;
    }
}

