/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.microwaves.model;

import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.microwaves.coreadditions.Vector2D;
import edu.colorado.phet.microwaves.coreadditions.collision.Box2D;
import edu.colorado.phet.microwaves.model.Microwave;
import edu.colorado.phet.microwaves.model.PolarBody;
import edu.colorado.phet.microwaves.model.WaterMolecule;
import edu.colorado.phet.microwaves.model.WaterMoleculeWallCollisionExpert;
import edu.colorado.phet.microwaves.model.WaterMoleculeWaterMoleculeCollisionExpert;
import edu.colorado.phet.microwaves.model.waves.FiniteWaveMedium;
import edu.colorado.phet.microwaves.model.waves.WaveMedium;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class MicrowavesModel
extends BaseModel {
    private ArrayList polarBodies = new ArrayList();
    private FiniteWaveMedium waveMedium = new FiniteWaveMedium(new Point2D.Double(100.0, 100.0), 500.0, 400.0);
    private ArrayList microwaves = new ArrayList();
    private double frequency = 0.0015;
    private double amplitude = 0.25;
    private Box2D oven;
    private Microwave mw;
    private final String name;

    public MicrowavesModel(String string) {
        this.name = string;
        this.addModelElement(this.waveMedium);
        new WaterMoleculeWaterMoleculeCollisionExpert();
    }

    public void addMicrowave(Microwave microwave) {
        this.waveMedium.addWavefront(microwave);
        this.microwaves.add(microwave);
        this.mw = microwave;
    }

    public void addPolarBody(PolarBody polarBody) {
        this.polarBodies.add(polarBody);
        this.addModelElement(polarBody);
    }

    public void setOven(Box2D box2D) {
        if (this.oven != null) {
            this.removeModelElement(this.oven);
        }
        this.oven = box2D;
        this.waveMedium.setBounds(new Point2D.Double(box2D.getMinX(), box2D.getMinY()), box2D.getMaxX() - box2D.getMinX(), box2D.getMaxY() - box2D.getMinY());
        this.addModelElement(box2D);
    }

    public void update(ClockEvent clockEvent) {
        int n;
        for (n = 0; n < this.polarBodies.size(); ++n) {
            PolarBody polarBody = (PolarBody)this.polarBodies.get(n);
            if ((int)polarBody.getLocation().getX() < 0 || (int)polarBody.getLocation().getX() >= this.mw.getAmplitude().length) continue;
            polarBody.respondToEmf(new Vector2D(0.0f, this.mw.getAmplitude()[(int)polarBody.getLocation().getX()]), 0.1);
        }
        for (n = 0; n < this.polarBodies.size() - 1; ++n) {
            for (int i = n + 1; i < this.polarBodies.size(); ++i) {
                WaterMolecule waterMolecule = (WaterMolecule)this.polarBodies.get(n);
                WaterMolecule waterMolecule2 = (WaterMolecule)this.polarBodies.get(i);
                if (waterMolecule.getLastColidedBody() == waterMolecule2 && waterMolecule2.getLastColidedBody() == waterMolecule || !WaterMoleculeWaterMoleculeCollisionExpert.areInContact(waterMolecule, waterMolecule2)) continue;
                waterMolecule.setLastColidedBody(waterMolecule2);
                waterMolecule2.setLastColidedBody(waterMolecule);
            }
        }
        super.update(clockEvent);
        if (this.oven != null) {
            for (n = 0; n < this.polarBodies.size(); ++n) {
                WaterMolecule waterMolecule = (WaterMolecule)this.polarBodies.get(n);
                WaterMoleculeWallCollisionExpert.areInContact((WaterMolecule)this.polarBodies.get(n), this.oven);
                this.oven.setLastColidedBody(waterMolecule);
                waterMolecule.setLastColidedBody(this.oven);
            }
        }
    }

    public double getFrequency() {
        return this.frequency;
    }

    public void setMicrowaveFrequency(double d) {
        this.frequency = d;
        for (int i = 0; i < this.microwaves.size(); ++i) {
            Microwave microwave = (Microwave)this.microwaves.get(i);
            microwave.setFrequency((float)d);
        }
    }

    public double getAmplitude() {
        return this.amplitude;
    }

    public void setMicrowaveAmplitude(double d) {
        this.amplitude = d;
        for (int i = 0; i < this.microwaves.size(); ++i) {
            Microwave microwave = (Microwave)this.microwaves.get(i);
            microwave.setMaxAmplitude((float)d);
        }
    }

    public final WaveMedium getWaveMedium() {
        return this.waveMedium;
    }

    public Box2D getOven() {
        return this.oven;
    }

    public void clear() {
        this.frequency = 0.0015;
        this.amplitude = 0.25;
        this.polarBodies.clear();
        this.waveMedium.clear();
        this.microwaves.clear();
        this.removeAllModelElements();
        this.addModelElement(this.waveMedium);
    }
}

