/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.microwaves.coreadditions.collision;

import edu.colorado.phet.microwaves.coreadditions.CompositeBody;
import edu.colorado.phet.microwaves.coreadditions.Vector2D;
import edu.colorado.phet.microwaves.coreadditions.collision.HorizontalWall;
import edu.colorado.phet.microwaves.coreadditions.collision.VerticalWall;
import edu.colorado.phet.microwaves.coreadditions.collision.Wall;
import java.awt.geom.Point2D;

public class Box2D
extends CompositeBody {
    private Point2D.Double corner1;
    private Point2D.Double corner2;
    private Point2D.Double center;
    private double minX;
    private double minY;
    private double maxX;
    private double maxY;
    private Wall leftWall;
    private Object leftWallMonitor = new Object();
    private double leftWallVx = 0.0;
    private Vector2D[] opening = new Vector2D[]{new Vector2D(0.0f, 0.0f), new Vector2D(0.0f, 0.0f)};
    private Wall[] walls = new Wall[4];
    private Vector2D closestCornerResult = new Vector2D();

    public Box2D() {
    }

    public Box2D(Point2D.Double double_, Point2D.Double double_2) {
        this.setState(double_, double_2);
    }

    private void setState(Point2D.Double double_, Point2D.Double double_2) {
        this.corner1 = double_;
        this.corner2 = double_2;
        this.maxX = Math.max(double_.getX(), double_2.getX());
        this.maxY = Math.max(double_.getY(), double_2.getY());
        this.minX = Math.max(Math.min(Math.min(double_.getX(), double_2.getX()), this.maxX - 20.0), 0.0);
        this.minY = Math.min(double_.getY(), double_2.getY());
        this.center = new Point2D.Double((this.maxX + this.minX) / 2.0, (this.maxY + this.minY) / 2.0);
        this.setLocation(this.minX, this.minY);
        Vector2D[] vector2DArray = this.getOpening();
        vector2DArray[0].setY((float)this.minY);
        vector2DArray[1].setY((float)this.minY);
        this.setOpening(vector2DArray);
        if (this.walls[0] == null) {
            this.walls[0] = new VerticalWall((float)this.minX, (float)this.minX, (float)this.minY, (float)this.maxY, VerticalWall.FACING_RIGHT);
        }
        this.walls[0].setLocation(this.minX, this.minX, this.minY, this.maxY);
        this.leftWall = this.walls[0];
        if (this.walls[1] == null) {
            this.walls[1] = new VerticalWall((float)this.maxX, (float)this.maxX, (float)this.minY, (float)this.maxY, VerticalWall.FACING_LEFT);
        }
        this.walls[1].setLocation(this.maxX, this.maxX, this.minY, this.maxY);
        if (this.walls[2] == null) {
            this.walls[2] = new HorizontalWall((float)this.minX, (float)this.maxX, (float)this.minY, (float)this.minY, HorizontalWall.FACING_DOWN);
        }
        this.walls[2].setLocation(this.minX, this.maxX, this.minY, this.minY);
        if (this.walls[3] == null) {
            this.walls[3] = new HorizontalWall((float)this.minX, (float)this.maxX, (float)this.maxY, (float)this.maxY, HorizontalWall.FACING_UP);
        }
        this.walls[3].setLocation(this.minX, this.maxX, this.maxY, this.maxY);
        this.setChanged();
        this.notifyObservers();
    }

    public void setOpening(Vector2D[] vector2DArray) {
        this.opening[0] = vector2DArray[0];
        this.opening[1] = vector2DArray[1];
        this.setChanged();
        this.notifyObservers();
    }

    public Vector2D[] getOpening() {
        return this.opening;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public Wall[] getWalls() {
        return this.walls;
    }
}

