/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.microwaves.coreadditions;

import edu.colorado.phet.microwaves.coreadditions.PhysicalVector;
import edu.colorado.phet.microwaves.coreadditions.Vector2D;
import java.util.Vector;

public class Vector3D
extends PhysicalVector {
    public Vector3D() {
        this(0.0f, 0.0f, 0.0f);
    }

    public Vector3D(Vector2D vector2D) {
        this(vector2D.getX(), vector2D.getY(), 0.0f);
    }

    public Vector3D(float f, float f2, float f3) {
        super(3);
        this.setX(f);
        this.setY(f2);
        this.setZ(f3);
        if (Double.isNaN(f)) {
            System.out.println("Vector2D constructor: x was NaN");
        }
        if (Double.isNaN(f2)) {
            System.out.println("Vector2D constructor: y was NaN");
        }
    }

    public String toString() {
        Vector<Double> vector = new Vector<Double>();
        vector.add(new Double(this.getX()));
        vector.add(new Double(this.getY()));
        vector.add(new Double(this.getZ()));
        return vector.toString();
    }

    public float getX() {
        return this.getScalarAt(0);
    }

    public void setX(float f) {
        this.setScalarAt(0, f);
    }

    public float getY() {
        return this.getScalarAt(1);
    }

    public void setY(float f) {
        this.setScalarAt(1, f);
    }

    public float getZ() {
        return this.getScalarAt(2);
    }

    public void setZ(float f) {
        this.setScalarAt(2, f);
    }

    public Vector3D add(Vector3D vector3D) {
        return (Vector3D)super.add(vector3D, this);
    }

    public Vector3D multiply(float f) {
        return (Vector3D)super.multiply(f, this);
    }

    public Vector3D crossProduct(Vector3D vector3D) {
        Vector3D vector3D2 = new Vector3D(this.getY() * vector3D.getZ() - this.getZ() * vector3D.getY(), -this.getX() * vector3D.getZ() + this.getZ() * vector3D.getX(), this.getX() * vector3D.getY() - this.getY() * vector3D.getX());
        return vector3D2;
    }
}

