/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.microwaves;

import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.microwaves.MicrowaveModule;
import edu.colorado.phet.microwaves.MicrowavesResources;
import edu.colorado.phet.microwaves.common.graphics.Graphic;
import edu.colorado.phet.microwaves.common.graphics.ImageGraphic;
import edu.colorado.phet.microwaves.coreadditions.collision.Box2D;
import edu.colorado.phet.microwaves.model.MicrowavesModel;
import edu.colorado.phet.microwaves.model.WaterMolecule;
import edu.colorado.phet.microwaves.view.CoffeeControlPanel;
import edu.colorado.phet.microwaves.view.WaterMoleculeGraphic;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class CoffeeModule
extends MicrowaveModule {
    private Box2D mug;
    private PowerManager powerManager;
    private boolean ovenOn;
    private double powerLevel;
    private CoffeeControlPanel coffeeControlPanel;

    public CoffeeModule() {
        super(MicrowavesResources.getString("ModuleTitle.CoffeeModule"));
    }

    protected void init() {
        Object object;
        WaterMolecule[] waterMoleculeArray;
        super.init();
        try {
            waterMoleculeArray = ImageLoader.loadBufferedImage("microwaves/images/coffee-cup-2.gif");
            object = new ImageGraphic((BufferedImage)waterMoleculeArray, new Point2D.Double(150.0, 120.0));
            this.getApparatusPanel().addGraphic((Graphic)object, 10.0);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.mug = new Box2D(new Point2D.Double(230.0, 150.0), new Point2D.Double(380.0, 320.0));
        ((MicrowavesModel)this.getModel()).setOven(this.mug);
        waterMoleculeArray = new WaterMolecule[60];
        object = this.getMicrowaveModel().getOven();
        for (int i = 0; i < 6; ++i) {
            WaterMolecule waterMolecule = new WaterMolecule();
            double d = -1.0;
            while (d < ((Box2D)object).getMinX() + 20.0 + 20.0 || d > ((Box2D)object).getMaxX() - 40.0) {
                d = Math.random() * ((Box2D)object).getMaxX();
            }
            double d2 = -1.0;
            while (d2 < ((Box2D)object).getMinY() + 20.0 + 20.0 || d2 > ((Box2D)object).getMaxY() - 40.0) {
                d2 = Math.random() * ((Box2D)object).getMaxY();
            }
            waterMolecule.setLocation(d, d2);
            waterMolecule.setVelocity((float)Math.random() / 5.0f, (float)Math.random() / 5.0f);
            waterMoleculeArray[i] = waterMolecule;
            waterMolecule.setDipoleOrientation(Math.random() * Math.PI * 2.0);
            this.getMicrowaveModel().addPolarBody(waterMolecule);
            WaterMoleculeGraphic waterMoleculeGraphic = new WaterMoleculeGraphic(waterMolecule, this.getModelViewTransform());
            this.getApparatusPanel().addGraphic(waterMoleculeGraphic, 5.0);
            waterMolecule.setVisible(true);
        }
        this.powerManager = new PowerManager(this.powerLevel);
        if (this.coffeeControlPanel == null) {
            this.coffeeControlPanel = new CoffeeControlPanel(this, this.getMicrowaveModel());
        }
        this.setControlPanel(this.coffeeControlPanel);
        this.ovenOn = false;
    }

    public void activate() {
        super.activate();
        this.powerManager = new PowerManager(this.powerLevel);
        this.powerManager.isAlive();
        this.powerManager.start();
    }

    public void deactivate() {
        super.deactivate();
        this.powerManager.setRunning(false);
    }

    public void setPowerLevel(double d) {
        this.powerManager.setPowerLevel(d);
    }

    public synchronized void toggleMicrowave() {
        this.ovenOn = !this.ovenOn;
    }

    public void reset() {
        super.reset();
        this.coffeeControlPanel.reset();
    }

    private class PowerManager
    extends Thread {
        private boolean isRunning = true;
        private double period = 6000.0;

        PowerManager(double d) {
            CoffeeModule.this.powerLevel = d;
        }

        void setPowerLevel(double d) {
            CoffeeModule.this.powerLevel = d;
        }

        void setRunning(boolean bl) {
            this.isRunning = bl;
        }

        public void run() {
            while (this.isRunning) {
                if (CoffeeModule.this.ovenOn) {
                    double d = System.currentTimeMillis();
                    double d2 = d % this.period;
                    if (d2 < CoffeeModule.this.powerLevel * this.period) {
                        CoffeeModule.this.turnMicrowaveOn(0.002, 0.33);
                    }
                    if (d2 > CoffeeModule.this.powerLevel * this.period) {
                        CoffeeModule.this.turnMicrowaveOff();
                    }
                } else {
                    CoffeeModule.this.turnMicrowaveOff();
                }
                try {
                    PowerManager.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }
}

