/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.membranechannels.view;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.membranechannels.model.MembraneChannelsModel;
import edu.colorado.phet.membranechannels.view.RestoreDefaultOnReleaseCursorHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Font;
import java.awt.geom.Point2D;

public abstract class ToolBoxItem
extends PComposite {
    protected static final ModelViewTransform2D SCALING_MVT = new ModelViewTransform2D((Point2D)new Point2D.Double(0.0, 0.0), (Point2D)new Point2D.Double(0.0, 0.0), 10.0, true);
    private static final Font LABEL_FONT = new PhetFont(20);
    private final MembraneChannelsModel model;
    private final PhetPCanvas canvas;
    private final ModelViewTransform2D mvt;
    private PNode selectionNode = null;
    private HTMLNode caption = null;
    private RestoreDefaultOnReleaseCursorHandler cursorHandler = new RestoreDefaultOnReleaseCursorHandler(12);

    public ToolBoxItem(MembraneChannelsModel membraneChannelsModel, final ModelViewTransform2D modelViewTransform2D, final PhetPCanvas phetPCanvas) {
        this.model = membraneChannelsModel;
        this.mvt = modelViewTransform2D;
        this.canvas = phetPCanvas;
        this.initializeSelectionNode();
        this.updateLayout();
        this.addInputEventListener(this.cursorHandler);
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                Point2D point2D = pInputEvent.getCanvasPosition();
                Point2D.Double double_ = new Point2D.Double(point2D.getX(), point2D.getY());
                phetPCanvas.getPhetRootNode().screenToWorld(double_);
                Point2D point2D2 = modelViewTransform2D.viewToModel(double_);
                ToolBoxItem.this.handleAddRequest(point2D2);
            }

            public void mouseDragged(PInputEvent pInputEvent) {
                Point2D point2D = pInputEvent.getCanvasPosition();
                Point2D.Double double_ = new Point2D.Double(point2D.getX(), point2D.getY());
                phetPCanvas.getPhetRootNode().screenToWorld(double_);
                Point2D point2D2 = modelViewTransform2D.viewToModel(double_);
                ToolBoxItem.this.setModelElementPosition(point2D2);
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                ToolBoxItem.this.releaseModelElement();
            }
        });
    }

    protected MembraneChannelsModel getModel() {
        return this.model;
    }

    protected abstract void initializeSelectionNode();

    protected abstract void addElementToModel(Point2D var1);

    protected abstract void setModelElementPosition(Point2D var1);

    protected abstract void releaseModelElement();

    protected void handleAddRequest(Point2D point2D) {
        this.addElementToModel(point2D);
    }

    protected void setSelectionNode(PNode pNode) {
        assert (this.selectionNode == null);
        this.selectionNode = pNode;
        this.addChild(pNode);
    }

    private void updateLayout() {
        if (this.caption != null && this.selectionNode != null) {
            this.caption.setOffset(-this.caption.getFullBoundsReference().getWidth() / 2.0, this.selectionNode.getFullBoundsReference().getMaxY() + 4.0);
        }
    }
}

