/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.membranechannels.view;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.view.HorizontalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.membranechannels.MembraneChannelsResources;
import edu.colorado.phet.membranechannels.model.InjectionMotionStrategy;
import edu.colorado.phet.membranechannels.model.MembraneChannelsModel;
import edu.colorado.phet.membranechannels.model.Particle;
import edu.colorado.phet.membranechannels.model.ParticleType;
import edu.colorado.phet.membranechannels.model.PotassiumIon;
import edu.colorado.phet.membranechannels.model.SodiumIon;
import edu.colorado.phet.membranechannels.view.MyCursorHandler;
import edu.colorado.phet.membranechannels.view.ParticleNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ParticleInjectorNode
extends PNode {
    private static final Point2D BUTTON_OFFSET = new Point2D.Double(-100.0, -65.0);
    private static double NOMINAL_ION_INJECTION_VELOCITY = 30.0;
    private final PNode injectorBodyImageNode;
    private final PImage buttonImageNode;
    private final BufferedImage unpressedButtonImage;
    private final BufferedImage pressedButtonImage;
    private final PNode particleTypeSelector;
    private final MembraneChannelsModel model;
    private final ModelViewTransform2D mvt;
    private ParticleType particleTypeToInject;
    private Dimension2D injectionPointOffset = new PDimension();
    private Point2D injectionPointInModelCoords = new Point2D.Double();
    private Vector2D nominalInjectionVelocityVector = new Vector2D(NOMINAL_ION_INJECTION_VELOCITY, 0.0);
    private int count;
    private long buttonPressedTime = Long.MAX_VALUE;

    public ParticleInjectorNode(ParticleType particleType, final MembraneChannelsModel membraneChannelsModel, ModelViewTransform2D modelViewTransform2D, double d) {
        this.particleTypeToInject = particleType;
        this.model = membraneChannelsModel;
        this.mvt = modelViewTransform2D;
        membraneChannelsModel.getClock().addClockListener(new ClockAdapter(){

            public void simulationTimeChanged(ClockEvent clockEvent) {
                ParticleInjectorNode.this.count++;
                if (ParticleInjectorNode.this.buttonPressedTime != Long.MAX_VALUE && System.currentTimeMillis() - ParticleInjectorNode.this.buttonPressedTime > 500L && ParticleInjectorNode.this.count % 7 == 0) {
                    ParticleInjectorNode.this.injectParticle();
                }
            }
        });
        this.nominalInjectionVelocityVector.rotate(d);
        PNode pNode = new PNode();
        BufferedImage bufferedImage = MembraneChannelsResources.getImage("squeezer_background.png");
        this.injectorBodyImageNode = new PImage(bufferedImage);
        PBounds pBounds = this.injectorBodyImageNode.getFullBounds();
        this.injectorBodyImageNode.setOffset(-((RectangularShape)pBounds).getWidth() / 2.0, -((RectangularShape)pBounds).getHeight() / 2.0);
        pNode.addChild(this.injectorBodyImageNode);
        this.pressedButtonImage = MembraneChannelsResources.getImage("button_pressed.png");
        this.unpressedButtonImage = MembraneChannelsResources.getImage("button_unpressed.png");
        this.buttonImageNode = new PImage(this.unpressedButtonImage);
        this.buttonImageNode.setOffset(BUTTON_OFFSET);
        pNode.addChild(this.buttonImageNode);
        double d2 = 130.0 / this.injectorBodyImageNode.getFullBoundsReference().height;
        pNode.rotate(-d);
        pNode.scale(d2);
        this.particleTypeSelector = new ParticleTypeSelectorNode(78.0, particleType, this);
        this.particleTypeSelector.setOffset(pNode.getFullBoundsReference().getMinX() - this.particleTypeSelector.getFullBoundsReference().width / 2.0 - 5.0, pNode.getFullBoundsReference().getCenterY() - this.particleTypeSelector.getFullBoundsReference().height / 2.0);
        this.addChild(this.particleTypeSelector);
        pNode.setOffset(-Math.abs(Math.sin(d * 2.0)) * 30.0, 0.0);
        this.addChild(pNode);
        double d3 = 91.0;
        double d4 = 52.0;
        this.injectionPointOffset.setSize(d3 * Math.cos(d) + d4, d3 * Math.sin(-d));
        this.updateInjectionPoint();
        this.injectorBodyImageNode.setPickable(false);
        this.buttonImageNode.setPickable(true);
        this.buttonImageNode.addInputEventListener(new MyCursorHandler());
        this.buttonImageNode.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                ParticleInjectorNode.this.buttonPressedTime = System.currentTimeMillis();
                if (membraneChannelsModel.getRemainingParticleCapacity() > 0) {
                    ParticleInjectorNode.this.buttonImageNode.setImage(ParticleInjectorNode.this.pressedButtonImage);
                    ParticleInjectorNode.this.injectParticle();
                }
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                ParticleInjectorNode.this.buttonImageNode.setImage(ParticleInjectorNode.this.unpressedButtonImage);
                ParticleInjectorNode.this.buttonPressedTime = Long.MAX_VALUE;
            }
        });
    }

    private void injectParticle() {
        Rectangle2D rectangle2D;
        Particle particle = Particle.createParticle(this.particleTypeToInject);
        particle.setPosition(this.injectionPointInModelCoords);
        if (this.model.getUpperParticleChamberRect().contains(this.injectionPointInModelCoords)) {
            rectangle2D = this.model.getUpperParticleChamberRect();
        } else if (this.model.getLowerParticleChamberRect().contains(this.injectionPointInModelCoords)) {
            rectangle2D = this.model.getLowerParticleChamberRect();
        } else {
            System.err.println();
            assert (false);
            System.err.println(this.getClass().getName() + " - Error: Particle not in reasonable location.");
            rectangle2D = this.model.getLowerParticleChamberRect();
        }
        particle.setMotionStrategy(new InjectionMotionStrategy(this.injectionPointInModelCoords, rectangle2D, 0.0));
        this.model.injectParticle(particle);
    }

    private void updateInjectionPoint() {
        double d = this.mvt.viewToModelX(this.getFullBoundsReference().getCenter2D().getX() + this.injectionPointOffset.getWidth());
        double d2 = this.mvt.viewToModelY(this.getFullBoundsReference().getCenter2D().getY() + this.injectionPointOffset.getHeight());
        this.injectionPointInModelCoords.setLocation(d, d2);
    }

    protected void setParticleTypeToInject(ParticleType particleType) {
        if (this.particleTypeToInject != particleType) {
            this.particleTypeToInject = particleType;
        }
    }

    public void setOffset(double d, double d2) {
        super.setOffset(d, d2);
        this.updateInjectionPoint();
    }

    private static class ButtonIconPanel
    extends HorizontalLayoutPanel {
        private final JRadioButton radioButton;

        public ButtonIconPanel(final JRadioButton jRadioButton, Image image) {
            this.radioButton = jRadioButton;
            this.setBackground(ParticleTypeSelectorNode.BACKGROUND_COLOR);
            this.add(jRadioButton);
            JLabel jLabel = new JLabel(new ImageIcon(image));
            this.add(jLabel);
            jLabel.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent mouseEvent) {
                    jRadioButton.doClick();
                }
            });
        }

        protected JRadioButton getRadioButton() {
            return this.radioButton;
        }
    }

    private static class ParticleTypeSelectorNode
    extends PNode {
        private static final Color BACKGROUND_COLOR = new Color(234, 228, 77);
        private static final Stroke BORDER_STROKE = new BasicStroke(1.0f);
        private static final Color BORDER_COLOR = BACKGROUND_COLOR;
        private static final ModelViewTransform2D PARTICLE_MVT = new ModelViewTransform2D(new Rectangle2D.Double(-1.0, -1.0, 2.0, 2.0), new Rectangle2D.Double(-10.0, -10.0, 20.0, 20.0));
        private final ParticleInjectorNode particleInjectorNode;
        private final JRadioButton sodiumButton;
        private final JRadioButton potassiumButton;

        public ParticleTypeSelectorNode(double d, ParticleType particleType, ParticleInjectorNode particleInjectorNode) {
            this.particleInjectorNode = particleInjectorNode;
            ButtonIconPanel buttonIconPanel = this.createAndAddParticleSelectorButton(ParticleType.SODIUM_ION);
            this.sodiumButton = buttonIconPanel.getRadioButton();
            ButtonIconPanel buttonIconPanel2 = this.createAndAddParticleSelectorButton(ParticleType.POTASSIUM_ION);
            this.potassiumButton = buttonIconPanel2.getRadioButton();
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.sodiumButton);
            buttonGroup.add(this.potassiumButton);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(2, 2));
            jPanel.add(buttonIconPanel);
            JPanel jPanel2 = new JPanel();
            jPanel2.setBackground(BACKGROUND_COLOR);
            jPanel.add(jPanel2);
            jPanel.add(buttonIconPanel2);
            JPanel jPanel3 = new JPanel();
            jPanel3.setBackground(BACKGROUND_COLOR);
            jPanel.add(jPanel3);
            PSwing pSwing = new PSwing(jPanel);
            pSwing.setScale(d * 0.8 / pSwing.getFullBoundsReference().height);
            double d2 = d;
            double d3 = pSwing.getFullBoundsReference().width * 1.2;
            PhetPPath phetPPath = new PhetPPath(new RoundRectangle2D.Double(0.0, 0.0, d3, d2, 30.0, 30.0), BACKGROUND_COLOR, BORDER_STROKE, BORDER_COLOR);
            pSwing.setOffset(phetPPath.getFullBoundsReference().getCenterX() - pSwing.getFullBoundsReference().getWidth() / 2.0, phetPPath.getFullBoundsReference().getCenterY() - pSwing.getFullBoundsReference().getHeight() / 2.0);
            phetPPath.addChild(pSwing);
            this.addChild(phetPPath);
            this.updateParticleSelectionButtons();
        }

        private ButtonIconPanel createAndAddParticleSelectorButton(final ParticleType particleType) {
            Image image;
            switch (particleType) {
                case SODIUM_ION: {
                    image = new ParticleNode(new SodiumIon(), PARTICLE_MVT).toImage();
                    break;
                }
                case POTASSIUM_ION: {
                    image = new ParticleNode(new PotassiumIon(), PARTICLE_MVT).toImage();
                    break;
                }
                default: {
                    System.err.println(this.getClass().getName() + "- Error: Unrecognized particle type.");
                    assert (false);
                    image = new ParticleNode(new PotassiumIon(), PARTICLE_MVT).toImage();
                }
            }
            JRadioButton jRadioButton = new JRadioButton();
            jRadioButton.setBackground(BACKGROUND_COLOR);
            jRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ParticleTypeSelectorNode.this.particleInjectorNode.setParticleTypeToInject(particleType);
                }
            });
            HorizontalLayoutPanel horizontalLayoutPanel = new HorizontalLayoutPanel();
            horizontalLayoutPanel.setBackground(BACKGROUND_COLOR);
            ((Container)horizontalLayoutPanel).add(jRadioButton);
            JLabel jLabel = new JLabel(new ImageIcon(image));
            ((Container)horizontalLayoutPanel).add(jLabel);
            return new ButtonIconPanel(jRadioButton, image);
        }

        private void updateParticleSelectionButtons() {
            switch (this.particleInjectorNode.particleTypeToInject) {
                case SODIUM_ION: {
                    if (this.sodiumButton.isSelected()) break;
                    this.sodiumButton.setSelected(true);
                    break;
                }
                case POTASSIUM_ION: {
                    if (this.potassiumButton.isSelected()) break;
                    this.potassiumButton.setSelected(true);
                    break;
                }
                default: {
                    System.err.println(this.getClass().getName() + " - Error: Unknown particle type.");
                    assert (false);
                    break;
                }
            }
        }
    }
}

