/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.membranechannels.view;

import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.membranechannels.model.MembraneChannelsModel;
import edu.colorado.phet.membranechannels.model.ParticleType;
import edu.colorado.phet.membranechannels.model.PotassiumIon;
import edu.colorado.phet.membranechannels.model.SodiumIon;
import edu.colorado.phet.membranechannels.view.ParticleNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class ConcentrationGraph
extends PhetPNode {
    private static final Dimension2D size = new PDimension(150.0, 200.0);
    private static final Color MAIN_BACKGROUND_COLOR = Color.WHITE;
    private static float OUTLINE_STROKE_WIDTH = 1.0f;
    private static final Stroke OUTLINE_STROKE = new BasicStroke(OUTLINE_STROKE_WIDTH);
    private static final Color OUTLINE_STROKE_COLOR = Color.BLACK;
    private static final Color SODIUM_BAR_COLOR = new SodiumIon().getRepresentationColor();
    private static final Color POTASSIUM_BAR_COLOR = new PotassiumIon().getRepresentationColor();
    private MembraneChannelsModel model;
    private PNode background;
    private PNode graphBaseLine;
    private PhetPPath sodiumBar;
    private PhetPPath potassiumBar;
    private Rectangle2D sodiumBarShape = new Rectangle2D.Double();
    private Rectangle2D potassiumBarShape = new Rectangle2D.Double();
    private double barWidth;
    private double maxBarHeight;
    private JButton closeButton;
    private PSwing closePSwing;
    private double distanceFromBottomToBars;
    private boolean upperChamber;

    public ConcentrationGraph(final MembraneChannelsModel membraneChannelsModel, boolean bl) {
        this.model = membraneChannelsModel;
        this.upperChamber = bl;
        membraneChannelsModel.addListener(new MembraneChannelsModel.Adapter(){

            public void concentrationGraphVisibilityChanged() {
                ConcentrationGraph.this.updateVisibility();
            }

            public void concentrationsChanged() {
                ConcentrationGraph.this.updateBarSizes();
            }
        });
        this.background = new PhetPPath(new RoundRectangle2D.Double(0.0, 0.0, size.getWidth(), size.getHeight(), 12.0, 12.0), MAIN_BACKGROUND_COLOR, OUTLINE_STROKE, OUTLINE_STROKE_COLOR);
        this.addChild(this.background);
        this.barWidth = size.getWidth() * 0.2;
        this.maxBarHeight = size.getHeight() * 0.75;
        ImageIcon imageIcon = new ImageIcon(PhetCommonResources.getInstance().getImage("buttons/closeButton.png"));
        this.closeButton = new JButton(imageIcon);
        this.closeButton.setPreferredSize(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()));
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                membraneChannelsModel.setConcentrationGraphsVisible(false);
            }
        });
        this.closePSwing = new PSwing(this.closeButton);
        this.closePSwing.setOffset(size.getWidth() - (double)this.closeButton.getBounds().width - 7.0, 5.0);
        this.closePSwing.addInputEventListener(new CursorHandler(12));
        this.addChild(this.closePSwing);
        this.distanceFromBottomToBars = size.getHeight() * 0.2;
        double d = size.getWidth() * 0.1;
        Line2D.Double double_ = new Line2D.Double(d, size.getHeight() - this.distanceFromBottomToBars, size.getWidth() - d, size.getHeight() - this.distanceFromBottomToBars);
        this.graphBaseLine = new PhetPPath(double_, (Stroke)new BasicStroke(2.0f), (Paint)Color.BLACK);
        this.addChild(this.graphBaseLine);
        ParticleTypeLabelNode particleTypeLabelNode = new ParticleTypeLabelNode(this.distanceFromBottomToBars * 0.6, ParticleType.SODIUM_ION);
        particleTypeLabelNode.setOffset(size.getWidth() * 0.25 - particleTypeLabelNode.getFullBoundsReference().width / 2.0, size.getHeight() - particleTypeLabelNode.getFullBoundsReference().height - 5.0);
        this.addChild(particleTypeLabelNode);
        ParticleTypeLabelNode particleTypeLabelNode2 = new ParticleTypeLabelNode(this.distanceFromBottomToBars * 0.6, ParticleType.POTASSIUM_ION);
        particleTypeLabelNode2.setOffset(size.getWidth() * 0.75 - particleTypeLabelNode2.getFullBoundsReference().width / 2.0, size.getHeight() - particleTypeLabelNode2.getFullBoundsReference().height - 5.0);
        this.addChild(particleTypeLabelNode2);
        this.sodiumBar = new PhetPPath(SODIUM_BAR_COLOR);
        this.sodiumBar.setOffset(size.getWidth() * 0.25 - this.barWidth / 2.0, 0.0);
        this.addChild(this.sodiumBar);
        this.potassiumBar = new PhetPPath(POTASSIUM_BAR_COLOR);
        this.potassiumBar.setOffset(size.getWidth() * 0.75 - this.barWidth / 2.0, 0.0);
        this.addChild(this.potassiumBar);
        this.updateBarSizes();
        this.updateVisibility();
    }

    private void updateBarSizes() {
        double d;
        double d2;
        if (this.upperChamber) {
            d2 = this.model.getCountInUpperSubChamber(ParticleType.SODIUM_ION) / 100.0 * this.maxBarHeight;
            d = this.model.getCountInUpperSubChamber(ParticleType.POTASSIUM_ION) / 100.0 * this.maxBarHeight;
        } else {
            d2 = this.model.getCountInLowerSubChamber(ParticleType.SODIUM_ION) / 100.0 * this.maxBarHeight;
            d = this.model.getCountInLowerSubChamber(ParticleType.POTASSIUM_ION) / 100.0 * this.maxBarHeight;
        }
        this.sodiumBarShape.setFrame(0.0, 0.0, this.barWidth, d2);
        this.sodiumBar.setPathTo(this.sodiumBarShape);
        this.sodiumBar.setOffset(this.sodiumBar.getOffset().getX(), size.getHeight() - this.distanceFromBottomToBars - this.sodiumBarShape.getHeight());
        this.potassiumBarShape.setFrame(0.0, 0.0, this.barWidth, d);
        this.potassiumBar.setPathTo(this.potassiumBarShape);
        this.potassiumBar.setOffset(this.potassiumBar.getOffset().getX(), size.getHeight() - this.distanceFromBottomToBars - this.potassiumBarShape.getHeight());
    }

    private void updateVisibility() {
        this.setVisible(this.model.isConcentrationGraphsVisible());
    }

    private static class ParticleTypeLabelNode
    extends PNode {
        private static final ModelViewTransform2D LABEL_MVT = new ModelViewTransform2D(new Rectangle2D.Double(-1.0, -1.0, 2.0, 2.0), new Rectangle2D.Double(-10.0, -10.0, 20.0, 20.0));

        public ParticleTypeLabelNode(double d, ParticleType particleType) {
            ParticleNode particleNode;
            switch (particleType) {
                case SODIUM_ION: {
                    particleNode = new ParticleNode(new SodiumIon(), LABEL_MVT);
                    break;
                }
                case POTASSIUM_ION: {
                    particleNode = new ParticleNode(new PotassiumIon(), LABEL_MVT);
                    break;
                }
                default: {
                    System.out.println(this.getClass().getName() + " - Error: Unhandled particle type.");
                    assert (false);
                    particleNode = new ParticleNode(new PotassiumIon(), LABEL_MVT);
                }
            }
            particleNode.setScale(d / particleNode.getFullBoundsReference().height);
            particleNode.setOffset(particleNode.getFullBoundsReference().width / 2.0, particleNode.getFullBoundsReference().height / 2.0);
            this.addChild(particleNode);
        }
    }
}

