/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.membranechannels.model;

import edu.colorado.phet.membranechannels.model.CaptureZone;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;

public class PieSliceShapedCaptureZone
extends CaptureZone {
    private Arc2D zoneShape;
    private Point2D originPoint;
    private double radius;
    private final double angleOfExtent;
    private final double fixedRotationalOffset;

    public PieSliceShapedCaptureZone(Point2D point2D, double d, double d2, double d3) {
        this.originPoint = point2D;
        this.radius = d;
        this.fixedRotationalOffset = d2;
        this.angleOfExtent = d3;
        this.zoneShape = new Arc2D.Double();
        this.updateShape();
    }

    public boolean isPointInZone(Point2D point2D) {
        return this.zoneShape.contains(point2D);
    }

    public void setOriginPoint(double d, double d2) {
        this.originPoint.setLocation(d, d2);
        this.updateShape();
    }

    public Point2D getOriginPoint() {
        return this.originPoint;
    }

    private void updateShape() {
        this.zoneShape.setArcByCenter(this.originPoint.getX(), this.originPoint.getY(), this.radius, Math.toDegrees(this.fixedRotationalOffset - this.angleOfExtent / 2.0), Math.toDegrees(this.angleOfExtent), 2);
    }
}

