/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.membranechannels.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.membranechannels.model.IMovable;
import edu.colorado.phet.membranechannels.model.MotionStrategy;
import edu.colorado.phet.membranechannels.model.ParticleType;
import edu.colorado.phet.membranechannels.model.PotassiumIon;
import edu.colorado.phet.membranechannels.model.SodiumIon;
import edu.colorado.phet.membranechannels.model.StillnessMotionStrategy;
import edu.colorado.phet.membranechannels.model.TraverseChannelMotionStrategy;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public abstract class Particle
implements IMovable {
    private double DEFAULT_PARTICLE_RADIUS = 0.75;
    protected ArrayList<Listener> listeners = new ArrayList();
    private Point2D.Double position;
    private MotionStrategy motionStrategy = new StillnessMotionStrategy();

    public Particle(double d, double d2) {
        this.position = new Point2D.Double(d, d2);
    }

    public Particle() {
        this(0.0, 0.0);
    }

    public static Particle createParticle(ParticleType particleType) {
        Particle particle = null;
        switch (particleType) {
            case POTASSIUM_ION: {
                particle = new PotassiumIon();
                break;
            }
            case SODIUM_ION: {
                particle = new SodiumIon();
                break;
            }
            default: {
                System.err.println("Error: Unrecognized particle type.");
                assert (false);
                break;
            }
        }
        return particle;
    }

    public abstract ParticleType getType();

    public Point2D.Double getPosition() {
        return new Point2D.Double(this.position.getX(), this.position.getY());
    }

    public Point2D.Double getPositionReference() {
        return this.position;
    }

    public void setPosition(Point2D point2D) {
        this.setPosition(point2D.getX(), point2D.getY());
    }

    public void setPosition(double d, double d2) {
        this.position.setLocation(d, d2);
        this.notifyPositionChanged();
    }

    protected boolean isAvailableForCapture() {
        return !(this.motionStrategy instanceof TraverseChannelMotionStrategy);
    }

    protected void notifyPositionChanged() {
        for (Listener listener : this.listeners) {
            listener.positionChanged();
        }
    }

    public void removeFromModel() {
        this.notifyRemoved();
    }

    private void notifyRemoved() {
        ArrayList<Listener> arrayList = new ArrayList<Listener>(this.listeners);
        for (Listener listener : arrayList) {
            listener.removedFromModel();
        }
    }

    public void setMotionStrategy(MotionStrategy motionStrategy) {
        this.motionStrategy = motionStrategy;
    }

    public MotionStrategy getMotionStrategy() {
        return this.motionStrategy;
    }

    public Vector2D getVelocity() {
        return this.motionStrategy.getInstantaneousVelocity();
    }

    public double getDiameter() {
        return this.getRadius() * 2.0;
    }

    public double getRadius() {
        return this.DEFAULT_PARTICLE_RADIUS;
    }

    public abstract Color getRepresentationColor();

    public void stepInTime(double d) {
        this.motionStrategy.move(this, d);
    }

    public void addListener(Listener listener) {
        if (this.listeners.contains(listener)) {
            System.err.println(this.getClass().getName() + "- Warning: Attempting to re-add a listener that is already listening.");
            assert (false);
            return;
        }
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public static class Adapter
    implements Listener {
        public void positionChanged() {
        }

        public void removedFromModel() {
        }
    }

    public static interface Listener {
        public void positionChanged();

        public void removedFromModel();
    }
}

