/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.membranechannels.model;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.membranechannels.model.CaptureZone;
import edu.colorado.phet.membranechannels.model.CaptureZoneScanResult;
import edu.colorado.phet.membranechannels.model.IParticleCapture;
import edu.colorado.phet.membranechannels.model.MembraneChannel;
import edu.colorado.phet.membranechannels.model.MembraneChannelOpennessStrategy;
import edu.colorado.phet.membranechannels.model.MembraneChannelTypes;
import edu.colorado.phet.membranechannels.model.MembraneChannelsClock;
import edu.colorado.phet.membranechannels.model.Particle;
import edu.colorado.phet.membranechannels.model.ParticleType;
import edu.colorado.phet.membranechannels.model.TimedSettableOpennessStrategy;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MembraneChannelsModel
implements IParticleCapture {
    private static final Rectangle2D PARTICLE_CHAMBER_RECT = new Rectangle2D.Double(-35.0, -30.0, 70.0, 60.0);
    private static final Rectangle2D MEMBRANE_RECT = new Rectangle2D.Double(-35.0, -2.0, 70.0, 4.0);
    private static boolean SHOW_GRAPHS_DEFAULT = false;
    private final ConstantDtClock clock;
    private ArrayList<Particle> particles = new ArrayList();
    private ArrayList<MembraneChannel> membraneChannels = new ArrayList();
    private MembraneChannel userControlledMembraneChannel = null;
    private EventListenerList listeners = new EventListenerList();
    private final ArrayList<Point2D> allowableChannelLocations = new ArrayList(10);
    private boolean concentrationGraphsVisible = SHOW_GRAPHS_DEFAULT;
    private int numSodiumInUpperChamber = 0;
    private int numPotassiumInUpperChamber = 0;
    private int numSodiumInLowerChamber = 0;
    private int numPotassiumInLowerChamber = 0;
    private final TimedSettableOpennessStrategy sodiumChannelOpennessStrategy;
    private final TimedSettableOpennessStrategy potassiumChannelOpennessStrategy;

    public MembraneChannelsModel(MembraneChannelsClock membraneChannelsClock) {
        this.clock = membraneChannelsClock;
        membraneChannelsClock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                MembraneChannelsModel.this.stepInTime(clockEvent.getSimulationTimeChange());
            }
        });
        this.sodiumChannelOpennessStrategy = new TimedSettableOpennessStrategy(membraneChannelsClock);
        this.potassiumChannelOpennessStrategy = new TimedSettableOpennessStrategy(membraneChannelsClock);
        this.sodiumChannelOpennessStrategy.addListener(new MembraneChannelOpennessStrategy.Listener(){

            public void opennessChanged() {
                MembraneChannelsModel.this.notifySodiumGateOpennessChanged();
            }
        });
        this.potassiumChannelOpennessStrategy.addListener(new MembraneChannelOpennessStrategy.Listener(){

            public void opennessChanged() {
                MembraneChannelsModel.this.notifyPotassiumGateOpennessChanged();
            }
        });
        double d = MEMBRANE_RECT.getWidth() / 10.0;
        double d2 = MEMBRANE_RECT.getMinX() + d / 2.0;
        for (int i = 0; i < 10; ++i) {
            this.allowableChannelLocations.add(new Point2D.Double(d2 + (double)i * d, MEMBRANE_RECT.getCenterY()));
        }
    }

    public static Rectangle2D getOverallParticleChamberRect() {
        return new Rectangle2D.Double(PARTICLE_CHAMBER_RECT.getX(), PARTICLE_CHAMBER_RECT.getY(), PARTICLE_CHAMBER_RECT.getWidth(), PARTICLE_CHAMBER_RECT.getHeight());
    }

    @Override
    public Rectangle2D getUpperParticleChamberRect() {
        return new Rectangle2D.Double(PARTICLE_CHAMBER_RECT.getMinX(), MEMBRANE_RECT.getMaxY(), PARTICLE_CHAMBER_RECT.getWidth(), PARTICLE_CHAMBER_RECT.getMaxY() - MEMBRANE_RECT.getMaxY());
    }

    @Override
    public Rectangle2D getLowerParticleChamberRect() {
        return new Rectangle2D.Double(PARTICLE_CHAMBER_RECT.getMinX(), PARTICLE_CHAMBER_RECT.getMinY(), PARTICLE_CHAMBER_RECT.getWidth(), MEMBRANE_RECT.getMinY() - PARTICLE_CHAMBER_RECT.getMinY());
    }

    public static Rectangle2D getMembraneRect() {
        return new Rectangle2D.Double(MEMBRANE_RECT.getX(), MEMBRANE_RECT.getY(), MEMBRANE_RECT.getWidth(), MEMBRANE_RECT.getHeight());
    }

    public static double getMembraneThickness() {
        return MEMBRANE_RECT.getHeight();
    }

    public ConstantDtClock getClock() {
        return this.clock;
    }

    public ArrayList<Particle> getParticles() {
        return this.particles;
    }

    public boolean isConcentrationGraphsVisible() {
        return this.concentrationGraphsVisible;
    }

    public void setConcentrationGraphsVisible(boolean bl) {
        if (this.concentrationGraphsVisible != bl) {
            this.concentrationGraphsVisible = bl;
            this.notifyConcentrationGraphVisibilityChanged();
        }
    }

    public double getCountInUpperSubChamber(ParticleType particleType) {
        int n = 0;
        switch (particleType) {
            case SODIUM_ION: {
                n = this.numSodiumInUpperChamber;
                break;
            }
            case POTASSIUM_ION: {
                n = this.numPotassiumInUpperChamber;
                break;
            }
            default: {
                System.out.println(this.getClass().getName() + "Error: Unrecognized particle type.");
                assert (false);
                break;
            }
        }
        return n;
    }

    public double getCountInLowerSubChamber(ParticleType particleType) {
        int n = 0;
        switch (particleType) {
            case SODIUM_ION: {
                n = this.numSodiumInLowerChamber;
                break;
            }
            case POTASSIUM_ION: {
                n = this.numPotassiumInLowerChamber;
                break;
            }
            default: {
                System.out.println(this.getClass().getName() + "Error: Unrecognized particle type.");
                assert (false);
                break;
            }
        }
        return n;
    }

    public double getGatedSodiumChannelOpenness() {
        return this.sodiumChannelOpennessStrategy.getOpenness();
    }

    public double getGatedPotassiumChannelOpenness() {
        return this.potassiumChannelOpennessStrategy.getOpenness();
    }

    public int getNumGatedSodiumChannels() {
        return this.getNumUsersOfOpennessStrategy(this.sodiumChannelOpennessStrategy);
    }

    public int getNumGatedPotassiumChannels() {
        return this.getNumUsersOfOpennessStrategy(this.potassiumChannelOpennessStrategy);
    }

    private int getNumUsersOfOpennessStrategy(MembraneChannelOpennessStrategy membraneChannelOpennessStrategy) {
        int n = 0;
        for (MembraneChannel membraneChannel : this.membraneChannels) {
            if (membraneChannel.getOpennessStrategy() != membraneChannelOpennessStrategy) continue;
            ++n;
        }
        if (this.userControlledMembraneChannel != null && this.userControlledMembraneChannel.getOpennessStrategy() == membraneChannelOpennessStrategy) {
            ++n;
        }
        return n;
    }

    public void reset() {
        this.removeAllParticles();
        this.removeAllChannels();
        this.potassiumChannelOpennessStrategy.close();
        this.sodiumChannelOpennessStrategy.close();
        this.setConcentrationGraphsVisible(SHOW_GRAPHS_DEFAULT);
    }

    public void setGatedSodiumChannelsOpen(boolean bl) {
        if (bl && this.isOpennessStrategyInUse(this.sodiumChannelOpennessStrategy)) {
            this.sodiumChannelOpennessStrategy.open();
        } else {
            this.sodiumChannelOpennessStrategy.close();
        }
    }

    public void setGatedPotassiumChannelsOpen(boolean bl) {
        if (bl && this.isOpennessStrategyInUse(this.potassiumChannelOpennessStrategy)) {
            this.potassiumChannelOpennessStrategy.open();
        } else {
            this.potassiumChannelOpennessStrategy.close();
        }
    }

    public boolean injectParticle(final Particle particle) {
        if (this.particles.size() >= 100) {
            System.err.println(this.getClass().getName() + " - Warning: Ignoring attempt to add more particles than allowed.");
            return false;
        }
        if (!PARTICLE_CHAMBER_RECT.contains(particle.getPositionReference())) {
            System.err.println(this.getClass().getName() + " - Warning: Ignoring attempt to add particle outside of chamber.");
            return false;
        }
        this.particles.add(particle);
        this.notifyParticleAdded(particle);
        particle.addListener(new Particle.Adapter(){

            public void removedFromModel() {
                MembraneChannelsModel.this.particles.remove(particle);
            }
        });
        return true;
    }

    public int getRemainingParticleCapacity() {
        return 100 - this.particles.size();
    }

    private void stepInTime(double d) {
        for (MembraneChannel membraneChannel : this.membraneChannels) {
            membraneChannel.stepInTime(d);
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        ArrayList<Particle> arrayList = new ArrayList<Particle>(this.particles);
        for (Particle particle : arrayList) {
            particle.stepInTime(d);
            if (particle.getType() == ParticleType.SODIUM_ION) {
                if (particle.getPositionReference().getY() > MEMBRANE_RECT.getCenterY()) {
                    ++n;
                    continue;
                }
                ++n3;
                continue;
            }
            if (particle.getType() == ParticleType.POTASSIUM_ION) {
                if (particle.getPositionReference().getY() > MEMBRANE_RECT.getCenterY()) {
                    ++n2;
                    continue;
                }
                ++n4;
                continue;
            }
            System.out.println(this.getClass().getName() + " - Error: Unrecognized particle type.");
        }
        boolean bl = false;
        if (n != this.numSodiumInUpperChamber) {
            this.numSodiumInUpperChamber = n;
            bl = true;
        }
        if (n3 != this.numSodiumInLowerChamber) {
            this.numSodiumInLowerChamber = n3;
            bl = true;
        }
        if (n2 != this.numPotassiumInUpperChamber) {
            this.numPotassiumInUpperChamber = n2;
            bl = true;
        }
        if (n4 != this.numPotassiumInLowerChamber) {
            this.numPotassiumInLowerChamber = n4;
            bl = true;
        }
        if (bl) {
            this.notifyConcentrationsChanged();
        }
    }

    @Override
    public CaptureZoneScanResult scanCaptureZoneForFreeParticles(CaptureZone captureZone, ParticleType particleType) {
        Particle particle = null;
        double d = Double.POSITIVE_INFINITY;
        int n = 0;
        Point2D point2D = captureZone.getOriginPoint();
        for (Particle particle2 : this.particles) {
            if (particle2.getType() != particleType || !particle2.isAvailableForCapture() || !captureZone.isPointInZone(particle2.getPosition())) continue;
            ++n;
            if (particle == null) {
                particle = particle2;
                d = point2D.distance(particle.getPosition());
                continue;
            }
            if (!(point2D.distance(particle.getPosition()) < d)) continue;
            particle = particle2;
            d = point2D.distance(particle.getPosition());
        }
        return new CaptureZoneScanResult(particle, n);
    }

    public void addListener(Listener listener) {
        this.listeners.add(Listener.class, listener);
    }

    private void notifyChannelAdded(MembraneChannel membraneChannel) {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.channelAdded(membraneChannel);
        }
    }

    private void notifyParticleAdded(Particle particle) {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.particleAdded(particle);
        }
    }

    private void notifyConcentrationGraphVisibilityChanged() {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.concentrationGraphVisibilityChanged();
        }
    }

    private void notifyConcentrationsChanged() {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.concentrationsChanged();
        }
    }

    private void notifySodiumGateOpennessChanged() {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.sodiumGateOpennessChanged();
        }
    }

    private void notifyPotassiumGateOpennessChanged() {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.potassiumGateOpennessChanged();
        }
    }

    public void removeAllParticles() {
        ArrayList<Particle> arrayList = new ArrayList<Particle>(this.particles);
        this.particles.clear();
        for (Particle particle : arrayList) {
            particle.removeFromModel();
        }
    }

    private void removeAllChannels() {
        ArrayList<MembraneChannel> arrayList = new ArrayList<MembraneChannel>(this.membraneChannels);
        for (MembraneChannel membraneChannel : arrayList) {
            membraneChannel.removeFromModel();
        }
    }

    public MembraneChannel createUserControlledMembraneChannel(MembraneChannelTypes membraneChannelTypes, Point2D point2D) {
        MembraneChannelOpennessStrategy membraneChannelOpennessStrategy;
        switch (membraneChannelTypes) {
            case SODIUM_GATED_CHANNEL: {
                membraneChannelOpennessStrategy = this.sodiumChannelOpennessStrategy;
                break;
            }
            case POTASSIUM_GATED_CHANNEL: {
                membraneChannelOpennessStrategy = this.potassiumChannelOpennessStrategy;
                break;
            }
            case SODIUM_LEAKAGE_CHANNEL: {
                membraneChannelOpennessStrategy = MembraneChannelOpennessStrategy.CHANNEL_ALWAYS_OPEN;
                break;
            }
            case POTASSIUM_LEAKAGE_CHANNEL: {
                membraneChannelOpennessStrategy = MembraneChannelOpennessStrategy.CHANNEL_ALWAYS_OPEN;
                break;
            }
            default: {
                System.err.println(this.getClass().getName() + "- Error: Invalid channel type.");
                assert (false);
                membraneChannelTypes = MembraneChannelTypes.SODIUM_LEAKAGE_CHANNEL;
                membraneChannelOpennessStrategy = MembraneChannelOpennessStrategy.CHANNEL_ALWAYS_OPEN;
            }
        }
        final MembraneChannel membraneChannel = MembraneChannel.createChannel(membraneChannelTypes, this, membraneChannelOpennessStrategy);
        membraneChannel.setCenterLocation(point2D);
        this.userControlledMembraneChannel = membraneChannel;
        membraneChannel.addListener(new MembraneChannel.Adapter(){

            public void userControlledStateChanged() {
                if (membraneChannel.isUserControlled()) {
                    MembraneChannelsModel.this.membraneChannels.remove(membraneChannel);
                    MembraneChannelsModel.this.userControlledMembraneChannel = membraneChannel;
                } else {
                    MembraneChannelsModel.this.releaseUserControlledMembraneChannel();
                }
            }

            public void removed() {
                if (MembraneChannelsModel.this.membraneChannels.contains(membraneChannel)) {
                    MembraneChannelsModel.this.membraneChannels.remove(membraneChannel);
                } else if (MembraneChannelsModel.this.userControlledMembraneChannel == membraneChannel) {
                    MembraneChannelsModel.this.userControlledMembraneChannel = null;
                }
                if (MembraneChannelsModel.this.potassiumChannelOpennessStrategy.getOpenness() > 0.0 && !MembraneChannelsModel.this.isOpennessStrategyInUse(MembraneChannelsModel.this.potassiumChannelOpennessStrategy)) {
                    MembraneChannelsModel.this.potassiumChannelOpennessStrategy.close();
                }
                if (MembraneChannelsModel.this.sodiumChannelOpennessStrategy.getOpenness() > 0.0 && !MembraneChannelsModel.this.isOpennessStrategyInUse(MembraneChannelsModel.this.sodiumChannelOpennessStrategy)) {
                    MembraneChannelsModel.this.sodiumChannelOpennessStrategy.close();
                }
            }
        });
        this.notifyChannelAdded(membraneChannel);
        return membraneChannel;
    }

    private void releaseUserControlledMembraneChannel() {
        if (this.userControlledMembraneChannel == null) {
            System.err.println(this.getClass().getName() + " - Error: Attempt to release user controlled membrane channel when none is user controlled.");
            assert (this.userControlledMembraneChannel != null);
            return;
        }
        if (PARTICLE_CHAMBER_RECT.contains(this.userControlledMembraneChannel.getCenterLocation()) && this.membraneChannels.size() <= 10) {
            ArrayList<Point2D> arrayList = this.getOpenMembraneLocations();
            if (arrayList.size() == 0) {
                this.userControlledMembraneChannel.removeFromModel();
            } else {
                Point2D point2D = null;
                for (Point2D point2D2 : arrayList) {
                    if (point2D == null) {
                        point2D = point2D2;
                        continue;
                    }
                    if (!(point2D2.distance(this.userControlledMembraneChannel.getCenterLocation()) < point2D.distance(this.userControlledMembraneChannel.getCenterLocation()))) continue;
                    point2D = point2D2;
                }
                this.userControlledMembraneChannel.setCenterLocation(point2D);
                this.membraneChannels.add(this.userControlledMembraneChannel);
            }
        } else {
            this.userControlledMembraneChannel.removeFromModel();
        }
        this.userControlledMembraneChannel = null;
    }

    public boolean isMembraneFull() {
        ArrayList<Point2D> arrayList = this.getOpenMembraneLocations();
        return arrayList.size() == 0;
    }

    private boolean isOpennessStrategyInUse(MembraneChannelOpennessStrategy membraneChannelOpennessStrategy) {
        boolean bl = false;
        for (MembraneChannel membraneChannel : this.membraneChannels) {
            if (membraneChannel.getOpennessStrategy() != membraneChannelOpennessStrategy) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private ArrayList<Point2D> getOpenMembraneLocations() {
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>(this.allowableChannelLocations);
        for (MembraneChannel membraneChannel : this.membraneChannels) {
            Point2D point2D = membraneChannel.getCenterLocation();
            Point2D point2D2 = null;
            for (Point2D point2D3 : arrayList) {
                if (!point2D3.equals(point2D)) continue;
                point2D2 = point2D3;
            }
            if (point2D2 != null) {
                arrayList.remove(point2D2);
                continue;
            }
            System.out.println(this.getClass().getName() + "Error: Membrane channel not in one of the expected locations.");
            assert (false);
        }
        return arrayList;
    }

    public static class Adapter
    implements Listener {
        public void channelAdded(MembraneChannel membraneChannel) {
        }

        public void particleAdded(Particle particle) {
        }

        public void concentrationGraphVisibilityChanged() {
        }

        public void concentrationsChanged() {
        }

        public void potassiumGateOpennessChanged() {
        }

        public void sodiumGateOpennessChanged() {
        }
    }

    public static interface Listener
    extends EventListener {
        public void channelAdded(MembraneChannel var1);

        public void particleAdded(Particle var1);

        public void concentrationsChanged();

        public void concentrationGraphVisibilityChanged();

        public void sodiumGateOpennessChanged();

        public void potassiumGateOpennessChanged();
    }
}

