/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.membranechannels.model;

import edu.colorado.phet.membranechannels.MembraneChannelsConstants;
import edu.colorado.phet.membranechannels.model.CaptureZone;
import edu.colorado.phet.membranechannels.model.CaptureZoneScanResult;
import edu.colorado.phet.membranechannels.model.IMovable;
import edu.colorado.phet.membranechannels.model.IParticleCapture;
import edu.colorado.phet.membranechannels.model.MembraneChannelOpennessStrategy;
import edu.colorado.phet.membranechannels.model.MembraneChannelTypes;
import edu.colorado.phet.membranechannels.model.MembraneChannelsModel;
import edu.colorado.phet.membranechannels.model.MotionStrategy;
import edu.colorado.phet.membranechannels.model.NullCaptureZone;
import edu.colorado.phet.membranechannels.model.Particle;
import edu.colorado.phet.membranechannels.model.ParticleType;
import edu.colorado.phet.membranechannels.model.PieSliceShapedCaptureZone;
import edu.colorado.phet.membranechannels.model.TraverseChannelMotionStrategy;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Random;

public class MembraneChannel {
    protected static final Random RAND = new Random();
    protected static final double CHANNEL_HEIGHT = MembraneChannelsModel.getMembraneThickness() * 1.1;
    protected static final double CHANNEL_WIDTH = MembraneChannelsModel.getMembraneThickness() * 0.5;
    private IParticleCapture modelContainingParticles;
    private Point2D centerLocation = new Point2D.Double();
    private Dimension2D channelSize = new PDimension();
    private Dimension2D overallSize = new PDimension();
    private double openness = 0.0;
    private ArrayList<Listener> listeners = new ArrayList();
    private CaptureZone uppperCaptureZone = new NullCaptureZone();
    private CaptureZone lowerCaptureZone = new NullCaptureZone();
    private double particleVelocity = 100.0;
    private boolean userControlled = true;
    private ArrayList<Particle> particlesTraversingChannel = new ArrayList();
    protected final Color channelColor;
    protected final Color edgeColor;
    protected final ParticleType particleTypeToCapture;
    protected final MembraneChannelOpennessStrategy opennessStrategy;
    private MotionStrategy.Listener channelTraversalListener = new MotionStrategy.Adapter(){

        public void strategyComplete(IMovable iMovable) {
            assert (MembraneChannel.this.particlesTraversingChannel.contains(iMovable));
            MembraneChannel.this.particlesTraversingChannel.remove(iMovable);
            iMovable.getMotionStrategy().removeListener(MembraneChannel.this.channelTraversalListener);
        }
    };

    public MembraneChannel(IParticleCapture iParticleCapture, ParticleType particleType, Color color, Color color2, MembraneChannelOpennessStrategy membraneChannelOpennessStrategy, Point2D point2D) {
        this.modelContainingParticles = iParticleCapture;
        this.particleTypeToCapture = particleType;
        this.channelColor = color;
        this.edgeColor = color2;
        this.opennessStrategy = membraneChannelOpennessStrategy;
        this.channelSize.setSize(CHANNEL_WIDTH, CHANNEL_HEIGHT);
        this.overallSize.setSize(CHANNEL_WIDTH * 2.1, CHANNEL_HEIGHT * 1.15);
        this.setUpperCaptureZone(new PieSliceShapedCaptureZone(this.getCenterLocation(), CHANNEL_WIDTH * 4.0, -1.5707963267948966, 0.9424777960769379));
        this.setLowerCaptureZone(new PieSliceShapedCaptureZone(this.getCenterLocation(), CHANNEL_WIDTH * 4.0, 1.5707963267948966, 0.9424777960769379));
        this.setOpenness(membraneChannelOpennessStrategy.getOpenness());
        this.setCenterLocation(point2D);
        membraneChannelOpennessStrategy.addListener(new MembraneChannelOpennessStrategy.Listener(){

            public void opennessChanged() {
                MembraneChannel.this.setOpenness(MembraneChannel.this.opennessStrategy.getOpenness());
            }
        });
    }

    public MembraneChannel(IParticleCapture iParticleCapture, ParticleType particleType, Color color, Color color2, MembraneChannelOpennessStrategy membraneChannelOpennessStrategy) {
        this(iParticleCapture, particleType, color, color2, membraneChannelOpennessStrategy, new Point2D.Double(0.0, 0.0));
    }

    public static MembraneChannel createChannel(MembraneChannelTypes membraneChannelTypes, IParticleCapture iParticleCapture, MembraneChannelOpennessStrategy membraneChannelOpennessStrategy) {
        ParticleType particleType;
        Color color;
        Color color2;
        switch (membraneChannelTypes) {
            case POTASSIUM_GATED_CHANNEL: {
                color2 = MembraneChannelsConstants.POTASSIUM_GATED_CHANNEL_COLOR;
                color = MembraneChannelsConstants.POTASSIUM_GATED_EDGE_COLOR;
                particleType = ParticleType.POTASSIUM_ION;
                break;
            }
            case POTASSIUM_LEAKAGE_CHANNEL: {
                color2 = MembraneChannelsConstants.POTASSIUM_LEAKAGE_CHANNEL_COLOR;
                color = MembraneChannelsConstants.POTASSIUM_LEAKAGE_EDGE_COLOR;
                particleType = ParticleType.POTASSIUM_ION;
                break;
            }
            case SODIUM_GATED_CHANNEL: {
                color2 = MembraneChannelsConstants.SODIUM_GATED_CHANNEL_COLOR;
                color = MembraneChannelsConstants.SODIUM_GATED_EDGE_COLOR;
                particleType = ParticleType.SODIUM_ION;
                break;
            }
            case SODIUM_LEAKAGE_CHANNEL: {
                color2 = MembraneChannelsConstants.SODIUM_LEAKAGE_CHANNEL_COLOR;
                color = MembraneChannelsConstants.SODIUM_LEAKAGE_EDGE_COLOR;
                particleType = ParticleType.SODIUM_ION;
                break;
            }
            default: {
                System.err.println(MembraneChannel.class.getCanonicalName() + " - Error: Unknown channel type.");
                assert (false);
                color2 = Color.white;
                color = Color.pink;
                particleType = ParticleType.POTASSIUM_ION;
            }
        }
        return new MembraneChannel(iParticleCapture, particleType, color2, color, membraneChannelOpennessStrategy);
    }

    protected boolean isOpen() {
        return this.getOpenness() > 0.3;
    }

    public boolean isPointInChannel(Point2D point2D) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.centerLocation.getX() - this.channelSize.getHeight() / 2.0, this.centerLocation.getY() - this.channelSize.getWidth() / 2.0, this.channelSize.getHeight(), this.channelSize.getWidth());
        return double_.contains(point2D);
    }

    public void stepInTime(double d) {
        if (this.isOpen() && this.particlesTraversingChannel.size() == 0) {
            CaptureZone captureZone;
            CaptureZone captureZone2;
            if (RAND.nextBoolean()) {
                captureZone2 = this.getUpperCaptureZone();
                captureZone = this.getLowerCaptureZone();
            } else {
                captureZone2 = this.getLowerCaptureZone();
                captureZone = this.getUpperCaptureZone();
            }
            CaptureZoneScanResult captureZoneScanResult = this.modelContainingParticles.scanCaptureZoneForFreeParticles(captureZone2, this.getParticleTypeToCapture());
            Particle particle = captureZoneScanResult.getClosestFreeParticle();
            if (particle == null) {
                captureZoneScanResult = this.modelContainingParticles.scanCaptureZoneForFreeParticles(captureZone, this.getParticleTypeToCapture());
                particle = captureZoneScanResult.getClosestFreeParticle();
            }
            if (particle != null) {
                Rectangle2D rectangle2D;
                Rectangle2D rectangle2D2;
                if (this.modelContainingParticles.getUpperParticleChamberRect().contains(particle.getPositionReference())) {
                    rectangle2D2 = this.modelContainingParticles.getUpperParticleChamberRect();
                    rectangle2D = this.modelContainingParticles.getLowerParticleChamberRect();
                } else {
                    rectangle2D2 = this.modelContainingParticles.getLowerParticleChamberRect();
                    rectangle2D = this.modelContainingParticles.getUpperParticleChamberRect();
                }
                particle.setMotionStrategy(new TraverseChannelMotionStrategy(this, particle.getPosition(), rectangle2D2, rectangle2D, particle.getVelocity().getMagnitude()));
                particle.getMotionStrategy().addListener(this.channelTraversalListener);
                this.particlesTraversingChannel.add(particle);
                final Particle particle2 = particle;
                particle.addListener(new Particle.Adapter(){

                    public void removedFromModel() {
                        MembraneChannel.this.particlesTraversingChannel.remove(particle2);
                    }
                });
            }
        }
    }

    public CaptureZone getUpperCaptureZone() {
        return this.uppperCaptureZone;
    }

    protected void setUpperCaptureZone(CaptureZone captureZone) {
        this.uppperCaptureZone = captureZone;
    }

    public CaptureZone getLowerCaptureZone() {
        return this.lowerCaptureZone;
    }

    protected void setLowerCaptureZone(CaptureZone captureZone) {
        this.lowerCaptureZone = captureZone;
    }

    public Dimension2D getChannelSize() {
        return new PDimension(this.channelSize);
    }

    public Point2D getCenterLocation() {
        return new Point2D.Double(this.centerLocation.getX(), this.centerLocation.getY());
    }

    public void setCenterLocation(Point2D point2D) {
        this.setCenterLocation(point2D.getX(), point2D.getY());
    }

    public void setCenterLocation(double d, double d2) {
        if (this.centerLocation.getX() != d || this.centerLocation.getY() != d2) {
            this.centerLocation.setLocation(d, d2);
            this.uppperCaptureZone.setOriginPoint(d, d2);
            this.lowerCaptureZone.setOriginPoint(d, d2);
            this.notifyPositionChanged();
        }
    }

    public boolean isUserControlled() {
        return this.userControlled;
    }

    public void setUserControlled(boolean bl) {
        if (this.userControlled != bl) {
            this.userControlled = bl;
            if (this.userControlled) {
                for (Particle particle : this.particlesTraversingChannel) {
                    MotionStrategy motionStrategy = particle.getMotionStrategy();
                    assert (motionStrategy instanceof TraverseChannelMotionStrategy);
                    if (motionStrategy instanceof TraverseChannelMotionStrategy) {
                        ((TraverseChannelMotionStrategy)motionStrategy).abortTraversal(particle);
                        continue;
                    }
                    System.err.println(this.getClass().getName() + " Error - Particle doesn't appear to have correct motion strategy.");
                }
                this.particlesTraversingChannel.clear();
            }
            this.notifyUserControlledStateChanged();
        }
    }

    public Dimension2D getOverallSize() {
        return this.overallSize;
    }

    public double getOpenness() {
        return this.openness;
    }

    protected void setOpenness(double d) {
        if (this.openness != d) {
            this.openness = d;
            this.notifyOpennessChanged();
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void removeFromModel() {
        this.notifyRemoved();
        this.listeners.clear();
    }

    private void notifyRemoved() {
        ArrayList<Listener> arrayList = new ArrayList<Listener>(this.listeners);
        for (Listener listener : arrayList) {
            listener.removed();
        }
    }

    private void notifyOpennessChanged() {
        for (Listener listener : this.listeners) {
            listener.opennessChanged();
        }
    }

    private void notifyPositionChanged() {
        for (Listener listener : this.listeners) {
            listener.positionChanged();
        }
    }

    private void notifyUserControlledStateChanged() {
        ArrayList<Listener> arrayList = new ArrayList<Listener>(this.listeners);
        for (Listener listener : arrayList) {
            listener.userControlledStateChanged();
        }
    }

    public boolean isGated() {
        return this.opennessStrategy.isDynamic();
    }

    public Color getChannelColor() {
        return this.channelColor;
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }

    protected ParticleType getParticleTypeToCapture() {
        return this.particleTypeToCapture;
    }

    public MembraneChannelOpennessStrategy getOpennessStrategy() {
        return this.opennessStrategy;
    }

    public static class Adapter
    implements Listener {
        public void removed() {
        }

        public void opennessChanged() {
        }

        public void positionChanged() {
        }

        public void userControlledStateChanged() {
        }
    }

    public static interface Listener {
        public void removed();

        public void opennessChanged();

        public void positionChanged();

        public void userControlledStateChanged();
    }
}

