/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mazegame;

import edu.colorado.phet.mazegame.ClockPanel;
import edu.colorado.phet.mazegame.ControlBoxPanel;
import edu.colorado.phet.mazegame.MazeGameResources;
import edu.colorado.phet.mazegame.ParticleArena;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ScorePanel
extends JPanel
implements ItemListener {
    ParticleArena pArena;
    ControlBoxPanel cbPanel;
    boolean soundOn;
    boolean traceOn;
    boolean clockOn;
    JButton startBtn = new JButton(MazeGameResources.getString("ScorePanel.RestartButton"));
    JButton pauseBtn = new JButton(MazeGameResources.getString("ScorePanel.PauseButton"));
    JButton resetBtn = new JButton(MazeGameResources.getString("ScorePanel.ResetButton"));
    JCheckBox soundChkBox = new JCheckBox(MazeGameResources.getString("ScorePanel.SoundCheckBox"), true);
    JCheckBox traceChkBox = new JCheckBox(MazeGameResources.getString("ScorePanel.TraceCheckBox"), false);
    JButton scoreBtn = new JButton(MazeGameResources.getString("ScorePanel.StartButton"));
    JRadioButton radio0 = new JRadioButton(MazeGameResources.getString("ScorePanel.PracticeRadioButton"), true);
    JRadioButton radio1 = new JRadioButton(MazeGameResources.getString("ScorePanel.Level1RadioButton"), false);
    JRadioButton radio2 = new JRadioButton(MazeGameResources.getString("ScorePanel.Level2RadioButton"), false);
    JRadioButton radio3 = new JRadioButton(MazeGameResources.getString("ScorePanel.CertainDeathRadioButton"), false);
    ButtonGroup radioGroup = new ButtonGroup();
    ClockPanel myClock1;
    JLabel timeLbl = new JLabel(MazeGameResources.getString("ScorePanel.TimeLabel") + ":");
    JLabel collisionsLbl = new JLabel(MazeGameResources.getString("ScorePanel.CollisionsLabel") + ":");
    JLabel nbrCollisionsLbl = new JLabel("0");
    JLabel scoreLbl = new JLabel(MazeGameResources.getString("ScorePanel.ScoreLabel") + ":");
    JLabel ptsScoreLbl = new JLabel(MazeGameResources.getString("ScorePanel.NoGameLabel"));
    JPanel panel1 = new JPanel();
    JPanel panel2 = new JPanel();
    JPanel panel3 = new JPanel();
    JPanel panel3L = new JPanel();
    JPanel panel3R = new JPanel();
    JPanel panel4 = new JPanel();
    JPanel panel4L = new JPanel();
    JPanel panel4M = new JPanel();
    JPanel panel4R = new JPanel();

    public ScorePanel(ParticleArena particleArena, ControlBoxPanel controlBoxPanel) {
        this.setBackground(Color.green);
        this.cbPanel = controlBoxPanel;
        this.pArena = particleArena;
        this.myClock1 = new ClockPanel();
        this.clockOn = false;
        this.soundOn = true;
        this.panel1.setBackground(Color.green);
        this.panel2.setBackground(Color.green);
        this.panel3L.setBackground(Color.green);
        this.panel3R.setBackground(Color.green);
        this.panel4L.setBackground(Color.green);
        this.panel4M.setBackground(Color.green);
        this.panel4R.setBackground(Color.green);
        this.radio0.setBackground(Color.green);
        this.radio1.setBackground(Color.green);
        this.radio2.setBackground(Color.green);
        this.radio3.setBackground(Color.green);
        this.soundChkBox.setBackground(Color.green);
        this.traceChkBox.setBackground(Color.green);
        this.panel1.add(this.startBtn);
        this.panel1.add(this.pauseBtn);
        this.panel1.add(this.resetBtn);
        this.panel2.add(this.radio0);
        this.panel2.add(this.radio1);
        this.panel2.add(this.radio2);
        this.panel2.add(this.radio3);
        this.panel3L.add(this.scoreBtn);
        this.panel3R.add(this.soundChkBox);
        this.panel3R.add(this.traceChkBox);
        this.panel3.setLayout(new GridLayout(1, 2));
        this.panel3.add(this.panel3L);
        this.panel3.add(this.panel3R);
        this.nbrCollisionsLbl.setBackground(Color.white);
        this.ptsScoreLbl.setBackground(Color.white);
        this.panel4L.add(this.timeLbl);
        this.panel4L.add(this.myClock1);
        this.panel4M.add(this.collisionsLbl);
        this.panel4M.add(this.nbrCollisionsLbl);
        this.panel4R.add(this.scoreLbl);
        this.panel4R.add(this.ptsScoreLbl);
        this.panel4.setLayout(new GridLayout(1, 3));
        this.panel4.add(this.panel4L);
        this.panel4.add(this.panel4M);
        this.panel4.add(this.panel4R);
        GridLayout gridLayout = new GridLayout(4, 1, 3, 3);
        this.setLayout(gridLayout);
        this.add(this.panel1);
        this.add(this.panel2);
        this.add(this.panel3);
        this.add(this.panel4);
        this.startBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScorePanel.this.pArena.start();
                if (ScorePanel.this.clockOn) {
                    ScorePanel.this.myClock1.start();
                }
                ScorePanel.this.startBtn.setEnabled(false);
                ScorePanel.this.pauseBtn.setEnabled(true);
                ScorePanel.this.resetBtn.setEnabled(true);
            }
        });
        this.pauseBtn.addActionListener(new PauseHandler());
        this.resetBtn.addActionListener(new ResetHandler());
        this.scoreBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScorePanel.this.myClock1.start();
                ScorePanel.this.clockOn = true;
            }
        });
        this.soundChkBox.addActionListener(new SoundChkBoxHandler());
        this.traceChkBox.addActionListener(new TraceChkBoxHandler());
        this.radio0.addItemListener(this);
        this.radio1.addItemListener(this);
        this.radio2.addItemListener(this);
        this.radio3.addItemListener(this);
        this.radioGroup.add(this.radio0);
        this.radioGroup.add(this.radio1);
        this.radioGroup.add(this.radio2);
        this.radioGroup.add(this.radio3);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.radio0) {
            this.pArena.setBarrierState(0);
        } else if (itemEvent.getSource() == this.radio1) {
            this.pArena.setBarrierState(1);
        } else if (itemEvent.getSource() == this.radio2) {
            this.pArena.setBarrierState(2);
        } else if (itemEvent.getSource() == this.radio3) {
            this.pArena.setBarrierState(3);
        }
    }

    class PauseHandler
    implements ActionListener {
        PauseHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ScorePanel.this.pArena.stop();
            ScorePanel.this.myClock1.stop();
            ScorePanel.this.startBtn.setText(MazeGameResources.getString("ScorePanel.RestartButton"));
            ScorePanel.this.startBtn.setEnabled(true);
            ScorePanel.this.pauseBtn.setEnabled(false);
            ScorePanel.this.resetBtn.setEnabled(true);
        }
    }

    class ResetHandler
    implements ActionListener {
        ResetHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ScorePanel.this.pArena.start();
            ScorePanel.this.cbPanel.reset();
            ScorePanel.this.myClock1.stop();
            ScorePanel.this.myClock1.reset();
            ScorePanel.this.clockOn = false;
            ScorePanel.this.ptsScoreLbl.setText("0");
            ScorePanel.this.startBtn.setEnabled(false);
            ScorePanel.this.pauseBtn.setEnabled(true);
        }
    }

    class SoundChkBoxHandler
    implements ActionListener {
        SoundChkBoxHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ScorePanel.this.soundOn = ScorePanel.this.soundChkBox.isSelected();
        }
    }

    class TraceChkBoxHandler
    implements ActionListener {
        TraceChkBoxHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ScorePanel.this.traceChkBox.isSelected()) {
                ScorePanel.this.traceOn = true;
                ScorePanel.this.cbPanel.setTraceState(ScorePanel.this.traceOn);
            } else {
                ScorePanel.this.traceOn = false;
                ScorePanel.this.cbPanel.setTraceState(ScorePanel.this.traceOn);
                ScorePanel.this.cbPanel.setTraceStartedState(false);
                ScorePanel.this.cbPanel.setTraceToZero();
                ScorePanel.this.cbPanel.repaint();
            }
        }
    }
}

