/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mazegame;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.mazegame.ArrowA;
import edu.colorado.phet.mazegame.MazeGameResources;
import edu.colorado.phet.mazegame.MazeGameSimulationPanel;
import edu.colorado.phet.mazegame.ParticleArena;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

public class ControlBoxPanel
extends JPanel
implements ItemListener,
MouseMotionListener {
    private ArrowA arrow;
    private int x0;
    private int y0;
    private int xF;
    private int yF;
    private int controlState;
    private ParticleArena pArena;
    private GeneralPath trace;
    private boolean traceOn;
    private boolean traceStarted;
    private Font arrowFont;
    private Color fontColor;
    public static int POSITION = 0;
    public static int VELOCITY = 1;
    public static int ACCELERATION = 2;
    private JRadioButton rButton;
    private JRadioButton vButton;
    private JRadioButton aButton;
    private Border raisedBevel;
    private Border loweredBevel;
    private Border compound1;
    private Border compound2;

    public ControlBoxPanel(ParticleArena particleArena) {
        this.pArena = particleArena;
        this.raisedBevel = BorderFactory.createRaisedBevelBorder();
        this.loweredBevel = BorderFactory.createLoweredBevelBorder();
        this.compound1 = BorderFactory.createCompoundBorder(this.raisedBevel, this.loweredBevel);
        this.compound2 = BorderFactory.createTitledBorder(this.compound1, MazeGameResources.getString("ControlBoxPanel.CrontrolArrowBorder"), 2, 5);
        this.setBorder(this.compound2);
        this.arrow = new ArrowA();
        this.x0 = MazeGameSimulationPanel.fullWidth / 4;
        this.y0 = MazeGameSimulationPanel.fullHeight / 4;
        this.xF = this.x0 + 9 * (MazeGameSimulationPanel.fullWidth / 4) / 10;
        this.yF = this.y0 - 5 * (MazeGameSimulationPanel.fullHeight / 4) / 10;
        this.controlState = POSITION;
        this.trace = new GeneralPath();
        this.traceStarted = false;
        this.arrowFont = new PhetFont(40);
        this.fontColor = new Color(255, 0, 0);
        this.rButton = new JRadioButton(MazeGameResources.getString("ControlBoxPanel.PositionRadioButton"), true);
        this.rButton.setBackground(Color.yellow);
        this.vButton = new JRadioButton(MazeGameResources.getString("ControlBoxPanel.VelocityRadioButton"), false);
        this.vButton.setBackground(Color.yellow);
        this.aButton = new JRadioButton(MazeGameResources.getString("ControlBoxPanel.AccelerationRadioButton"), false);
        this.aButton.setBackground(Color.yellow);
        this.rButton.addItemListener(this);
        this.vButton.addItemListener(this);
        this.aButton.addItemListener(this);
        this.add(this.rButton);
        this.add(this.vButton);
        this.add(this.aButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rButton);
        buttonGroup.add(this.vButton);
        buttonGroup.add(this.aButton);
        this.addMouseMotionListener(this);
        this.arrow.setPosition(this.x0, this.y0, this.xF, this.yF);
        this.setBackground(Color.yellow);
    }

    public double getDeltaX() {
        return this.xF - this.x0;
    }

    public double getDeltaY() {
        return this.yF - this.y0;
    }

    public int getControlState() {
        return this.controlState;
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintComponent(graphics);
        Graphics2D graphics2D2 = (Graphics2D)graphics;
        graphics.setColor(this.fontColor);
        graphics.setFont(this.arrowFont);
        if (this.controlState == POSITION) {
            graphics.drawString(MazeGameResources.getString("ControlBoxPanel.PositionLabel"), 5 * MazeGameSimulationPanel.fullWidth / 32, 3 * MazeGameSimulationPanel.fullHeight / 8);
        } else if (this.controlState == VELOCITY) {
            graphics.drawString(MazeGameResources.getString("ControlBoxPanel.VelocityLabel"), 5 * MazeGameSimulationPanel.fullWidth / 32, 3 * MazeGameSimulationPanel.fullHeight / 8);
        } else {
            graphics.drawString(MazeGameResources.getString("ControlBoxPanel.AccelerationLabel"), MazeGameSimulationPanel.fullWidth / 8, 3 * MazeGameSimulationPanel.fullHeight / 8);
        }
        graphics.setColor(Color.black);
        graphics2D2.draw(this.trace);
        this.arrow.paint(graphics);
        graphics.setColor(Color.blue);
        graphics.fillOval(this.x0 - 4, this.y0 - 4, 8, 8);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.xF = mouseEvent.getX();
        this.yF = mouseEvent.getY();
        this.arrow.setPosition(this.x0, this.y0, this.xF, this.yF);
        if (this.traceOn && !this.traceStarted) {
            this.trace.moveTo(this.xF, this.yF);
            this.traceStarted = true;
        }
        if (this.traceOn) {
            this.trace.lineTo(this.xF, this.yF);
        }
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.rButton) {
            int n = (int)((this.pArena.getCurrentX() - (double)(MazeGameSimulationPanel.fullWidth / 2)) / this.pArena.getPositionFactor());
            int n2 = (int)((this.pArena.getCurrentY() - (double)(MazeGameSimulationPanel.fullHeight / 4)) / this.pArena.getPositionFactor());
            this.controlState = POSITION;
            this.xF = n + this.x0;
            this.yF = n2 + this.y0;
            this.arrow.setPosition(this.x0, this.y0, this.xF, this.yF);
        } else if (itemEvent.getSource() == this.vButton) {
            this.controlState = VELOCITY;
            this.xF = this.x0;
            this.yF = this.y0;
            this.arrow.setPosition(this.x0, this.y0, this.xF, this.yF);
            this.repaint();
        } else if (itemEvent.getSource() == this.aButton) {
            this.controlState = ACCELERATION;
            this.xF = this.x0;
            this.yF = this.y0;
            this.arrow.setPosition(this.x0, this.y0, this.xF, this.yF);
            this.repaint();
        }
    }

    public void reset() {
        this.rButton.doClick();
        this.xF = this.x0 + 9 * (MazeGameSimulationPanel.fullWidth / 4) / 10;
        this.yF = this.y0 - 5 * (MazeGameSimulationPanel.fullHeight / 4) / 10;
        this.arrow.setPosition(this.x0, this.y0, this.xF, this.yF);
        this.controlState = POSITION;
        this.pArena.setNbrCollisions(0);
        this.pArena.setCollisionDetected(false);
        this.pArena.setGoalDetected(false);
        this.pArena.getScorePanel().nbrCollisionsLbl.setText("0");
        this.setTraceToZero();
        this.repaint();
    }

    public void setTraceState(boolean bl) {
        this.traceOn = bl;
    }

    public void setTraceStartedState(boolean bl) {
        this.traceStarted = bl;
    }

    public void setTraceToZero() {
        this.trace.reset();
        this.traceStarted = false;
    }
}

