/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.linegraphing.pointslope.view;

import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.linegraphing.common.LGColors;
import edu.colorado.phet.linegraphing.common.LGSimSharing;
import edu.colorado.phet.linegraphing.common.model.Graph;
import edu.colorado.phet.linegraphing.common.model.Line;
import edu.colorado.phet.linegraphing.common.view.LineFormsGraphNode;
import edu.colorado.phet.linegraphing.common.view.LineFormsViewProperties;
import edu.colorado.phet.linegraphing.common.view.LineNode;
import edu.colorado.phet.linegraphing.common.view.manipulator.LineManipulatorNode;
import edu.colorado.phet.linegraphing.common.view.manipulator.SlopeDragHandler;
import edu.colorado.phet.linegraphing.common.view.manipulator.X1Y1DragHandler;
import edu.colorado.phet.linegraphing.pointslope.model.PointSlopeModel;
import edu.colorado.phet.linegraphing.pointslope.view.PointSlopeLineNode;
import java.awt.geom.Point2D;

public class PointSlopeGraphNode
extends LineFormsGraphNode {
    private final LineManipulatorNode pointManipulatorNode = new LineManipulatorNode(this.getManipulatorDiameter(), LGColors.POINT_X1_Y1);
    private final LineManipulatorNode slopeManipulatorNode;

    public PointSlopeGraphNode(final PointSlopeModel pointSlopeModel, final LineFormsViewProperties lineFormsViewProperties) {
        super(pointSlopeModel, lineFormsViewProperties);
        this.pointManipulatorNode.addInputEventListener(new X1Y1DragHandler(LGSimSharing.UserComponents.pointManipulator, UserComponentTypes.sprite, this.pointManipulatorNode, pointSlopeModel.mvt, pointSlopeModel.interactiveLine, pointSlopeModel.x1Range, pointSlopeModel.y1Range, true));
        this.slopeManipulatorNode = new LineManipulatorNode(this.getManipulatorDiameter(), LGColors.SLOPE);
        this.slopeManipulatorNode.addInputEventListener(new SlopeDragHandler(LGSimSharing.UserComponents.slopeManipulator, UserComponentTypes.sprite, this.slopeManipulatorNode, pointSlopeModel.mvt, pointSlopeModel.interactiveLine, pointSlopeModel.riseRange, pointSlopeModel.runRange));
        this.addChild(this.pointManipulatorNode);
        this.addChild(this.slopeManipulatorNode);
        pointSlopeModel.interactiveLine.addObserver(new VoidFunction1<Line>(){

            @Override
            public void apply(Line line) {
                PointSlopeGraphNode.this.pointManipulatorNode.setOffset(pointSlopeModel.mvt.modelToView(new Point2D.Double(line.x1, line.y1)));
                PointSlopeGraphNode.this.slopeManipulatorNode.setOffset(pointSlopeModel.mvt.modelToView(new Point2D.Double(line.x1 + line.run, line.y1 + line.rise)));
            }
        });
        RichSimpleObserver richSimpleObserver = new RichSimpleObserver(){

            public void update() {
                boolean bl = lineFormsViewProperties.linesVisible.get() != false && lineFormsViewProperties.interactiveLineVisible.get() != false;
                PointSlopeGraphNode.this.pointManipulatorNode.setVisible(bl);
                PointSlopeGraphNode.this.slopeManipulatorNode.setVisible(bl);
            }
        };
        richSimpleObserver.observe(lineFormsViewProperties.linesVisible, lineFormsViewProperties.interactiveLineVisible);
    }

    protected LineNode createLineNode(Line line, Graph graph, ModelViewTransform modelViewTransform) {
        return new PointSlopeLineNode(line, graph, modelViewTransform);
    }
}

