/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.linegraphing.pointslope.view;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPText;
import edu.colorado.phet.common.piccolophet.nodes.kit.ZeroOffsetNode;
import edu.colorado.phet.linegraphing.common.LGColors;
import edu.colorado.phet.linegraphing.common.LGResources;
import edu.colorado.phet.linegraphing.common.LGSimSharing;
import edu.colorado.phet.linegraphing.common.model.Line;
import edu.colorado.phet.linegraphing.common.view.DynamicValueNode;
import edu.colorado.phet.linegraphing.common.view.EquationNode;
import edu.colorado.phet.linegraphing.common.view.MinusNode;
import edu.colorado.phet.linegraphing.common.view.PlusNode;
import edu.colorado.phet.linegraphing.common.view.SlopeUndefinedNode;
import edu.colorado.phet.linegraphing.common.view.UndefinedSlopeIndicator;
import edu.colorado.phet.linegraphing.common.view.spinner.SlopeSpinnerNode;
import edu.colorado.phet.linegraphing.common.view.spinner.SpinnerNode;
import edu.colorado.phet.linegraphing.common.view.spinner.SpinnerStateIndicator;
import edu.colorado.phet.linegraphing.slopeintercept.view.SlopeInterceptEquationNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.text.MessageFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointSlopeEquationNode
extends EquationNode {
    private final Property<Double> x1;
    private final Property<Double> y1;
    private final Property<Double> rise;
    private final Property<Double> run;
    private boolean updatingControls;
    private final PNode yLeftParenNode;
    private final PNode yNode;
    private final PNode yOperatorNode;
    private final PNode y1Node;
    private final PNode yRightParenNode;
    private final PNode equalsNode;
    private final PNode slopeMinusSignNode;
    private final PNode riseNode;
    private final PNode runNode;
    private final PNode xLeftParenNode;
    private final PNode xNode;
    private final PNode xOperatorNode;
    private final PNode x1Node;
    private final PNode xRightParenNode;
    private final PNode y1MinusSignNode;
    private final PPath fractionLineNode;

    public PointSlopeEquationNode(Line line, PhetFont phetFont, Color color) {
        this(new Property<Line>(line), new Property<DoubleRange>(new DoubleRange(0.0, 1.0)), new Property<DoubleRange>(new DoubleRange(0.0, 1.0)), new Property<DoubleRange>(new DoubleRange(0.0, 1.0)), new Property<DoubleRange>(new DoubleRange(0.0, 1.0)), false, false, false, phetFont, phetFont, color);
    }

    public PointSlopeEquationNode(final Property<Line> property, Property<DoubleRange> property2, Property<DoubleRange> property3, Property<DoubleRange> property4, Property<DoubleRange> property5, final boolean bl, final boolean bl2, final boolean bl3, PhetFont phetFont, final PhetFont phetFont2, final Color color) {
        super(phetFont2.getSize());
        this.x1 = new Property<Double>(property.get().x1);
        this.y1 = new Property<Double>(property.get().y1);
        this.rise = new Property<Double>(property.get().rise);
        this.run = new Property<Double>(property.get().run);
        double d = PointSlopeEquationNode.computeMaxSlopeSpinnerWidth(property4, property5, phetFont, FORMAT);
        this.yLeftParenNode = new PhetPText("(", phetFont2, color);
        this.yNode = new PhetPText(LGResources.Strings.SYMBOL_Y, phetFont2, color);
        this.yOperatorNode = new PNode();
        this.y1Node = bl2 ? new ZeroOffsetNode((PNode)new SpinnerNode(LGSimSharing.UserComponents.y1Spinner, this.y1, property3, new SpinnerStateIndicator.X1Y1Colors(), phetFont, FORMAT)) : new DynamicValueNode(this.y1, FORMAT, phetFont2, color, true);
        this.yRightParenNode = new PhetPText(")", phetFont2, color);
        this.y1MinusSignNode = new MinusNode(this.signLineSize, color);
        this.equalsNode = new PhetPText("=", phetFont2, color);
        this.slopeMinusSignNode = new MinusNode(this.signLineSize, color);
        if (bl3) {
            this.riseNode = new ZeroOffsetNode((PNode)new SlopeSpinnerNode.RiseSpinnerNode(LGSimSharing.UserComponents.riseSpinner, this.rise, this.run, property4, new SpinnerStateIndicator.SlopeColors(), phetFont, FORMAT));
            this.runNode = new ZeroOffsetNode((PNode)new SlopeSpinnerNode.RunSpinnerNode(LGSimSharing.UserComponents.runSpinner, this.rise, this.run, property5, new SpinnerStateIndicator.SlopeColors(), phetFont, FORMAT));
        } else {
            this.riseNode = new DynamicValueNode(this.rise, FORMAT, phetFont2, color, true);
            this.runNode = new DynamicValueNode(this.run, FORMAT, phetFont2, color, true);
        }
        this.fractionLineNode = new PPath(this.createFractionLineShape(d)){
            {
                super(shape);
                this.setStroke(null);
                this.setPaint(color);
            }
        };
        this.xLeftParenNode = new PhetPText("(", phetFont2, color);
        this.xNode = new PhetPText(LGResources.Strings.SYMBOL_X, phetFont2, color);
        this.xOperatorNode = new PNode();
        this.x1Node = bl ? new ZeroOffsetNode((PNode)new SpinnerNode(LGSimSharing.UserComponents.x1Spinner, this.x1, property2, new SpinnerStateIndicator.X1Y1Colors(), phetFont, FORMAT)) : new DynamicValueNode(this.x1, FORMAT, phetFont2, color, true);
        this.xRightParenNode = new PhetPText(")", phetFont2, color);
        RichSimpleObserver richSimpleObserver = new RichSimpleObserver(){

            public void update() {
                if (!PointSlopeEquationNode.this.updatingControls) {
                    property.set(Line.createPointSlope((Double)PointSlopeEquationNode.this.x1.get(), (Double)PointSlopeEquationNode.this.y1.get(), (Double)PointSlopeEquationNode.this.rise.get(), (Double)PointSlopeEquationNode.this.run.get(), ((Line)property.get()).color));
                }
            }
        };
        richSimpleObserver.observe(this.rise, this.run, this.x1, this.y1);
        property.addObserver(new VoidFunction1<Line>(){

            @Override
            public void apply(Line line) {
                PointSlopeEquationNode.this.updatingControls = true;
                PointSlopeEquationNode.this.x1.set(line.x1);
                PointSlopeEquationNode.this.y1.set(line.y1);
                PointSlopeEquationNode.this.rise.set(bl3 ? line.rise : line.getSimplifiedRise());
                PointSlopeEquationNode.this.run.set(bl3 ? line.run : line.getSimplifiedRun());
                PointSlopeEquationNode.this.updatingControls = false;
                PointSlopeEquationNode.this.updateLayout(line, bl, bl2, bl3, phetFont2, color);
            }
        });
    }

    private void updateLayout(Line line, boolean bl, boolean bl2, boolean bl3, PhetFont phetFont, Color color) {
        PNode pNode;
        boolean bl4 = bl || bl2 || bl3;
        this.removeAllChildren();
        this.xOperatorNode.removeAllChildren();
        this.yOperatorNode.removeAllChildren();
        if (line.undefinedSlope() && !bl4) {
            this.addChild(new SlopeUndefinedNode(line, phetFont, color));
            return;
        }
        if ((line.same(Line.Y_EQUALS_X_LINE) || line.same(Line.Y_EQUALS_NEGATIVE_X_LINE)) && !bl4) {
            this.addChild(new SlopeInterceptEquationNode(Line.createSlopeIntercept(line.rise, line.run, 0.0, line.color), phetFont, color));
            return;
        }
        if (bl || line.x1 >= 0.0) {
            this.xOperatorNode.addChild(new MinusNode(this.operatorLineSize, color));
        } else {
            this.xOperatorNode.addChild(new PlusNode(this.operatorLineSize, color));
        }
        if (bl2 || line.y1 >= 0.0) {
            this.yOperatorNode.addChild(new MinusNode(this.operatorLineSize, color));
        } else {
            this.yOperatorNode.addChild(new PlusNode(this.operatorLineSize, color));
        }
        if (line.rise == 0.0 && !bl3 && !bl) {
            this.addChild(this.yNode);
            this.addChild(this.equalsNode);
            this.addChild(this.y1Node);
            this.yNode.setOffset(0.0, 0.0);
            this.equalsNode.setOffset(this.yNode.getFullBoundsReference().getMaxX() + this.relationalOperatorXSpacing, this.yNode.getYOffset());
            if (bl2 || line.y1 >= 0.0) {
                this.y1Node.setOffset(this.equalsNode.getFullBoundsReference().getMaxX() + this.relationalOperatorXSpacing, this.yNode.getFullBoundsReference().getCenterY() - this.y1Node.getFullBoundsReference().getHeight() / 2.0);
            } else {
                this.addChild(this.y1MinusSignNode);
                this.y1MinusSignNode.setOffset(this.equalsNode.getFullBoundsReference().getMaxX() + this.relationalOperatorXSpacing, this.equalsNode.getFullBoundsReference().getCenterY() - this.y1MinusSignNode.getFullBoundsReference().getHeight() / 2.0 + this.operatorYFudgeFactor);
                this.y1Node.setOffset(this.y1MinusSignNode.getFullBoundsReference().getMaxX() + this.integerSignXSpacing, this.yNode.getFullBoundsReference().getCenterY() - this.y1Node.getFullBoundsReference().getHeight() / 2.0);
            }
        } else {
            double d;
            this.addChild(this.yLeftParenNode);
            this.addChild(this.yNode);
            this.addChild(this.yOperatorNode);
            this.addChild(this.y1Node);
            this.addChild(this.yRightParenNode);
            this.yLeftParenNode.setOffset(0.0, 0.0);
            this.yNode.setOffset(this.yLeftParenNode.getFullBoundsReference().getMaxX() + this.parenXSpacing, this.yLeftParenNode.getYOffset());
            this.yOperatorNode.setOffset(this.yNode.getFullBoundsReference().getMaxX() + this.operatorXSpacing, this.equalsNode.getFullBoundsReference().getCenterY() - this.yOperatorNode.getFullBoundsReference().getHeight() / 2.0 + this.operatorYFudgeFactor);
            this.y1Node.setOffset(this.yOperatorNode.getFullBoundsReference().getMaxX() + this.operatorXSpacing, this.yNode.getFullBoundsReference().getCenterY() - this.y1Node.getFullBoundsReference().getHeight() / 2.0);
            this.yRightParenNode.setOffset(this.y1Node.getFullBoundsReference().getMaxX() + this.parenXSpacing, this.yNode.getYOffset());
            this.addChild(this.equalsNode);
            this.equalsNode.setOffset(this.yRightParenNode.getFullBoundsReference().getMaxX() + this.relationalOperatorXSpacing, this.yNode.getYOffset());
            if (bl3) {
                this.addChild(this.riseNode);
                this.addChild(this.fractionLineNode);
                this.addChild(this.runNode);
                this.fractionLineNode.setOffset(this.equalsNode.getFullBoundsReference().getMaxX() + this.relationalOperatorXSpacing, this.equalsNode.getFullBoundsReference().getCenterY() + 2.0);
                this.riseNode.setOffset(this.fractionLineNode.getFullBoundsReference().getCenterX() - this.riseNode.getFullBoundsReference().getWidth() / 2.0, this.fractionLineNode.getFullBoundsReference().getMinY() - this.riseNode.getFullBoundsReference().getHeight() - this.spinnersYSpacing);
                this.runNode.setOffset(this.fractionLineNode.getFullBoundsReference().getCenterX() - this.runNode.getFullBoundsReference().getWidth() / 2.0, this.fractionLineNode.getFullBoundsReference().getMinY() + this.spinnersYSpacing);
                pNode = this.fractionLineNode;
                d = this.fractionalSlopeXSpacing;
            } else {
                double d2 = line.getSlope();
                boolean bl5 = d2 == 0.0;
                boolean bl6 = Math.abs(d2) == 1.0;
                boolean bl7 = MathUtil.isInteger(d2);
                boolean bl8 = d2 > 0.0;
                boolean bl9 = !bl5 && !bl6 && !bl7;
                double d3 = Math.max(this.riseNode.getFullBoundsReference().getWidth(), this.runNode.getFullBoundsReference().getWidth());
                this.fractionLineNode.setPathTo(this.createFractionLineShape(d3));
                if (bl8 || bl5) {
                    pNode = this.equalsNode;
                    d = this.relationalOperatorXSpacing;
                } else {
                    this.addChild(this.slopeMinusSignNode);
                    this.slopeMinusSignNode.setOffset(this.equalsNode.getFullBoundsReference().getMaxX() + this.relationalOperatorXSpacing, this.equalsNode.getFullBoundsReference().getCenterY() - this.slopeMinusSignNode.getFullBoundsReference().getHeight() / 2.0 + this.slopeSignYFudgeFactor + this.slopeSignYOffset);
                    pNode = this.slopeMinusSignNode;
                    double d4 = d = bl9 ? this.fractionSignXSpacing : this.integerSignXSpacing;
                }
                if (line.undefinedSlope() || bl9) {
                    this.addChild(this.riseNode);
                    this.addChild(this.fractionLineNode);
                    this.addChild(this.runNode);
                    this.fractionLineNode.setOffset(pNode.getFullBoundsReference().getMaxX() + d, this.equalsNode.getFullBoundsReference().getCenterY() + 2.0);
                    this.riseNode.setOffset(this.fractionLineNode.getFullBoundsReference().getCenterX() - this.riseNode.getFullBoundsReference().getWidth() / 2.0, this.fractionLineNode.getFullBoundsReference().getMinY() - this.riseNode.getFullBoundsReference().getHeight() - this.ySpacing);
                    this.runNode.setOffset(this.fractionLineNode.getFullBoundsReference().getCenterX() - this.runNode.getFullBoundsReference().getWidth() / 2.0, this.fractionLineNode.getFullBoundsReference().getMinY() + this.ySpacing);
                    pNode = this.fractionLineNode;
                    d = this.fractionalSlopeXSpacing;
                } else if (bl5) {
                    this.addChild(this.riseNode);
                    this.riseNode.setOffset(this.equalsNode.getFullBoundsReference().getMaxX() + this.relationalOperatorXSpacing, this.yNode.getYOffset());
                    pNode = this.riseNode;
                    d = this.integerSlopeXSpacing;
                } else if (bl6) {
                    d = this.relationalOperatorXSpacing;
                } else if (bl7) {
                    this.addChild(this.riseNode);
                    this.riseNode.setOffset(pNode.getFullBoundsReference().getMaxX() + d, this.yNode.getYOffset());
                    pNode = this.riseNode;
                    d = this.integerSlopeXSpacing;
                } else {
                    throw new IllegalStateException("programming error, didn't handle some slope case");
                }
            }
            if (bl || bl3 || line.rise != 0.0) {
                this.addChild(this.xLeftParenNode);
                this.addChild(this.xNode);
                this.addChild(this.xOperatorNode);
                this.addChild(this.x1Node);
                this.addChild(this.xRightParenNode);
                this.xLeftParenNode.setOffset(pNode.getFullBoundsReference().getMaxX() + d, this.yNode.getYOffset());
                this.xNode.setOffset(this.xLeftParenNode.getFullBoundsReference().getMaxX() + this.parenXSpacing, this.yNode.getYOffset());
                this.xOperatorNode.setOffset(this.xNode.getFullBoundsReference().getMaxX() + this.operatorXSpacing, this.equalsNode.getFullBoundsReference().getCenterY() - this.xOperatorNode.getFullBoundsReference().getHeight() / 2.0 + this.operatorYFudgeFactor);
                this.x1Node.setOffset(this.xOperatorNode.getFullBoundsReference().getMaxX() + this.operatorXSpacing, this.xNode.getFullBoundsReference().getCenterY() - this.x1Node.getFullBoundsReference().getHeight() / 2.0);
                this.xRightParenNode.setOffset(this.x1Node.getFullBoundsReference().getMaxX() + this.parenXSpacing, this.yNode.getYOffset());
            } else if (line.rise != 0.0) {
                throw new IllegalStateException("programming error, didn't handle some x-term case");
            }
        }
        if (line.undefinedSlope()) {
            pNode = new UndefinedSlopeIndicator(this.getFullBoundsReference().getWidth(), this.getFullBoundsReference().getHeight());
            pNode.setOffset(0.0, this.fractionLineNode.getFullBoundsReference().getCenterY() - pNode.getFullBoundsReference().getHeight() / 2.0 + this.undefinedSlopeYFudgeFactor);
            this.addChild(pNode);
        }
    }

    public static PNode createGeneralFormNode() {
        String string = MessageFormat.format("<html>({0} - {1}<font size='-1'><sub>1</sub></font>) = {2}({3} - {4}<font size='-1'><sub>1</sub></font>)</html>", LGResources.Strings.SYMBOL_Y, LGResources.Strings.SYMBOL_Y, LGResources.Strings.SYMBOL_SLOPE, LGResources.Strings.SYMBOL_X, LGResources.Strings.SYMBOL_X);
        return new HTMLNode(string, LGColors.INTERACTIVE_LINE, new PhetFont(1, 18));
    }
}

