/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.linegraphing.linegame.view;

import edu.colorado.phet.common.games.GameOverNode;
import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.linegraphing.linegame.LineGameConstants;
import edu.colorado.phet.linegraphing.linegame.model.GamePhase;
import edu.colorado.phet.linegraphing.linegame.model.LineGameModel;
import edu.colorado.phet.linegraphing.linegame.view.RewardNode;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.geom.Dimension2D;

class ResultsNode
extends PhetPNode {
    private final RewardNode rewardNode = new RewardNode();

    public ResultsNode(final LineGameModel lineGameModel, final Dimension2D dimension2D) {
        lineGameModel.phase.addObserver(new VoidFunction1<GamePhase>(){

            @Override
            public void apply(GamePhase gamePhase) {
                if (gamePhase == GamePhase.RESULTS) {
                    if (lineGameModel.isPerfectScore()) {
                        ResultsNode.this.rewardNode.setLevel((Integer)lineGameModel.settings.level.get());
                        ResultsNode.this.addChild(ResultsNode.this.rewardNode);
                        ResultsNode.this.setRewardRunning(true);
                    }
                    GameOverNode gameOverNode = new GameOverNode((Integer)lineGameModel.settings.level.get(), lineGameModel.results.score.get().intValue(), lineGameModel.getPerfectScore(), new DefaultDecimalFormat("0"), lineGameModel.timer.time.get(), lineGameModel.results.getBestTime((Integer)lineGameModel.settings.level.get()), lineGameModel.results.isNewBestTime, (Boolean)lineGameModel.settings.timerEnabled.get(), LineGameConstants.BUTTON_COLOR);
                    gameOverNode.scale(1.5);
                    ResultsNode.this.addChild(gameOverNode);
                    gameOverNode.setOffset((dimension2D.getWidth() - gameOverNode.getFullBoundsReference().getWidth()) / 2.0, (dimension2D.getHeight() - gameOverNode.getFullBoundsReference().getHeight()) / 2.0);
                    gameOverNode.addGameOverListener(new GameOverNode.GameOverListener(){

                        public void newGamePressed() {
                            lineGameModel.phase.set(GamePhase.SETTINGS);
                        }
                    });
                } else {
                    ResultsNode.this.removeAllChildren();
                    ResultsNode.this.setRewardRunning(false);
                }
            }
        });
    }

    public void setRewardBounds(PBounds pBounds) {
        this.rewardNode.setBounds(pBounds);
    }

    public boolean isRewardRunning() {
        return this.rewardNode.isRunning();
    }

    public void setRewardRunning(boolean bl) {
        this.rewardNode.setRunning(bl);
    }
}

