/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.linegraphing.linegame.view;

import edu.colorado.phet.common.games.GameAudioPlayer;
import edu.colorado.phet.common.games.GameScoreboardNode;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.linegraphing.linegame.model.Challenge;
import edu.colorado.phet.linegraphing.linegame.model.GamePhase;
import edu.colorado.phet.linegraphing.linegame.model.LineGameModel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.geom.Dimension2D;
import java.text.DecimalFormat;

class PlayNode
extends PhetPNode {
    public PlayNode(final LineGameModel lineGameModel, Dimension2D dimension2D, final GameAudioPlayer gameAudioPlayer) {
        final GameScoreboardNode gameScoreboardNode = new GameScoreboardNode(lineGameModel.settings.level.getMax(), lineGameModel.getPerfectScore(), new DecimalFormat("0"));
        gameScoreboardNode.setBackgroundWidth(dimension2D.getWidth() - 150.0);
        gameScoreboardNode.setOffset((dimension2D.getWidth() - gameScoreboardNode.getFullBoundsReference().getWidth()) / 2.0, dimension2D.getHeight() - gameScoreboardNode.getFullBoundsReference().getHeight() - 10.0);
        this.addChild(gameScoreboardNode);
        final PDimension pDimension = new PDimension(dimension2D.getWidth(), gameScoreboardNode.getFullBoundsReference().getMinY());
        final PNode pNode = new PNode();
        this.addChild(pNode);
        gameScoreboardNode.addGameScoreboardListener(new GameScoreboardNode.GameScoreboardListener(){

            public void newGamePressed() {
                lineGameModel.phase.set(GamePhase.SETTINGS);
            }
        });
        lineGameModel.settings.level.addObserver(new SimpleObserver(){

            public void update() {
                gameScoreboardNode.setLevel((Integer)lineGameModel.settings.level.get());
            }
        });
        lineGameModel.results.score.addObserver(new SimpleObserver(){

            public void update() {
                gameScoreboardNode.setScore(lineGameModel.results.score.get().intValue());
            }
        });
        lineGameModel.settings.timerEnabled.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                gameScoreboardNode.setTimerVisible(bl);
            }
        });
        lineGameModel.timer.time.addObserver(new VoidFunction1<Long>(){

            @Override
            public void apply(Long l) {
                gameScoreboardNode.setTime(l, lineGameModel.results.getBestTime((Integer)lineGameModel.settings.level.get()));
            }
        });
        lineGameModel.challenge.addObserver(new VoidFunction1<Challenge>(){

            @Override
            public void apply(Challenge challenge) {
                pNode.removeAllChildren();
                pNode.addChild(challenge.createView(lineGameModel, pDimension, gameAudioPlayer));
            }
        });
    }
}

