/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.linegraphing.linegame.view;

import edu.colorado.phet.common.games.GameAudioPlayer;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.piccolophet.CenteredStageCanvas;
import edu.colorado.phet.linegraphing.common.LGColors;
import edu.colorado.phet.linegraphing.linegame.model.GamePhase;
import edu.colorado.phet.linegraphing.linegame.model.LineGameModel;
import edu.colorado.phet.linegraphing.linegame.view.PlayNode;
import edu.colorado.phet.linegraphing.linegame.view.ResultsNode;
import edu.colorado.phet.linegraphing.linegame.view.SettingsNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;

public class LineGameCanvas
extends CenteredStageCanvas {
    private final PNode settingsNode;
    private final PNode playNode;
    private final ResultsNode resultsNode;
    private final GameAudioPlayer audioPlayer;

    public LineGameCanvas(final LineGameModel lineGameModel) {
        this.setBackground(LGColors.CANVAS);
        this.audioPlayer = new GameAudioPlayer((Boolean)lineGameModel.settings.soundEnabled.get());
        lineGameModel.settings.soundEnabled.addObserver(new SimpleObserver(){

            public void update() {
                LineGameCanvas.this.audioPlayer.setEnabled((Boolean)lineGameModel.settings.soundEnabled.get());
            }
        });
        this.settingsNode = new SettingsNode(lineGameModel, this.getStageSize());
        this.playNode = new PlayNode(lineGameModel, this.getStageSize(), this.audioPlayer);
        this.resultsNode = new ResultsNode(lineGameModel, this.getStageSize());
        this.addChild(this.resultsNode);
        this.addChild(this.playNode);
        this.addChild(this.settingsNode);
        lineGameModel.phase.addObserver(new VoidFunction1<GamePhase>(){

            @Override
            public void apply(GamePhase gamePhase) {
                LineGameCanvas.this.settingsNode.setVisible(gamePhase == GamePhase.SETTINGS);
                LineGameCanvas.this.playNode.setVisible(gamePhase == GamePhase.PLAY);
                LineGameCanvas.this.resultsNode.setVisible(gamePhase == GamePhase.RESULTS);
                if (gamePhase == GamePhase.RESULTS) {
                    if (lineGameModel.results.score.get().intValue() == lineGameModel.getPerfectScore()) {
                        LineGameCanvas.this.audioPlayer.gameOverPerfectScore();
                    } else {
                        LineGameCanvas.this.audioPlayer.gameOverImperfectScore();
                    }
                }
            }
        });
    }

    protected void updateLayout() {
        PBounds pBounds = this.getWorldBounds();
        if (pBounds.getWidth() > 0.0 && pBounds.getHeight() > 0.0) {
            this.resultsNode.setRewardBounds(pBounds);
        }
    }

    public boolean isRewardRunning() {
        return this.resultsNode.isRewardRunning();
    }

    public void setRewardRunning(boolean bl) {
        this.resultsNode.setRewardRunning(bl);
    }
}

