/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.linegraphing.linegame.view;

import edu.colorado.phet.common.games.GameAudioPlayer;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.PhetPText;
import edu.colorado.phet.linegraphing.common.LGResources;
import edu.colorado.phet.linegraphing.common.model.Line;
import edu.colorado.phet.linegraphing.linegame.LineGameConstants;
import edu.colorado.phet.linegraphing.linegame.model.Challenge;
import edu.colorado.phet.linegraphing.linegame.model.GraphTheLine;
import edu.colorado.phet.linegraphing.linegame.model.LineGameModel;
import edu.colorado.phet.linegraphing.linegame.model.ManipulationMode;
import edu.colorado.phet.linegraphing.linegame.model.PlayState;
import edu.colorado.phet.linegraphing.linegame.view.ChallengeGraphNode;
import edu.colorado.phet.linegraphing.linegame.view.ChallengeNode;
import edu.colorado.phet.linegraphing.linegame.view.EquationBoxNode;
import edu.colorado.phet.linegraphing.linegame.view.PointSlopeGraphNode;
import edu.colorado.phet.linegraphing.linegame.view.SlopeInterceptGraphNode;
import edu.colorado.phet.linegraphing.linegame.view.TwoPointsGraphNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;

public class GraphTheLineNode
extends ChallengeNode {
    private static final PNode NOT_A_LINE = new PhetPText(LGResources.Strings.NOT_A_LINE, new PhetFont(1, 24), Color.BLACK);
    protected final ChallengeGraphNode graphNode;
    private EquationBoxNode guessBoxNode;

    public GraphTheLineNode(final GraphTheLine graphTheLine, final LineGameModel lineGameModel, PDimension pDimension, GameAudioPlayer gameAudioPlayer) {
        super(graphTheLine, lineGameModel, pDimension, gameAudioPlayer);
        PhetPText phetPText = new PhetPText(graphTheLine.title, LineGameConstants.TITLE_FONT, LineGameConstants.TITLE_COLOR);
        double d = 0.45 * pDimension.getWidth();
        if (phetPText.getFullBoundsReference().getWidth() > d) {
            phetPText.scale(d / phetPText.getFullBoundsReference().getWidth());
        }
        final PDimension pDimension2 = new PDimension(0.4 * pDimension.getWidth(), 0.3 * pDimension.getHeight());
        final EquationBoxNode equationBoxNode = new EquationBoxNode(LGResources.Strings.LINE_TO_GRAPH, graphTheLine.answer.color, pDimension2, GraphTheLineNode.createEquationNode(graphTheLine.equationForm, graphTheLine.answer, LineGameConstants.STATIC_EQUATION_FONT, graphTheLine.answer.color));
        this.guessBoxNode = new EquationBoxNode(LGResources.Strings.YOUR_LINE, Color.BLACK, pDimension2, new PNode());
        this.graphNode = this.createGraphNode(graphTheLine);
        this.graphNode.setGuessPointVisible(graphTheLine.manipulationMode == ManipulationMode.SLOPE);
        this.subclassParent.addChild(phetPText);
        this.subclassParent.addChild(this.graphNode);
        this.subclassParent.addChild(equationBoxNode);
        this.subclassParent.addChild(this.guessBoxNode);
        equationBoxNode.setOffset(pDimension.getWidth() / 2.0 - equationBoxNode.getFullBoundsReference().getWidth() - 50.0, graphTheLine.mvt.modelToViewY(0.0) - equationBoxNode.getFullBoundsReference().getHeight() - 10.0);
        this.faceNode.setOffset(equationBoxNode.getFullBoundsReference().getCenterX() - this.faceNode.getFullBoundsReference().getWidth() / 2.0, this.checkButton.getFullBoundsReference().getMaxY() - this.faceNode.getFullBoundsReference().getHeight());
        phetPText.setOffset(equationBoxNode.getFullBoundsReference().getMinX(), equationBoxNode.getFullBoundsReference().getMinY() - phetPText.getFullBoundsReference().getHeight() - 20.0);
        final VoidFunction0 voidFunction0 = new VoidFunction0(){

            public void apply() {
                equationBoxNode.setCorrectIconVisible(lineGameModel.state.get() == PlayState.NEXT);
                GraphTheLineNode.this.guessBoxNode.setCorrectIconVisible(lineGameModel.state.get() == PlayState.NEXT && graphTheLine.isCorrect());
                GraphTheLineNode.this.guessBoxNode.setIncorrectIconVisible(lineGameModel.state.get() == PlayState.NEXT && !graphTheLine.isCorrect());
            }
        };
        graphTheLine.guess.addObserver(new VoidFunction1<Line>(){

            @Override
            public void apply(Line line) {
                GraphTheLineNode.this.subclassParent.removeChild(GraphTheLineNode.this.guessBoxNode);
                PNode pNode = line == null ? NOT_A_LINE : ChallengeNode.createEquationNode(graphTheLine.equationForm, line, LineGameConstants.STATIC_EQUATION_FONT, line.color);
                Color color = line == null ? LineGameConstants.GUESS_COLOR : line.color;
                GraphTheLineNode.this.guessBoxNode = new EquationBoxNode(LGResources.Strings.YOUR_LINE, color, pDimension2, pNode);
                GraphTheLineNode.this.guessBoxNode.setOffset(equationBoxNode.getXOffset(), graphTheLine.mvt.modelToViewY(0.0) + 10.0);
                GraphTheLineNode.this.subclassParent.addChild(GraphTheLineNode.this.guessBoxNode);
                GraphTheLineNode.this.guessBoxNode.setVisible(lineGameModel.state.get() == PlayState.NEXT);
                voidFunction0.apply();
            }
        });
        lineGameModel.state.addObserver(new VoidFunction1<PlayState>(){

            @Override
            public void apply(PlayState playState) {
                GraphTheLineNode.this.graphNode.setPickable(playState == PlayState.FIRST_CHECK || playState == PlayState.SECOND_CHECK || playState == PlayState.NEXT && !graphTheLine.isCorrect());
                GraphTheLineNode.this.graphNode.setChildrenPickable(GraphTheLineNode.this.graphNode.getPickable());
                GraphTheLineNode.this.graphNode.setAnswerVisible(playState == PlayState.NEXT);
                if (playState == PlayState.NEXT && !graphTheLine.isCorrect()) {
                    GraphTheLineNode.this.guessBoxNode.setVisible(true);
                    GraphTheLineNode.this.graphNode.setAnswerPointVisible(true);
                    GraphTheLineNode.this.graphNode.setGuessPointVisible(true);
                    GraphTheLineNode.this.graphNode.setSlopeToolVisible(true);
                }
                voidFunction0.apply();
            }
        });
    }

    protected ChallengeGraphNode createGraphNode(Challenge challenge) {
        if (challenge.manipulationMode == ManipulationMode.POINT || challenge.manipulationMode == ManipulationMode.SLOPE || challenge.manipulationMode == ManipulationMode.POINT_SLOPE) {
            return new PointSlopeGraphNode(challenge);
        }
        if (challenge.manipulationMode == ManipulationMode.INTERCEPT || challenge.manipulationMode == ManipulationMode.SLOPE_INTERCEPT) {
            assert (challenge.answer.getYIntercept().isInteger());
            return new SlopeInterceptGraphNode(challenge);
        }
        if (challenge.manipulationMode == ManipulationMode.TWO_POINTS) {
            return new TwoPointsGraphNode(challenge);
        }
        throw new IllegalArgumentException("unsupported manipulationMode: " + (Object)((Object)challenge.manipulationMode));
    }
}

