/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.linegraphing.linegame.view;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.kit.ZeroOffsetNode;
import edu.colorado.phet.linegraphing.common.LGResources;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.RoundRectangle2D;

class EquationBoxNode
extends PNode {
    private final PNode correctIconNode;
    private final PNode incorrectIconNode;

    public EquationBoxNode(String string, Color color, PDimension pDimension, PNode pNode) {
        PText pText = new PText(string);
        pText.setTextPaint(color);
        pText.setFont(new PhetFont(1, 24));
        double d = pDimension.getWidth() - 40.0;
        if (pText.getFullBoundsReference().getWidth() > d) {
            pText.scale(d / pText.getFullBoundsReference().getWidth());
        }
        PPath pPath = new PPath(new RoundRectangle2D.Double(0.0, 0.0, pDimension.getWidth(), pDimension.getHeight(), 20.0, 20.0));
        pPath.setStroke(new BasicStroke(1.0f));
        pPath.setStrokePaint(Color.BLACK);
        pPath.setPaint(new Color(238, 238, 238));
        this.correctIconNode = new PImage(LGResources.Images.CHECK_MARK);
        this.incorrectIconNode = new PImage(LGResources.Images.X_MARK);
        ZeroOffsetNode zeroOffsetNode = new ZeroOffsetNode(pNode);
        this.addChild(pPath);
        this.addChild(pText);
        this.addChild(zeroOffsetNode);
        this.addChild(this.correctIconNode);
        this.addChild(this.incorrectIconNode);
        pText.setOffset(20.0, 10.0);
        double d2 = pText.getFullBoundsReference().getMaxY() + (pDimension.getHeight() - pText.getFullBoundsReference().getMaxY()) / 2.0;
        zeroOffsetNode.setOffset(20.0, d2 - zeroOffsetNode.getFullBoundsReference().getHeight() / 2.0);
        this.correctIconNode.setOffset(pPath.getFullBoundsReference().getMaxX() - this.correctIconNode.getFullBoundsReference().getWidth() - 10.0, pPath.getFullBoundsReference().getMinY() + 5.0);
        this.incorrectIconNode.setOffset(pPath.getFullBoundsReference().getMaxX() - this.incorrectIconNode.getFullBoundsReference().getWidth() - 10.0, pPath.getFullBoundsReference().getMinY() + 5.0);
        this.correctIconNode.setVisible(false);
        this.incorrectIconNode.setVisible(false);
    }

    public void setCorrectIconVisible(boolean bl) {
        this.correctIconNode.setVisible(bl);
    }

    public void setIncorrectIconVisible(boolean bl) {
        this.incorrectIconNode.setVisible(bl);
    }
}

