/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.linegraphing.linegame.view;

import edu.colorado.phet.common.games.GameAudioPlayer;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.FaceNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPText;
import edu.colorado.phet.common.piccolophet.nodes.TextButtonNode;
import edu.colorado.phet.linegraphing.common.LGResources;
import edu.colorado.phet.linegraphing.common.model.Line;
import edu.colorado.phet.linegraphing.common.view.EquationNode;
import edu.colorado.phet.linegraphing.common.view.PointToolNode;
import edu.colorado.phet.linegraphing.linegame.LineGameConstants;
import edu.colorado.phet.linegraphing.linegame.model.Challenge;
import edu.colorado.phet.linegraphing.linegame.model.EquationForm;
import edu.colorado.phet.linegraphing.linegame.model.LineGameModel;
import edu.colorado.phet.linegraphing.linegame.model.PlayState;
import edu.colorado.phet.linegraphing.pointslope.view.PointSlopeEquationNode;
import edu.colorado.phet.linegraphing.slopeintercept.view.SlopeInterceptEquationNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;

public abstract class ChallengeNode
extends PhetPNode {
    protected final FaceNode faceNode;
    protected final TextButtonNode checkButton;
    protected final PNode subclassParent;
    private final PText pointsAwardedNode;

    public ChallengeNode(final Challenge challenge, final LineGameModel lineGameModel, PDimension pDimension, final GameAudioPlayer gameAudioPlayer) {
        PhetPText phetPText = new PhetPText(challenge.description, new PhetFont(12), Color.BLACK);
        phetPText.setOffset(5.0, 5.0);
        this.faceNode = new FaceNode(120.0, LineGameConstants.FACE_COLOR, new BasicStroke(1.0f), LineGameConstants.FACE_COLOR.darker(), Color.BLACK, Color.BLACK);
        this.pointsAwardedNode = new PhetPText("", LineGameConstants.POINTS_AWARDED_FONT, LineGameConstants.POINTS_AWARDED_COLOR);
        Font font = LineGameConstants.BUTTON_FONT;
        Color color = LineGameConstants.BUTTON_COLOR;
        this.checkButton = new TextButtonNode(LGResources.Strings.CHECK, font, color);
        final TextButtonNode textButtonNode = new TextButtonNode(LGResources.Strings.TRY_AGAIN, font, color);
        final TextButtonNode textButtonNode2 = new TextButtonNode(LGResources.Strings.SHOW_ANSWER, font, color);
        final TextButtonNode textButtonNode3 = new TextButtonNode(LGResources.Strings.NEXT, font, color);
        final TextButtonNode textButtonNode4 = new TextButtonNode("dev: Skip", new PhetFont(1, 12), Color.WHITE);
        final TextButtonNode textButtonNode5 = new TextButtonNode("dev: Replay", new PhetFont(1, 12), Color.WHITE);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, pDimension.getWidth(), pDimension.getHeight());
        PointToolNode pointToolNode = new PointToolNode(challenge.pointTool1, challenge.mvt, challenge.graph, double_, new BooleanProperty(true));
        PointToolNode pointToolNode2 = new PointToolNode(challenge.pointTool2, challenge.mvt, challenge.graph, double_, new BooleanProperty(true));
        pointToolNode.scale(0.8);
        pointToolNode2.scale(0.8);
        PNode pNode = new PNode();
        pNode.addChild(pointToolNode);
        pNode.addChild(pointToolNode2);
        this.subclassParent = new PNode();
        this.addChild(this.subclassParent);
        if (PhetApplication.getInstance().isDeveloperControlsEnabled()) {
            this.addChild(phetPText);
        }
        this.addChild(this.checkButton);
        this.addChild(textButtonNode);
        this.addChild(textButtonNode2);
        this.addChild(textButtonNode3);
        if (PhetApplication.getInstance().isDeveloperControlsEnabled()) {
            this.addChild(textButtonNode4);
            this.addChild(textButtonNode5);
        }
        this.addChild(pNode);
        this.addChild(this.faceNode);
        this.addChild(this.pointsAwardedNode);
        double d = pDimension.getWidth() / 2.0;
        double d2 = pDimension.getHeight() - this.checkButton.getFullBoundsReference().getHeight() - 30.0;
        this.checkButton.setOffset(d - this.checkButton.getFullBoundsReference().getWidth() / 2.0, d2);
        textButtonNode.setOffset(d - textButtonNode.getFullBoundsReference().getWidth() / 2.0, d2);
        textButtonNode2.setOffset(d - textButtonNode2.getFullBoundsReference().getWidth() / 2.0, d2);
        textButtonNode3.setOffset(d - textButtonNode3.getFullBoundsReference().getWidth() / 2.0, d2);
        textButtonNode4.setOffset(textButtonNode3.getFullBoundsReference().getCenterX() - textButtonNode4.getFullBoundsReference().getWidth() / 2.0, textButtonNode3.getFullBoundsReference().getMaxY() + 2.0);
        textButtonNode5.setOffset(textButtonNode3.getFullBoundsReference().getCenterX() - textButtonNode5.getFullBoundsReference().getWidth() / 2.0, textButtonNode3.getFullBoundsReference().getMaxY() + 2.0);
        this.checkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (challenge.isCorrect()) {
                    ChallengeNode.this.faceNode.smile();
                    gameAudioPlayer.correctAnswer();
                    int n = lineGameModel.computePoints(lineGameModel.state.get() == PlayState.FIRST_CHECK ? 1 : 2);
                    lineGameModel.results.score.set(lineGameModel.results.score.get() + n);
                    ChallengeNode.this.pointsAwardedNode.setText(MessageFormat.format(LGResources.Strings.POINTS_AWARDED, String.valueOf(n)));
                    ChallengeNode.this.pointsAwardedNode.setOffset(ChallengeNode.this.faceNode.getFullBoundsReference().getMaxX() + 10.0, ChallengeNode.this.faceNode.getFullBoundsReference().getCenterY() - ChallengeNode.this.pointsAwardedNode.getFullBoundsReference().getHeight() / 2.0);
                    lineGameModel.state.set(PlayState.NEXT);
                } else {
                    ChallengeNode.this.faceNode.frown();
                    gameAudioPlayer.wrongAnswer();
                    ChallengeNode.this.pointsAwardedNode.setText("");
                    if (lineGameModel.state.get() == PlayState.FIRST_CHECK) {
                        lineGameModel.state.set(PlayState.TRY_AGAIN);
                    } else {
                        lineGameModel.state.set(PlayState.SHOW_ANSWER);
                    }
                }
            }
        });
        textButtonNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                lineGameModel.state.set(PlayState.SECOND_CHECK);
            }
        });
        textButtonNode2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                lineGameModel.state.set(PlayState.NEXT);
            }
        });
        textButtonNode3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                lineGameModel.state.set(PlayState.FIRST_CHECK);
            }
        });
        textButtonNode4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                lineGameModel.skipCurrentChallenge();
            }
        });
        textButtonNode5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                lineGameModel.replayCurrentChallenge();
            }
        });
        lineGameModel.state.addObserver(new VoidFunction1<PlayState>(){

            @Override
            public void apply(PlayState playState) {
                ChallengeNode.this.faceNode.setVisible(playState == PlayState.TRY_AGAIN || playState == PlayState.SHOW_ANSWER || playState == PlayState.NEXT && challenge.isCorrect());
                ChallengeNode.this.pointsAwardedNode.setVisible(ChallengeNode.this.faceNode.getVisible() && challenge.isCorrect());
                ChallengeNode.this.checkButton.setVisible(playState == PlayState.FIRST_CHECK || playState == PlayState.SECOND_CHECK);
                textButtonNode.setVisible(playState == PlayState.TRY_AGAIN);
                textButtonNode2.setVisible(playState == PlayState.SHOW_ANSWER);
                textButtonNode3.setVisible(playState == PlayState.NEXT);
                textButtonNode4.setVisible(!textButtonNode3.getVisible());
                textButtonNode5.setVisible(textButtonNode3.getVisible());
            }
        });
    }

    protected static EquationNode createEquationNode(EquationForm equationForm, Line line, PhetFont phetFont, Color color) {
        if (equationForm == EquationForm.SLOPE_INTERCEPT) {
            return new SlopeInterceptEquationNode(line, phetFont, color);
        }
        if (equationForm == EquationForm.POINT_SLOPE) {
            return new PointSlopeEquationNode(line, phetFont, color);
        }
        throw new IllegalArgumentException("unsupported equation form: " + (Object)((Object)equationForm));
    }
}

