/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.linegraphing.linegame.view;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.linegraphing.common.model.Line;
import edu.colorado.phet.linegraphing.common.view.GraphNode;
import edu.colorado.phet.linegraphing.common.view.LineNode;
import edu.colorado.phet.linegraphing.common.view.PlottedPointNode;
import edu.colorado.phet.linegraphing.common.view.SlopeToolNode;
import edu.colorado.phet.linegraphing.linegame.model.Challenge;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Color;
import java.awt.geom.Point2D;

public abstract class ChallengeGraphNode
extends GraphNode {
    private final PNode answerParentNode;
    private final PNode guessParentNode;
    private final PNode slopeToolNode;
    private final PNode answerPointNode;
    private PNode guessPointNode;
    private boolean guessPointVisible = true;

    public ChallengeGraphNode(final Challenge challenge, boolean bl) {
        super(challenge.graph, challenge.mvt);
        if (PhetApplication.getInstance().isDeveloperControlsEnabled()) {
            this.addChild(new LineNode(challenge.answer.withColor(new Color(0, 0, 0, 25)), challenge.graph, challenge.mvt));
        }
        final double d = challenge.mvt.modelToViewDeltaX(0.5);
        this.answerParentNode = new PComposite();
        LineNode lineNode = new LineNode(challenge.answer, challenge.graph, challenge.mvt);
        this.answerParentNode.addChild(lineNode);
        this.answerPointNode = new PlottedPointNode(d, challenge.answer.color);
        this.answerParentNode.addChild(this.answerPointNode);
        this.answerPointNode.setOffset(challenge.mvt.modelToView(new Point2D.Double(challenge.answer.x1, challenge.answer.y1)));
        this.guessParentNode = new PComposite();
        this.slopeToolNode = bl ? new SlopeToolNode(challenge.guess, challenge.mvt) : new PNode();
        this.addChild(this.guessParentNode);
        this.addChild(this.answerParentNode);
        this.addChild(this.slopeToolNode);
        challenge.guess.addObserver(new VoidFunction1<Line>(){

            @Override
            public void apply(Line line) {
                ChallengeGraphNode.this.guessParentNode.removeAllChildren();
                ChallengeGraphNode.this.guessPointNode = null;
                if (line != null) {
                    ChallengeGraphNode.this.guessParentNode.addChild(new LineNode(line, challenge.graph, challenge.mvt));
                    ChallengeGraphNode.this.guessPointNode = new PlottedPointNode(d, line.color);
                    ChallengeGraphNode.this.guessPointNode.setVisible(ChallengeGraphNode.this.guessPointVisible);
                    ChallengeGraphNode.this.guessParentNode.addChild(ChallengeGraphNode.this.guessPointNode);
                    ChallengeGraphNode.this.guessPointNode.setOffset(challenge.mvt.modelToView(line.x1, line.y1));
                }
            }
        });
        this.setAnswerVisible(false);
        this.setAnswerPointVisible(false);
        this.setGuessVisible(false);
        this.setGuessPointVisible(false);
        this.setSlopeToolVisible(false);
    }

    public void setAnswerVisible(boolean bl) {
        this.answerParentNode.setVisible(bl);
    }

    public void setGuessVisible(boolean bl) {
        this.guessParentNode.setVisible(bl);
    }

    public void setAnswerPointVisible(boolean bl) {
        this.answerPointNode.setVisible(bl);
    }

    public void setGuessPointVisible(boolean bl) {
        this.guessPointVisible = bl;
        if (this.guessPointNode != null) {
            this.guessPointNode.setVisible(this.guessPointVisible);
        }
    }

    public void setSlopeToolVisible(boolean bl) {
        this.slopeToolNode.setVisible(bl);
    }
}

