/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.linegraphing.linegame.model;

import edu.colorado.phet.common.games.GameSettings;
import edu.colorado.phet.common.games.GameTimer;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.util.logging.LoggingUtils;
import edu.colorado.phet.linegraphing.common.LGConstants;
import edu.colorado.phet.linegraphing.common.model.Line;
import edu.colorado.phet.linegraphing.linegame.model.Challenge;
import edu.colorado.phet.linegraphing.linegame.model.ChallengeFactory;
import edu.colorado.phet.linegraphing.linegame.model.ChallengeFactory1;
import edu.colorado.phet.linegraphing.linegame.model.ChallengeFactory2;
import edu.colorado.phet.linegraphing.linegame.model.ChallengeFactory3;
import edu.colorado.phet.linegraphing.linegame.model.ChallengeFactory4;
import edu.colorado.phet.linegraphing.linegame.model.ChallengeFactory5;
import edu.colorado.phet.linegraphing.linegame.model.ChallengeFactory6;
import edu.colorado.phet.linegraphing.linegame.model.EquationForm;
import edu.colorado.phet.linegraphing.linegame.model.GamePhase;
import edu.colorado.phet.linegraphing.linegame.model.GameResults;
import edu.colorado.phet.linegraphing.linegame.model.GraphTheLine;
import edu.colorado.phet.linegraphing.linegame.model.ManipulationMode;
import edu.colorado.phet.linegraphing.linegame.model.PlayState;
import java.util.ArrayList;
import java.util.logging.Logger;

public class LineGameModel {
    private static final Logger LOGGER = LoggingUtils.getLogger(LineGameModel.class.getCanonicalName());
    private static final IntegerRange LEVELS_RANGE = new IntegerRange(1, 6);
    private static final Challenge DUMMY_CHALLENGE = new GraphTheLine("", Line.createSlopeIntercept(1.0, 1.0, 1.0), EquationForm.SLOPE_INTERCEPT, ManipulationMode.SLOPE, LGConstants.X_AXIS_RANGE, LGConstants.Y_AXIS_RANGE);
    private final ChallengeFactory factory1 = new ChallengeFactory1();
    private final ChallengeFactory factory2 = new ChallengeFactory2();
    private final ChallengeFactory factory3 = new ChallengeFactory3();
    private final ChallengeFactory factory4 = new ChallengeFactory4();
    private final ChallengeFactory factory5 = new ChallengeFactory5();
    private final ChallengeFactory factory6 = new ChallengeFactory6();
    public final GameSettings settings;
    public final GameTimer timer;
    public final GameResults results;
    public final Property<GamePhase> phase;
    public final Property<PlayState> state;
    public final Property<Challenge> challenge;
    private ArrayList<Challenge> challenges = new ArrayList();
    private int challengeIndex;

    public LineGameModel() {
        this.settings = new GameSettings(LEVELS_RANGE, true, true);
        this.timer = new GameTimer();
        this.results = new GameResults(LEVELS_RANGE);
        this.challenge = new Property<Challenge>(DUMMY_CHALLENGE);
        this.phase = new Property<GamePhase>(GamePhase.SETTINGS){

            @Override
            public void set(GamePhase gamePhase) {
                if (gamePhase == GamePhase.SETTINGS) {
                    LineGameModel.this.state.set(PlayState.NONE);
                    LineGameModel.this.timer.stop();
                } else if (gamePhase == GamePhase.PLAY) {
                    LineGameModel.this.initChallenges();
                    LineGameModel.this.state.set(PlayState.FIRST_CHECK);
                    LineGameModel.this.results.score.set(0);
                    LineGameModel.this.timer.start();
                } else if (gamePhase == GamePhase.RESULTS) {
                    LineGameModel.this.state.set(PlayState.NONE);
                    LineGameModel.this.timer.stop();
                    LineGameModel.this.updateBestTime();
                } else {
                    throw new UnsupportedOperationException("unsupported game phase = " + (Object)((Object)gamePhase));
                }
                super.set(gamePhase);
            }
        };
        this.initChallenges();
        this.state = new Property<PlayState>(PlayState.NONE){
            {
                this.addObserver(new VoidFunction1<PlayState>(){

                    @Override
                    public void apply(PlayState playState) {
                        if (playState == PlayState.FIRST_CHECK) {
                            if (LineGameModel.this.challengeIndex == LineGameModel.this.challenges.size()) {
                                LineGameModel.this.phase.set(GamePhase.RESULTS);
                            } else {
                                LineGameModel.this.challenge.set((Challenge)LineGameModel.this.challenges.get(LineGameModel.this.challengeIndex));
                                LineGameModel.this.challengeIndex++;
                            }
                        } else if (playState == PlayState.NEXT) {
                            LineGameModel.this.challenge.get().setAnswerVisible(true);
                        }
                    }
                });
            }
        };
    }

    private void initChallenges() {
        this.challengeIndex = 0;
        switch ((Integer)this.settings.level.get()) {
            case 1: {
                this.challenges = this.factory1.createChallenges(LGConstants.X_AXIS_RANGE, LGConstants.Y_AXIS_RANGE);
                break;
            }
            case 2: {
                this.challenges = this.factory2.createChallenges(LGConstants.X_AXIS_RANGE, LGConstants.Y_AXIS_RANGE);
                break;
            }
            case 3: {
                this.challenges = this.factory3.createChallenges(LGConstants.X_AXIS_RANGE, LGConstants.Y_AXIS_RANGE);
                break;
            }
            case 4: {
                this.challenges = this.factory4.createChallenges(LGConstants.X_AXIS_RANGE, LGConstants.Y_AXIS_RANGE);
                break;
            }
            case 5: {
                this.challenges = this.factory5.createChallenges(LGConstants.X_AXIS_RANGE, LGConstants.Y_AXIS_RANGE);
                break;
            }
            case 6: {
                this.challenges = this.factory6.createChallenges(LGConstants.X_AXIS_RANGE, LGConstants.Y_AXIS_RANGE);
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported level: " + this.settings.level.get());
            }
        }
    }

    public boolean isPerfectScore() {
        return this.results.score.get().intValue() == this.getPerfectScore();
    }

    public int getPerfectScore() {
        return this.challenges.size() * this.computePoints(1);
    }

    private void updateBestTime() {
        assert (!this.timer.isRunning());
        if (((Boolean)this.settings.timerEnabled.get()).booleanValue() && this.results.score.get().intValue() == this.getPerfectScore()) {
            this.results.updateBestTime((Integer)this.settings.level.get(), this.timer.time.get());
        }
    }

    public int computePoints(int n) {
        return Math.max(0, 2 - n + 1);
    }

    public void skipCurrentChallenge() {
        assert (PhetApplication.getInstance().isDeveloperControlsEnabled());
        this.state.set(PlayState.NEXT);
        this.state.set(PlayState.FIRST_CHECK);
    }

    public void replayCurrentChallenge() {
        assert (PhetApplication.getInstance().isDeveloperControlsEnabled());
        this.challenge.get().reset();
        --this.challengeIndex;
        this.challenge.set(DUMMY_CHALLENGE);
        this.state.set(PlayState.FIRST_CHECK);
    }
}

