/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.linegraphing.linegame.model;

import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.linegraphing.common.model.Fraction;
import edu.colorado.phet.linegraphing.linegame.model.Challenge;
import edu.colorado.phet.linegraphing.linegame.model.EquationForm;
import edu.colorado.phet.linegraphing.linegame.model.ManipulationMode;
import edu.colorado.phet.linegraphing.linegame.model.RandomChooser;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChallengeFactory {
    private final Random random = new Random();
    protected final RandomChooser<Fraction> fractionChooser = new RandomChooser(this.random);
    protected final RandomChooser<Integer> integerChooser = new RandomChooser(this.random);
    protected final RandomChooser<Point2D> pointChooser = new RandomChooser(this.random);
    protected final RandomChooser<ManipulationMode> manipulationModeChooser = new RandomChooser(this.random);
    protected final RandomChooser<EquationForm> equationFormChooser = new RandomChooser(this.random);

    protected ChallengeFactory() {
    }

    public abstract ArrayList<Challenge> createChallenges(IntegerRange var1, IntegerRange var2);

    public static ArrayList<Integer> rangeToList(IntegerRange integerRange) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = integerRange.getMin(); i <= integerRange.getMax(); ++i) {
            arrayList.add(i);
        }
        assert (arrayList.size() > 0);
        return arrayList;
    }

    protected Point2D choosePointForSlope(Fraction fraction, IntegerRange integerRange, IntegerRange integerRange2) {
        int n = fraction.numerator;
        int n2 = fraction.denominator;
        IntegerRange integerRange3 = n2 >= 0 ? new IntegerRange(integerRange.getMin(), integerRange2.getMax() - n2) : new IntegerRange(integerRange.getMin() - n2, integerRange2.getMax());
        ArrayList<Integer> arrayList = ChallengeFactory.rangeToList(integerRange3);
        IntegerRange integerRange4 = n >= 0 ? new IntegerRange(integerRange2.getMin(), integerRange2.getMax() - n) : new IntegerRange(integerRange2.getMin() - n, integerRange2.getMax());
        ArrayList<Integer> arrayList2 = ChallengeFactory.rangeToList(integerRange4);
        int n3 = arrayList.get(this.randomIndex(arrayList));
        int n4 = arrayList2.get(this.randomIndex(arrayList2));
        return new Point2D.Double(n3, n4);
    }

    protected Point2D choosePointForSlopeInversion(Fraction fraction, IntegerRange integerRange, IntegerRange integerRange2) {
        int n = fraction.numerator;
        int n2 = fraction.denominator;
        IntegerRange integerRange3 = n2 >= 0 ? new IntegerRange(integerRange.getMax() - n2 + 1, integerRange.getMax()) : new IntegerRange(integerRange.getMin(), integerRange.getMin() - n2 - 1);
        ArrayList<Integer> arrayList = ChallengeFactory.rangeToList(integerRange3);
        IntegerRange integerRange4 = n >= 0 ? new IntegerRange(integerRange2.getMax() - n + 1, integerRange2.getMax()) : new IntegerRange(integerRange2.getMin(), integerRange2.getMin() - n - 1);
        ArrayList<Integer> arrayList2 = ChallengeFactory.rangeToList(integerRange4);
        int n3 = arrayList.get(this.randomIndex(arrayList));
        int n4 = arrayList2.get(this.randomIndex(arrayList2));
        int n5 = n3 + n2;
        int n6 = n4 + n;
        assert (integerRange.contains(n3) && !integerRange.contains(n5));
        assert (integerRange2.contains(n4) && !integerRange2.contains(n6));
        return new Point2D.Double(n3, n4);
    }

    protected int randomIndex(List list) {
        return this.random.nextInt(list.size());
    }
}

