/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.linegraphing.common.view.spinner;

import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.CompositeProperty;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentChain;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.ShapeUtils;
import edu.colorado.phet.common.piccolophet.event.DynamicCursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPText;
import edu.colorado.phet.linegraphing.common.view.spinner.SpinnerButtonNode;
import edu.colorado.phet.linegraphing.common.view.spinner.SpinnerStateIndicator;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Image;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.text.NumberFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpinnerNode
extends PNode {
    public SpinnerNode(IUserComponent iUserComponent, final Property<Double> property, Property<DoubleRange> property2, SpinnerStateIndicator<Color> spinnerStateIndicator, PhetFont phetFont, NumberFormat numberFormat) {
        this(iUserComponent, property, property2, spinnerStateIndicator, phetFont, numberFormat, new Function0<Double>(){

            @Override
            public Double apply() {
                return (Double)property.get() + 1.0;
            }
        }, new Function0<Double>(){

            @Override
            public Double apply() {
                return (Double)property.get() - 1.0;
            }
        });
    }

    public SpinnerNode(IUserComponent iUserComponent, Property<Double> property, Property<DoubleRange> property2, SpinnerStateIndicator<Color> spinnerStateIndicator, PhetFont phetFont, NumberFormat numberFormat, Function0<Double> function0, Function0<Double> function02) {
        this(iUserComponent, property, property2, new SpinnerStateIndicator.UpButtonImages(spinnerStateIndicator), new SpinnerStateIndicator.DownButtonImages(spinnerStateIndicator), new SpinnerStateIndicator.BackgroundColors((Color)spinnerStateIndicator.highlighted, (Color)spinnerStateIndicator.pressed), phetFont, numberFormat, function0, function02);
    }

    private SpinnerNode(IUserComponent iUserComponent, final Property<Double> property, final Property<DoubleRange> property2, SpinnerStateIndicator<Image> spinnerStateIndicator, SpinnerStateIndicator<Image> spinnerStateIndicator2, final SpinnerStateIndicator<Color> spinnerStateIndicator3, PhetFont phetFont, final NumberFormat numberFormat, Function0<Double> function0, Function0<Double> function02) {
        final BooleanProperty booleanProperty = new BooleanProperty(false);
        final BooleanProperty booleanProperty2 = new BooleanProperty(false);
        final CompositeProperty<Boolean> compositeProperty = new CompositeProperty<Boolean>(new Function0<Boolean>(){

            @Override
            public Boolean apply() {
                return (Double)property.get() < ((DoubleRange)property2.get()).getMax();
            }
        }, property, property2);
        final BooleanProperty booleanProperty3 = new BooleanProperty(false);
        final BooleanProperty booleanProperty4 = new BooleanProperty(false);
        final CompositeProperty<Boolean> compositeProperty2 = new CompositeProperty<Boolean>(new Function0<Boolean>(){

            @Override
            public Boolean apply() {
                return (Double)property.get() > ((DoubleRange)property2.get()).getMin();
            }
        }, property, property2);
        final PhetPText phetPText = new PhetPText(phetFont);
        phetPText.setPickable(false);
        phetPText.setText("-20");
        final double d = phetPText.getFullBoundsReference().getWidth() + 6.0;
        final double d2 = phetPText.getFullBoundsReference().getHeight() + 6.0;
        final RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, d, d2, 10.0, 10.0);
        PPath pPath = new PPath(){
            {
                this.setPathTo(ShapeUtils.subtract(double_, new Rectangle2D.Double(0.0, d2 / 2.0 - 0.5, d, d2)));
                this.setStroke(null);
                this.setPaint((Paint)spinnerStateIndicator3.inactive);
                this.addInputEventListener(new BackgroundMouseHandler(this, new PDimension(d, d2), booleanProperty, booleanProperty3, compositeProperty, spinnerStateIndicator3));
            }
        };
        PPath pPath2 = new PPath(){
            {
                this.setPathTo(ShapeUtils.subtract(double_, new Rectangle2D.Double(0.0, 0.0, d, d2 / 2.0 - 0.5)));
                this.setStroke(null);
                this.setPaint((Paint)spinnerStateIndicator3.inactive);
                this.addInputEventListener(new BackgroundMouseHandler(this, new PDimension(d, d2), booleanProperty2, booleanProperty4, compositeProperty2, spinnerStateIndicator3));
            }
        };
        SpinnerButtonNode<Double> spinnerButtonNode = new SpinnerButtonNode<Double>(UserComponentChain.chain(iUserComponent, "up"), spinnerStateIndicator, booleanProperty, booleanProperty3, compositeProperty, property, function0);
        SpinnerButtonNode<Double> spinnerButtonNode2 = new SpinnerButtonNode<Double>(UserComponentChain.chain(iUserComponent, "down"), spinnerStateIndicator2, booleanProperty2, booleanProperty4, compositeProperty2, property, function02);
        this.addChild(pPath);
        this.addChild(pPath2);
        this.addChild(spinnerButtonNode);
        this.addChild(spinnerButtonNode2);
        this.addChild(phetPText);
        pPath.setOffset(0.0, 0.0);
        pPath2.setOffset(0.0, 0.0);
        phetPText.setOffset(0.0, (d2 - phetPText.getFullBoundsReference().getHeight()) / 2.0);
        spinnerButtonNode.setOffset(pPath.getFullBoundsReference().getCenterX() - spinnerButtonNode.getFullBoundsReference().getWidth() / 2.0, pPath.getFullBoundsReference().getMinY() - spinnerButtonNode.getFullBoundsReference().getHeight() - 1.0);
        spinnerButtonNode2.setOffset(pPath2.getFullBoundsReference().getCenterX() - spinnerButtonNode2.getFullBoundsReference().getWidth() / 2.0, pPath2.getFullBoundsReference().getMaxY());
        property.addObserver(new SimpleObserver(){

            public void update() {
                phetPText.setText(numberFormat.format(property.get()));
                phetPText.setOffset((d - phetPText.getFullBoundsReference().getWidth()) / 2.0, phetPText.getYOffset());
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BackgroundMouseHandler
    extends PBasicInputEventHandler {
        final PNode backgroundNode;
        final PDimension buttonSize;
        final BooleanProperty pressed;
        final BooleanProperty inside;
        final ObservableProperty<Boolean> enabled;
        final SpinnerStateIndicator<Color> stateIndicator;
        final IBackgroundPaintStrategy paintStrategy;
        final DynamicCursorHandler cursorHandler;

        public BackgroundMouseHandler(PNode pNode, PDimension pDimension, BooleanProperty booleanProperty, BooleanProperty booleanProperty2, ObservableProperty<Boolean> observableProperty, SpinnerStateIndicator<Color> spinnerStateIndicator) {
            this.backgroundNode = pNode;
            this.buttonSize = pDimension;
            this.pressed = booleanProperty;
            this.inside = booleanProperty2;
            this.enabled = observableProperty;
            this.stateIndicator = spinnerStateIndicator;
            this.paintStrategy = new GradientColorStrategy();
            RichSimpleObserver richSimpleObserver = new RichSimpleObserver(){

                public void update() {
                    BackgroundMouseHandler.this.updatePaint();
                }
            };
            richSimpleObserver.observe(booleanProperty, booleanProperty2, observableProperty);
            this.cursorHandler = new DynamicCursorHandler();
            pNode.addInputEventListener(this.cursorHandler);
            observableProperty.addObserver(new VoidFunction1<Boolean>(){

                @Override
                public void apply(Boolean bl) {
                    BackgroundMouseHandler.this.cursorHandler.setCursor(bl != false ? 12 : 0);
                }
            });
        }

        @Override
        public void mousePressed(PInputEvent pInputEvent) {
            this.pressed.set(true);
        }

        @Override
        public void mouseReleased(PInputEvent pInputEvent) {
            this.pressed.set(false);
        }

        @Override
        public void mouseEntered(PInputEvent pInputEvent) {
            this.inside.set(true);
        }

        @Override
        public void mouseExited(PInputEvent pInputEvent) {
            this.inside.set(false);
        }

        private void updatePaint() {
            Paint paint = this.enabled.get() == false ? (Paint)this.stateIndicator.disabled : ((Boolean)this.pressed.get() != false ? this.paintStrategy.createPaint((Color)this.stateIndicator.pressed, this.buttonSize) : ((Boolean)this.inside.get() != false ? this.paintStrategy.createPaint((Color)this.stateIndicator.highlighted, this.buttonSize) : (Paint)this.stateIndicator.inactive));
            this.backgroundNode.setPaint(paint);
        }
    }

    private static class GradientColorStrategy
    implements IBackgroundPaintStrategy {
        private GradientColorStrategy() {
        }

        public Paint createPaint(Color color, PDimension pDimension) {
            return new GradientPaint(0.0f, 0.0f, color, 0.0f, (float)(pDimension.getHeight() / 2.0), ColorUtils.createColor(color, 0), true);
        }
    }

    private static interface IBackgroundPaintStrategy {
        public Paint createPaint(Color var1, PDimension var2);
    }
}

