/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.linegraphing.common.view.manipulator;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponentType;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.linegraphing.common.model.Line;
import edu.colorado.phet.linegraphing.common.view.manipulator.LineManipulatorDragHandler;
import edu.colorado.phet.linegraphing.common.view.manipulator.LineManipulatorNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.geom.Point2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X2Y2DragHandler
extends LineManipulatorDragHandler {
    private final Property<DoubleRange> x2Range;
    private final Property<DoubleRange> y2Range;
    private double clickXOffset;
    private double clickYOffset;

    public X2Y2DragHandler(IUserComponent iUserComponent, IUserComponentType iUserComponentType, LineManipulatorNode lineManipulatorNode, ModelViewTransform modelViewTransform, Property<Line> property, Property<DoubleRange> property2, Property<DoubleRange> property3) {
        super(iUserComponent, iUserComponentType, lineManipulatorNode, modelViewTransform, property);
        this.x2Range = property2;
        this.y2Range = property3;
    }

    @Override
    protected void startDrag(PInputEvent pInputEvent) {
        super.startDrag(pInputEvent);
        Point2D point2D = pInputEvent.getPositionRelativeTo(this.manipulatorNode.getParent());
        this.clickXOffset = point2D.getX() - this.mvt.modelToViewDeltaX(((Line)this.line.get()).x2);
        this.clickYOffset = point2D.getY() - this.mvt.modelToViewDeltaY(((Line)this.line.get()).y2);
    }

    @Override
    protected void drag(PInputEvent pInputEvent) {
        super.drag(pInputEvent);
        Point2D point2D = pInputEvent.getPositionRelativeTo(this.manipulatorNode.getParent());
        double d = MathUtil.roundHalfUp(MathUtil.clamp(this.mvt.viewToModelDeltaX(point2D.getX() - this.clickXOffset), this.x2Range.get()));
        double d2 = MathUtil.roundHalfUp(MathUtil.clamp(this.mvt.viewToModelDeltaY(point2D.getY() - this.clickYOffset), this.y2Range.get()));
        if (d != ((Line)this.line.get()).x1 || d2 != ((Line)this.line.get()).y1) {
            this.line.set(new Line(((Line)this.line.get()).x1, ((Line)this.line.get()).y1, d, d2, ((Line)this.line.get()).color));
        }
    }
}

