/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.linegraphing.common.view.manipulator;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponentType;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.linegraphing.common.model.Line;
import edu.colorado.phet.linegraphing.common.view.manipulator.LineManipulatorDragHandler;
import edu.colorado.phet.linegraphing.common.view.manipulator.LineManipulatorNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.geom.Point2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X1Y1DragHandler
extends LineManipulatorDragHandler {
    private final Property<DoubleRange> x1Range;
    private final Property<DoubleRange> y1Range;
    private double clickXOffset;
    private double clickYOffset;
    private final boolean constantSlope;

    public X1Y1DragHandler(IUserComponent iUserComponent, IUserComponentType iUserComponentType, LineManipulatorNode lineManipulatorNode, ModelViewTransform modelViewTransform, Property<Line> property, Property<DoubleRange> property2, Property<DoubleRange> property3, boolean bl) {
        super(iUserComponent, iUserComponentType, lineManipulatorNode, modelViewTransform, property);
        this.x1Range = property2;
        this.y1Range = property3;
        this.constantSlope = bl;
    }

    @Override
    protected void startDrag(PInputEvent pInputEvent) {
        super.startDrag(pInputEvent);
        Point2D point2D = pInputEvent.getPositionRelativeTo(this.manipulatorNode.getParent());
        this.clickXOffset = point2D.getX() - this.mvt.modelToViewDeltaX(((Line)this.line.get()).x1);
        this.clickYOffset = point2D.getY() - this.mvt.modelToViewDeltaY(((Line)this.line.get()).y1);
    }

    @Override
    protected void drag(PInputEvent pInputEvent) {
        super.drag(pInputEvent);
        Point2D point2D = pInputEvent.getPositionRelativeTo(this.manipulatorNode.getParent());
        double d = MathUtil.roundHalfUp(MathUtil.clamp(this.mvt.viewToModelDeltaX(point2D.getX() - this.clickXOffset), this.x1Range.get()));
        double d2 = MathUtil.roundHalfUp(MathUtil.clamp(this.mvt.viewToModelDeltaY(point2D.getY() - this.clickYOffset), this.y1Range.get()));
        if (this.constantSlope) {
            this.line.set(Line.createPointSlope(d, d2, ((Line)this.line.get()).rise, ((Line)this.line.get()).run, ((Line)this.line.get()).color));
        } else if (d != ((Line)this.line.get()).x2 || d2 != ((Line)this.line.get()).y2) {
            this.line.set(new Line(d, d2, ((Line)this.line.get()).x2, ((Line)this.line.get()).y2, ((Line)this.line.get()).color));
        }
    }
}

