/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.linegraphing.common.view.manipulator;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponentType;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.piccolophet.simsharing.SimSharingDragHandler;
import edu.colorado.phet.linegraphing.common.view.manipulator.LineManipulatorNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointDragHandler
extends SimSharingDragHandler {
    private final LineManipulatorNode manipulatorNode;
    private final ModelViewTransform mvt;
    private final Property<Vector2D> point;
    private final ArrayList<Property<Vector2D>> otherPoints;
    private final Property<DoubleRange> x1Range;
    private final Property<DoubleRange> y1Range;
    private double clickXOffset;
    private double clickYOffset;

    public PointDragHandler(IUserComponent iUserComponent, IUserComponentType iUserComponentType, LineManipulatorNode lineManipulatorNode, ModelViewTransform modelViewTransform, Property<Vector2D> property, ArrayList<Property<Vector2D>> arrayList, Property<DoubleRange> property2, Property<DoubleRange> property3) {
        super(iUserComponent, iUserComponentType, true);
        this.manipulatorNode = lineManipulatorNode;
        this.mvt = modelViewTransform;
        this.point = property;
        this.otherPoints = arrayList;
        this.x1Range = property2;
        this.y1Range = property3;
    }

    @Override
    protected void startDrag(PInputEvent pInputEvent) {
        super.startDrag(pInputEvent);
        Point2D point2D = pInputEvent.getPositionRelativeTo(this.manipulatorNode.getParent());
        this.clickXOffset = point2D.getX() - this.mvt.modelToViewDeltaX(this.point.get().x);
        this.clickYOffset = point2D.getY() - this.mvt.modelToViewDeltaY(this.point.get().y);
    }

    @Override
    protected void drag(PInputEvent pInputEvent) {
        super.drag(pInputEvent);
        Point2D point2D = pInputEvent.getPositionRelativeTo(this.manipulatorNode.getParent());
        double d = MathUtil.roundHalfUp(MathUtil.clamp(this.mvt.viewToModelDeltaX(point2D.getX() - this.clickXOffset), this.x1Range.get()));
        double d2 = MathUtil.roundHalfUp(MathUtil.clamp(this.mvt.viewToModelDeltaY(point2D.getY() - this.clickYOffset), this.y1Range.get()));
        Vector2D vector2D = new Vector2D(d, d2);
        boolean bl = false;
        for (Property<Vector2D> property : this.otherPoints) {
            if (!vector2D.equals(property.get())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.point.set(new Vector2D(d, d2));
        }
    }
}

